/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.errorcode.ReceivErrorCode;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.HotAccountEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class RecBillDeleteValidator
extends AbstractValidator {
    public void validate() {
        Set<Long> claimBills = this.getClaimcenterbills();
        Map<Long, String> payBills = this.getPaybills();
        Map param = this.getOption().getVariables();
        HashMap<Long, Boolean> recBillCheckedMap = this.getRecBillCheckedMap();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Object tmcValidator;
            Long sourceBillId;
            DynamicObject info = dataEntity.getDataEntity();
            String hotAccount = info.getString("hotaccount");
            if (HotAccountEnum.HOTBILL.getValue().equals(hotAccount) && info.getBoolean("isvoucher")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u5148\u5220\u9664\u51ed\u8bc1\u3002", (String)"RecBillDeleteImpl_1", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((String)hotAccount) && recBillCheckedMap.containsKey(info.getLong("sourcebillid")) && recBillCheckedMap.get(info.getLong("sourcebillid")).booleanValue()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d1f\u6570\u7ea2\u5b57\u6536\u6b3e\u5355\u5df2\u5bf9\u8d26\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"RecBillDeleteImpl_4", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            String sourceBillType = info.getString("sourcebilltype");
            boolean flag = "true".equals(param.get("byclaim"));
            String matchFlag = info.getString("matchflag");
            if (!(AutoMatchFlagEnum.NONE.getValue().equals(matchFlag) || AutoMatchFlagEnum.NONEED.getValue().equals(matchFlag) || flag)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5339\u914d\u8fc7\u7684\u6536\u6b3e\u5355\u4e0d\u5141\u8bb8\u5220\u9664", (String)"RecBillDeleteImpl_12", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            if ("cas_claimcenterbill".equals(sourceBillType) && claimBills.contains(sourceBillId = Long.valueOf(info.getLong("sourcebillid")))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d8\u66f4\u548c\u7533\u8bc9\u540e\u751f\u6210\u7684\u6536\u6b3e\u5355\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"RecBillDeleteImpl_2", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            if (!"true".equals(param.get("byfca")) || !"fca_transdownbill".equals(sourceBillType) && !"fca_transupbill".equals(sourceBillType)) {
                String billStatus = info.getString("billstatus");
                if (!BillStatusEnum.SAVE.getValue().equals(billStatus)) {
                    this.addErrorMessage(dataEntity, new ReceivErrorCode().STATUS_CANNOT_DELETE().getMessage());
                }
            }
            if ((tmcValidator = param.get("tmc_tm")) != null || !"tm_businessbill".equals(sourceBillType) && !"tm_structdeposit".equals(sourceBillType) && !"tm_rateswap".equals(sourceBillType) && !"tm_bond_fix".equals(sourceBillType) && !"tm_bond_float".equals(sourceBillType) && !"tm_forex_options".equals(sourceBillType)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u751f\u6210\u7684\u6536\u6b3e\u5355\u4e0d\u80fd\u76f4\u63a5\u5220\u9664\u3002", (String)"RecBillDeleteImpl_3", (String)"fi-cas-business", (Object[])new Object[0]));
        }
    }

    private Set<Long> getClaimcenterbills() {
        Set srcBillIds = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getLong("sourcebillid")).collect(Collectors.toSet());
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds), new QFilter("entryentity.e_claimtype", "in", (Object)new Object[]{"1", "2"})});
        return bills.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
    }

    private Map<Long, String> getPaybills() {
        Set srcBillIds = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getLong("sourcebillid")).collect(Collectors.toSet());
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,inneraccount,paymenttype.biztype as biztype", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds)});
        return bills.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> StringUtils.join((Object[])new Serializable[]{Long.valueOf(o.getLong("inneraccount")), "!", Long.valueOf(o.getLong("biztype"))})));
    }

    private HashMap<Long, Boolean> getRecBillCheckedMap() {
        List collectRecBillId = Stream.of(this.dataEntities).filter(recBill -> StringUtils.isEmpty((CharSequence)recBill.getDataEntity().getString("hotaccount"))).map(recBill -> recBill.getDataEntity().getLong("sourcebillid")).collect(Collectors.toList());
        DynamicObjectCollection hotRecBills = QueryServiceHelper.query((String)"cas_recbill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", collectRecBillId), new QFilter("hotaccount", "=", (Object)HotAccountEnum.HOTBILL.getValue())});
        if (CasHelper.isEmpty((Object)hotRecBills)) {
            return new HashMap<Long, Boolean>(2);
        }
        Set recBillNumbers = hotRecBills.stream().map(dynamicObject -> dynamicObject.getString("billno")).collect(Collectors.toSet());
        DynamicObjectCollection journalCheckeds = QueryServiceHelper.query((String)"cas_checkedresult", (String)"entry.sourcebillnumber recbillno", (QFilter[])new QFilter("entry.sourcebillnumber", "in", recBillNumbers).toArray());
        if (CasHelper.isEmpty((Object)journalCheckeds)) {
            return new HashMap<Long, Boolean>(2);
        }
        Map journalCheckedMap = journalCheckeds.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("recbillno"), Function.identity(), (r1, r2) -> r1));
        HashMap<Long, Boolean> recBillCheckedMap = new HashMap<Long, Boolean>(journalCheckeds.size());
        for (DynamicObject hotRecBill : hotRecBills) {
            long recBillId = hotRecBill.getLong("id");
            String recBillno = hotRecBill.getString("billno");
            if (!journalCheckedMap.containsKey(recBillno)) continue;
            recBillCheckedMap.put(recBillId, Boolean.TRUE);
        }
        return recBillCheckedMap;
    }
}

