/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.opservice.factory.RecBillFactory;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.errorcode.EBErrorCode;
import kd.fi.cas.helper.SystemParameterHelper;

public class RecChargeBackValidator
extends AbstractValidator {
    public void validate() throws KDBizException {
        EBErrorCode ebErrorCode = new EBErrorCode();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject[] claimCenters;
            String billStatus;
            DynamicObject info = dataEntity.getDataEntity();
            long orgId = (Long)info.getDynamicObject("org").getPkValue();
            Set cs110 = SystemParameterHelper.getParameterComboxs((long)orgId, (String)"cs110");
            if (!cs110.contains(billStatus = info.getString("billstatus"))) {
                this.addErrorMessage(dataEntity, ebErrorCode.BACK_STATUS_ERROR().getMessage());
                continue;
            }
            if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                RecBillFactory.unAuditRecService().validate(info);
            }
            Object sourcebillid = info.get("sourcebillid");
            Boolean flag = false;
            if (sourcebillid == null || "".equals(sourcebillid)) {
                flag = true;
            }
            if (sourcebillid != null && (claimCenters = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", sourcebillid)})).length < 1) {
                flag = true;
            }
            if (!flag.booleanValue()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6b64\u6536\u6b3e\u5355\u4e0d\u662f\u7531\u901a\u77e5\u5355\u751f\u6210\uff0c\u4e0d\u80fd\u8fdb\u884c\u9000\u5355\u3002", (String)"RecChargeBackValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

