/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.util.EmptyUtil;

public class ReceivingBillRefundValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(ReceivingBillRefundValidator.class);

    public void validate() {
        List seqList = (List)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue("selected"), List.class);
        Set tradeBillType = Stream.of("fl_rentpaybill", "lc_arrival", "lc_buyerint", "cim_finsubscribe", "cim_deposit", "cim_noticedeposit", "cim_invest_loanbill", "cfm_repaymentbill", "cfm_interestbill", "gm_letterofguarantee", "fbd_suretybill", "fbd_suretyreleasebill", "fbd_surety_append", "scf_fincreditbill", "scf_finrepaybill", "tm_businessbill", "tm_structdeposit", "tm_rateswap", "tm_forex_options").collect(Collectors.toSet());
        ArrayList<Long> payIds = new ArrayList<Long>(10);
        DynamicObjectCollection dynamicObjectCollection = this.dataEntities[0].getDataEntity().getDynamicObjectCollection("entryentity");
        for (DynamicObject rowObject : dynamicObjectCollection) {
            if (!seqList.contains((Integer)rowObject.get("seq") - 1) || !"cas_paybill".equals(rowObject.getString("billtype"))) continue;
            payIds.add(rowObject.getLong("id"));
        }
        QFilter filter = new QFilter("id", "in", payIds);
        DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"refundbillid,sourcebillid,billno,sourcebillnumber,sourcebilltype,actpayamt,billstatus,entry.e_sourcebillid,entry.e_sourcebillentryid,entry.e_refundamt", (QFilter[])new QFilter[]{filter});
        String rebillid = this.getOption().getVariableValue("rebillid");
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)rebillid, (String)"cas_recbill", (String)"id,actrecamt,fee");
        if (payBills != null && payBills.length > 0) {
            DynamicObject payBill = payBills[0];
            BigDecimal refundAmt = recBill.getBigDecimal("actrecamt");
            BigDecimal actRecAmtFee = refundAmt.add(recBill.getBigDecimal("fee"));
            BigDecimal actpayamt = payBill.getBigDecimal("actpayamt");
            Boolean isfullrefund = Boolean.TRUE;
            if (actRecAmtFee.compareTo(actpayamt) != 0) {
                isfullrefund = Boolean.FALSE;
            }
            logger.info(recBill.get("id") + "\u4ed8\u6b3e\u5355\u7f16\u53f7\uff1a" + payBill.getString("billno") + "\u4ed8\u6b3e\u5355\u91d1\u989d\uff1a" + actpayamt + "\u6536\u6b3e\u5355\u91d1\u989d\uff1a" + actRecAmtFee);
            if (EmptyUtil.isNoEmpty((DynamicObject)payBill) && !isfullrefund.booleanValue() && tradeBillType.contains(payBill.getString("sourcebilltype"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5b58\u5728\u4e0a\u6e38:%s\u4e0d\u5141\u8bb8\u64cd\u4f5c\u90e8\u5206\u9000\u6b3e\u9000\u7968\u3002", (String)"ReceivingBillRefundValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), payBill.getString("sourcebillnumber")));
            }
        }
    }
}

