/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.fi.cas.business.errorcode.ReceivErrorCode;
import kd.fi.cas.enums.BillStatusEnum;

public class ReceivingBillUnAuditValidator
extends AbstractValidator {
    public void validate() {
        ReceivErrorCode receivErrorCode = new ReceivErrorCode();
        List ids = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getString("id")).collect(Collectors.toList());
        List lockedIds = TxCheckUtil.getLocked(ids);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info;
            String billStatus;
            DynamicObject entity = dataEntity.getDataEntity();
            if (lockedIds.contains(entity.getString("id"))) {
                String error = ResManager.loadKDString((String)"\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentCancelPayValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, error, ErrorLevel.Error);
            }
            if ((billStatus = (info = dataEntity.getDataEntity()).getString("billstatus")).equals(BillStatusEnum.AUDIT.getValue())) continue;
            String content = receivErrorCode.STATUS_CANNOT_UNAUDIT().getMessage();
            this.addMessage(dataEntity, content, ErrorLevel.Error);
        }
    }
}

