/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.SystemParameterHelper;

public class ReceivingRefundValidate
extends AbstractValidator {
    public void validate() {
        List ids = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getString("id")).collect(Collectors.toList());
        Set orgIdSet = Arrays.stream(this.dataEntities).map(item -> item.getDataEntity().getLong("org.id")).collect(Collectors.toSet());
        Map systemParamsCdmMap = SystemParameterHelper.getSystemParamsCdmByOrgIds(new ArrayList(orgIdSet));
        List lockedIds = TxCheckUtil.getLocked(ids);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            String key = DraftHelper.getKey((Object)info.get("settletype"));
            DynamicObject org = info.getDynamicObject("org");
            BigDecimal actRecAmt = info.getBigDecimal("actrecamt");
            if (lockedIds.contains(dataEntity.getDataEntity().getString("id"))) {
                String error = ResManager.loadKDString((String)"\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentCancelPayValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, error, ErrorLevel.Error);
            }
            if (actRecAmt.compareTo(new BigDecimal("0")) >= 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u6536\u6b3e\u91d1\u989d\u5c0f\u4e8e0\uff0c\u4e0d\u5141\u8bb8\u9000\u6b3e\u9000\u7968\u3002", (String)"ReceivingRefundOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

