/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.checkAcct;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.util.DateUtils;

public class BalanceAdjustUnValidator
extends AbstractValidator {
    public void validate() {
        DynamicObject info;
        ExtendedDataEntity[] datas = this.dataEntities;
        ArrayList<Object> ids = new ArrayList<Object>(datas.length);
        for (ExtendedDataEntity data : datas) {
            info = data.getDataEntity();
            ids.add(info.getPkValue());
        }
        for (ExtendedDataEntity data : datas) {
            info = data.getDataEntity();
            DynamicObject bankAccount = info.getDynamicObject("bankaccount");
            DynamicObject org = info.getDynamicObject("org");
            DynamicObject currency = info.getDynamicObject("currency");
            Date bizDate = info.getDate("bizdate");
            QFilter filter = new QFilter("org", "=", org.getPkValue()).and("bankaccount", "=", bankAccount.getPkValue()).and("currency", "=", currency.getPkValue()).and("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)bizDate, (boolean)true)).and("period", "!=", (Object)0).and("id", "not in", ids);
            Boolean isExistsBalance = QueryServiceHelper.exists((String)"cas_balanceadjust", (QFilter[])filter.toArray());
            String dateStr = DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd");
            if (!isExistsBalance.booleanValue()) continue;
            String operateKey = this.getOperateKey();
            if ("unaudit".equals(operateKey)) {
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6279\u5931\u8d25\u3002%1$s\u4e4b\u540e\u5b58\u5728\u4f59\u989d\u8c03\u8282\u8868\uff0c\u5f53\u524d\u64cd\u4f5c\u53ef\u80fd\u4f1a\u5f71\u54cd\u4f59\u989d\u8c03\u8282\u8868\u6570\u636e\uff0c\u8bf7\u5c06%2$s\u4e4b\u540e\u7684\u4f59\u989d\u8c03\u8282\u8868\u5220\u9664\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BalanceAdjustUnauditValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), dateStr, dateStr), ErrorLevel.FatalError);
                continue;
            }
            if ("unsubmit".equals(operateKey)) {
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25\u3002%1$s\u4e4b\u540e\u5b58\u5728\u4f59\u989d\u8c03\u8282\u8868\uff0c\u5f53\u524d\u64cd\u4f5c\u53ef\u80fd\u4f1a\u5f71\u54cd\u4f59\u989d\u8c03\u8282\u8868\u6570\u636e\uff0c\u8bf7\u5c06%2$s\u4e4b\u540e\u7684\u4f59\u989d\u8c03\u8282\u8868\u7f6e\u5220\u9664\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BalanceAdjustUnauditValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), dateStr, dateStr), ErrorLevel.FatalError);
                continue;
            }
            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002%1$s\u4e4b\u540e\u5b58\u5728\u4f59\u989d\u8c03\u8282\u8868\uff0c\u5f53\u524d\u64cd\u4f5c\u53ef\u80fd\u4f1a\u5f71\u54cd\u4f59\u989d\u8c03\u8282\u8868\u6570\u636e\uff0c\u8bf7\u5c06%2$s\u4e4b\u540e\u7684\u4f59\u989d\u8c03\u8282\u8868\u7f6e\u5220\u9664\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BalanceAdjustUnauditValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), dateStr, dateStr), ErrorLevel.FatalError);
        }
    }
}

