/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.common;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;

public class TxLockValidator
extends AbstractValidator {
    public void validate() throws KDBizException {
        List businessIdList = Arrays.stream(this.dataEntities).map(d -> String.valueOf(d.getDataEntity().getPkValue())).filter(d -> !"0".equals(d)).distinct().collect(Collectors.toList());
        if (businessIdList.isEmpty()) {
            return;
        }
        String isLock = "false";
        if (this.getOption().containsVariable("isLock")) {
            isLock = this.getOption().getVariableValue("isLock");
        }
        if ("true".equals(isLock)) {
            return;
        }
        List lockBusinessIds = TxCheckUtil.getLocked(businessIdList);
        if (!lockBusinessIds.isEmpty()) {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject info = dataEntity.getDataEntity();
                if (!lockBusinessIds.contains(String.valueOf(info.getPkValue()))) continue;
                String message = ResManager.loadKDString((String)"\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"TxLockValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, message);
            }
        }
    }
}

