/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.entrust;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;

public class EntrustLockHelper {
    private final String entityName;
    private final DynamicObject[] bills;
    private final Set<DLock> LOCKS = new HashSet<DLock>();

    public EntrustLockHelper(String entityName, DynamicObject[] bills) {
        this.entityName = entityName;
        this.bills = bills;
    }

    public boolean lock() {
        for (DynamicObject bill : this.bills) {
            String lockKey = "lock_entrust_" + this.entityName + "_" + bill.getPkValue();
            DLock dLock = DLock.create((String)lockKey, (String)("entrust lock: " + bill.getPkValue()));
            this.LOCKS.add(dLock);
            if (dLock.tryLock()) continue;
            return false;
        }
        return true;
    }

    public void unlock() {
        if (!this.LOCKS.isEmpty()) {
            for (DLock lock : this.LOCKS) {
                lock.unlock();
            }
        }
    }
}

