/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.util.EmptyUtil;

public class RefundValidatorHelper {
    public static boolean checkPayBillIsFullRenote(DynamicObjectCollection entryList, List<DynamicObject> payBills, String entryAmtKey) {
        Map<String, List<DynamicObject>> corePays = entryList.stream().filter(e -> "cas_paybill".equals(e.getString("e_corebilltype"))).collect(Collectors.groupingBy(e -> e.getString("e_corebillno")));
        Map<String, DynamicObject> payBillMap = payBills.stream().collect(Collectors.toMap(p -> p.getString("billno"), p -> p));
        for (Map.Entry<String, List<DynamicObject>> coreBillEntry : corePays.entrySet()) {
            DynamicObject payBill = payBillMap.get(coreBillEntry.getKey());
            BigDecimal receivAbleAmt = coreBillEntry.getValue().stream().map(e -> e.getBigDecimal(entryAmtKey)).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (BillStatusEnum.PAY.getValue().equals(payBill.getString("billstatus")) && receivAbleAmt.compareTo(payBill.getBigDecimal("dpamt")) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean checkAgentBillIsFullRenote(DynamicObjectCollection entryList, String entryAmtKey) {
        List revEntryList = entryList.stream().filter(e -> "cas_agentpaybill".equals(e.getString("e_corebilltype"))).collect(Collectors.toList());
        for (DynamicObject entry : revEntryList) {
            long coreBillEntryId;
            String coreBillNo = entry.getString("e_corebillno");
            QFilter filter = new QFilter("billno", "=", (Object)coreBillNo).and("entry.id", "=", (Object)(coreBillEntryId = entry.getLong("e_corebillentryid")));
            DynamicObject agentWithEntry = QueryServiceHelper.queryOne((String)"cas_agentpaybill", (String)"id,isencryption,entry.e_issuccess,entry.e_isrefund,entry.e_amount,entry.e_encryptamount", (QFilter[])filter.toArray());
            if (!agentWithEntry.getBoolean("entry.e_issuccess")) {
                return false;
            }
            if (agentWithEntry.getBoolean("entry.e_isrefund")) {
                return false;
            }
            BigDecimal agentEntryAmt = agentWithEntry.getBoolean("isencryption") ? AgentPayBillHelper.decodeAmount((String)agentWithEntry.getString("entry.e_encryptamount")) : agentWithEntry.getBigDecimal("entry.e_amount");
            if (agentEntryAmt.compareTo(entry.getBigDecimal(entryAmtKey)) == 0) continue;
            return false;
        }
        return true;
    }

    public static List<Integer> checkPayBillIsSelectSame(DynamicObjectCollection entryList) {
        Map<String, List<DynamicObject>> entryMapByCoreBillNo = entryList.stream().filter(e -> "cas_paybill".equals(e.getString("e_corebilltype"))).collect(Collectors.groupingBy(e -> e.getString("e_corebillno")));
        for (List<DynamicObject> groupEntryList : entryMapByCoreBillNo.values()) {
            boolean haveEmpty;
            if (groupEntryList.size() <= 1 || !(haveEmpty = groupEntryList.stream().anyMatch(e -> EmptyUtil.isEmpty((Long)e.getLong("e_corebillentryid")))) || !groupEntryList.stream().anyMatch(e -> EmptyUtil.isNoEmpty((Long)e.getLong("e_corebillentryid")))) continue;
            return groupEntryList.stream().map(e -> entryList.indexOf(e) + 1).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<Integer> checkAgentBillIsSelectEntry(DynamicObjectCollection entryList) {
        ArrayList<Integer> lineNos = new ArrayList<Integer>(entryList.size());
        for (int i = 0; i < entryList.size(); ++i) {
            DynamicObject revEntry = (DynamicObject)entryList.get(i);
            String coreBillType = revEntry.getString("e_corebilltype");
            if (!"cas_agentpaybill".equals(coreBillType) || !EmptyUtil.isEmpty((Long)revEntry.getLong("e_corebillentryid"))) continue;
            lineNos.add(i + 1);
        }
        return lineNos;
    }

    public static Set<String> getPayAndAgentCoreBillTypes(DynamicObjectCollection entryList) {
        return entryList.stream().map(en -> en.getString("e_corebilltype")).filter(billType -> "cas_paybill".equals(billType) || "cas_agentpaybill".equals(billType)).collect(Collectors.toSet());
    }

    public static boolean checkDifferCurrencyPay(List<DynamicObject> payBills) {
        Set collect = payBills.stream().map(p -> p.getBoolean("isdiffcur")).collect(Collectors.toSet());
        return collect.size() > 1;
    }

    public static List<DynamicObject> getPayBillsByCoreEntrys(DynamicObjectCollection entryList) {
        Set coreBillNoSet = entryList.stream().map(e -> e.getString("e_corebillno")).collect(Collectors.toSet());
        QFilter filter = new QFilter("billno", "in", coreBillNoSet);
        return QueryServiceHelper.query((String)"cas_paybill", (String)"id,billno,billstatus,dpamt,isdiffcur", (QFilter[])filter.toArray());
    }
}

