/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.pay;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.util.EmptyUtil;

public abstract class AccountCashValidator
extends AbstractValidator {
    public void validate() {
        Set cashIds;
        String name = this.dataEntities[0].getDataEntity().getDataEntityType().getName();
        String cashProp = this.getAccCashProp() + ".id";
        if ("cas_paybill".equals(name)) {
            cashIds = ((Stream)Arrays.stream(this.dataEntities).parallel()).filter(e -> EmptyUtil.isNoEmpty((Long)e.getDataEntity().getLong(cashProp))).map(e -> e.getDataEntity().getLong(cashProp)).collect(Collectors.toSet());
            Set recCashIds = ((Stream)Arrays.stream(this.dataEntities).parallel()).filter(e -> EmptyUtil.isNoEmpty((Long)e.getDataEntity().getLong("payeeacctcash"))).map(e -> e.getDataEntity().getLong("payeeacctcash")).collect(Collectors.toSet());
            if (recCashIds.size() > 0) {
                cashIds.addAll(recCashIds);
            }
        } else {
            cashIds = ((Stream)Arrays.stream(this.dataEntities).parallel()).filter(e -> EmptyUtil.isNoEmpty((Long)e.getDataEntity().getLong(cashProp))).map(e -> e.getDataEntity().getLong(cashProp)).collect(Collectors.toSet());
        }
        if (cashIds.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", cashIds);
            Map cashMap = BusinessDataServiceHelper.loadFromCache((String)"cas_accountcash", (String)"id,closestatus,enable,org", (QFilter[])qFilter.toArray());
            for (ExtendedDataEntity data : this.dataEntities) {
                DynamicObject info = data.getDataEntity();
                this.showErrorMessage(data, info, cashProp, cashMap, "normal");
                if (!"cas_paybill".equals(name) || !PayBusinessTypeEnum.CASHOUT.getValue().equals(info.getString("businesstype"))) continue;
                this.showErrorMessage(data, info, "payeeacctcash", cashMap, "rec");
            }
        }
    }

    private void showErrorMessage(ExtendedDataEntity data, DynamicObject info, String cashProp, Map<Object, DynamicObject> cashMap, String type) {
        Long cashId = info.getLong(cashProp);
        if (EmptyUtil.isNoEmpty((Long)cashId) && cashMap.containsKey(cashId)) {
            DynamicObject caseInfo = cashMap.get(cashId);
            DynamicObject org = info.getDynamicObject("org");
            if (!org.getPkValue().equals(caseInfo.getDynamicObject("org").getPkValue())) {
                this.addErrorMessage(data, this.showOrgErrorMessage(type));
            }
            if ("1".equals(caseInfo.getString("closestatus"))) {
                this.addErrorMessage(data, this.showCloseStatusErrorMessage(type));
            }
            if ("0".equals(caseInfo.getString("enable"))) {
                this.addErrorMessage(data, this.showEnableErrorMessage(type));
            }
        }
    }

    protected abstract String getAccCashProp();

    protected abstract String showOrgErrorMessage(String var1);

    protected abstract String showCloseStatusErrorMessage(String var1);

    protected abstract String showEnableErrorMessage(String var1);

    protected String getName(String type) {
        String name = ResManager.loadKDString((String)"\u4ed8\u6b3e", (String)"AccountCashValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]);
        if ("rec".equals(type)) {
            name = ResManager.loadKDString((String)"\u6536\u6b3e", (String)"AccountCashValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
        }
        return name;
    }
}

