/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.payapply;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.enums.PayApplyBillStatusEnum;
import kd.fi.cas.enums.PayApplyPayStatusEnum;
import kd.fi.cas.enums.PayApplyRecChgStatusEnum;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.LoggerPrintHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayApplyBatchScheValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(PayApplyBatchScheValidator.class);

    public void validate() {
        boolean result = true;
        boolean isForceStop = false;
        HashSet<String> allBillNo = new HashSet<String>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject payApplyDy = dataEntity.getDataEntity();
            allBillNo.add(payApplyDy.getString("billno"));
            long id = Optional.ofNullable(payApplyDy.getPkValue()).map(o -> Long.parseLong(o.toString())).orElseGet(() -> 0L);
            if (0 == Long.compare(id, 0L)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\uff0c\u518d\u8fdb\u884c\u6279\u91cf\u6392\u6b3e\u64cd\u4f5c\u3002", (String)"PayApplyBatchScheValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                result = false;
                isForceStop = true;
            }
            if (result && payApplyDy.getBoolean("invalidflag")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5df2\u7ecf\u4f5c\u5e9f\uff0c\u4e0d\u652f\u6301\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PayApplyBatchScheValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                result = false;
                isForceStop = true;
            }
            String billStatus = payApplyDy.getString("billstatus");
            if (!isForceStop && PayApplyBillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u6216\u8005\u5ba1\u6838\u901a\u8fc7\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u5141\u8bb8\u64cd\u4f5c\u6279\u91cf\u6392\u6b3e\u3002", (String)"PayApplyComfirmScheValidator_18", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                result = false;
            }
            String headerstatus = payApplyDy.getString("paidstatus");
            if (!isForceStop && !PayApplyPayStatusEnum.NOTPAYING.getValue().equals(headerstatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u672a\u4ed8\u6b3e\u5355\u636e\uff0c\u4e0d\u652f\u6301\u8fdb\u884c\u6279\u91cf\u6392\u6b3e\u5904\u7406\u3002", (String)"PayApplyBatchScheValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                result = false;
            }
            HashSet chgStatus = new HashSet(16);
            DynamicObjectCollection applyEntryCol = payApplyDy.getDynamicObjectCollection("cas_payapplyentry");
            if (!(isForceStop || null != applyEntryCol && applyEntryCol.size() != 0)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7533\u8bf7\u660e\u7ec6\u518d\u53d1\u8d77\u6392\u6b3e\u3002", (String)"PayApplyComfirmScheValidator_12", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                result = false;
            } else {
                applyEntryCol.stream().filter(Objects::nonNull).forEach(entry -> {
                    String chgstatus = entry.getString("e_chgstatus");
                    if (chgstatus.equals(PayApplyRecChgStatusEnum.CHGING.getValue())) {
                        chgStatus.add(chgstatus);
                    }
                });
            }
            if (!isForceStop && !chgStatus.isEmpty()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u7684\u7533\u8bf7\u5206\u5f55\u6570\u636e\u5904\u4e8e\u201c\u53d8\u66f4\u4e2d\u201d\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PayApplyComfirmScheValidator_11", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                result = false;
            }
            DynamicObjectCollection payApplyEntryCol = payApplyDy.getDynamicObjectCollection("cas_payinfo");
            HashSet statusSet = new HashSet(16);
            payApplyEntryCol.stream().filter(Objects::nonNull).forEach(entry -> {
                String payStatus = entry.getString("entry_paystatus");
                if (payStatus.equals(PayStatusEnum.NOTPAYING.getValue())) {
                    statusSet.add(payStatus);
                }
            });
            if (isForceStop || !statusSet.isEmpty()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u6392\u6b3e\u6216\u4e0b\u63a8\u4ed8\u6b3e\uff0c\u65e0\u9700\u6279\u91cf\u6392\u6b3e\u3002", (String)"PayApplyComfirmScheValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            result = false;
        }
        Set orgs = Arrays.stream(this.dataEntities).filter(Objects::nonNull).filter(this.distinctByKey(o -> o.getDataEntity().getString("payorg"))).collect(Collectors.toSet());
        Set payeecurrencys = Arrays.stream(this.dataEntities).filter(Objects::nonNull).filter(this.distinctByKey(o -> o.getDataEntity().getString("payeecurrency"))).collect(Collectors.toSet());
        if (!isForceStop && orgs.size() > 1) {
            orgs.stream().filter(Objects::nonNull).forEach(elem -> this.addErrorMessage((ExtendedDataEntity)elem, ResManager.loadKDString((String)"\u53ea\u6709\u4ed8\u6b3e\u7ec4\u7ec7\u548c\u6536\u6b3e\u5e01\u79cd\u5747\u4e00\u81f4\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u652f\u6301\u53d1\u8d77\u6279\u91cf\u6392\u6b3e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayApplyBatchScheValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0])));
            result = false;
        }
        if (!isForceStop && payeecurrencys.size() > 1) {
            payeecurrencys.stream().filter(Objects::nonNull).forEach(elem -> this.addErrorMessage((ExtendedDataEntity)elem, ResManager.loadKDString((String)"\u53ea\u6709\u4ed8\u6b3e\u7ec4\u7ec7\u548c\u6536\u6b3e\u5e01\u79cd\u5747\u4e00\u81f4\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u652f\u6301\u53d1\u8d77\u6279\u91cf\u6392\u6b3e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayApplyBatchScheValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0])));
            result = false;
        }
        Set planPayDates = Arrays.stream(this.dataEntities).filter(Objects::nonNull).filter(this.distinctByKey(o -> o.getDataEntity().getDate("planpaydate"))).filter(elem -> {
            DynamicObjectCollection payEntry = elem.getDataEntity().getDynamicObjectCollection("cas_payapplyentry");
            Set settlementType = payEntry.stream().filter(Objects::nonNull).filter(entry -> EmptyUtil.isNoEmpty((DynamicObject)entry.getDynamicObject("e_settlementtype"))).map(entry -> entry.getDynamicObject("e_settlementtype").getString("settlementtype")).collect(Collectors.toSet());
            return !settlementType.contains(SettleMentTypeEnum.DCEP.getValue());
        }).collect(Collectors.toSet());
        Set settlementTypes = Arrays.stream(this.dataEntities).filter(Objects::nonNull).filter(elem -> {
            DynamicObjectCollection entrys = elem.getDataEntity().getDynamicObjectCollection("cas_payapplyentry");
            return !entrys.isEmpty();
        }).filter(this.distinctByKey(elem -> elem.getDataEntity().getString(String.format("%s.%s", "cas_payapplyentry", "e_settlementtype")))).filter(elem -> {
            DynamicObjectCollection payEntry = elem.getDataEntity().getDynamicObjectCollection("cas_payapplyentry");
            Set settlementType = payEntry.stream().filter(Objects::nonNull).filter(entry -> EmptyUtil.isNoEmpty((DynamicObject)entry.getDynamicObject("e_settlementtype"))).map(entry -> entry.getDynamicObject("e_settlementtype").getString("settlementtype")).collect(Collectors.toSet());
            return !settlementType.contains(SettleMentTypeEnum.DCEP.getValue());
        }).collect(Collectors.toSet());
        if (result) {
            if (planPayDates.size() > 1) {
                planPayDates.stream().filter(Objects::nonNull).forEach(elem -> this.addMessage((ExtendedDataEntity)elem, ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"PayApplyBatchScheValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u8ba1\u5212\u4ed8\u6b3e\u65e5\u671f\u6216\u8005\u7533\u8bf7\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u5b8c\u5168\u4e00\u81f4\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayApplyBatchScheValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]), ErrorLevel.Warning));
            }
            if (settlementTypes.size() > 1) {
                settlementTypes.stream().filter(Objects::nonNull).forEach(elem -> this.addMessage((ExtendedDataEntity)elem, ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"PayApplyBatchScheValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u8ba1\u5212\u4ed8\u6b3e\u65e5\u671f\u6216\u8005\u7533\u8bf7\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u5b8c\u5168\u4e00\u81f4\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayApplyBatchScheValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]), ErrorLevel.Warning));
            }
        }
        logger.info(String.format("\u7533\u8bf7\u5355\u3010%s\u3011\u6279\u91cf\u6392\u6b3e\u6821\u9a8c\u7ed3\u679c: {%s};", LoggerPrintHelper.printCollectionLogger(allBillNo), result));
    }

    private <T> Predicate<T> distinctByKey(Function<? super T, Object> key) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> {
            Object mapKey = key.apply(t);
            if (null == mapKey) {
                return false;
            }
            return map.putIfAbsent(mapKey, Boolean.TRUE) == null;
        };
    }
}

