/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.payapply;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.enums.PayApplyBillStatusEnum;
import kd.fi.cas.enums.PayStatusEnum;

public class PayApplyCancleComfirmScheValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(PayApplyCancleComfirmScheValidator.class);

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject payApplyDy = dataEntity.getDataEntity();
            boolean isDoSche = false;
            DynamicObjectCollection payApplyEntryCol = payApplyDy.getDynamicObjectCollection("cas_payinfo");
            if (payApplyEntryCol.size() == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u6ca1\u6709\u8bb0\u5f55\uff0c\u65e0\u9700\u53d6\u6d88\u786e\u8ba4\u6392\u6b3e\u3002", (String)"PayApplyCancleComfirmScheValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            String billStatus = payApplyDy.getString("billstatus");
            if (PayApplyBillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6682\u5b58\u6216\u5ba1\u6838\u901a\u8fc7\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u65b9\u53ef\u53d6\u6d88\u786e\u8ba4\u6392\u6b3e\u3002", (String)"PayApplyComfirmScheValidator_17", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            for (DynamicObject entry : payApplyEntryCol) {
                String status = entry.getString("entry_paystatus");
                if (!PayStatusEnum.PAYSCHEFUND.getValue().equals(status)) continue;
                isDoSche = true;
                break;
            }
            if (!isDoSche) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u4e0b\u63a8\u4ed8\u6b3e\u6216\u672a\u6392\u6b3e\u7684\u6570\u636e\u65e0\u9700\u53d6\u6d88\u786e\u8ba4\u6392\u6b3e\u3002", (String)"PayApplyCancleComfirmScheValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            logger.info(String.format("\u7533\u8bf7\u5355\u3010%s\u3011\u53d6\u6d88\u786e\u8ba4\u6392\u6b3e\u6821\u9a8c\u7ed3\u679c: {%s};", payApplyDy.getString("billno"), !isDoSche));
        }
    }
}

