/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.payapply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.util.EmptyUtil;

public class PayApplyInfoValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set selectors = super.preparePropertys();
        selectors.add("entry_payeraccbank");
        selectors.add("entry_paymentchannel");
        selectors.add("entry_settlementtype");
        return selectors;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObjectCollection payEntrys = dynamicObject.getDynamicObjectCollection("cas_payinfo");
            LinkedHashSet<String> errorMsgSet = new LinkedHashSet<String>(16);
            HashMap<String, List> settleNumToIndexMap = new HashMap<String, List>(16);
            boolean detailPage = true;
            if (!payEntrys.isEmpty()) {
                detailPage = ((DynamicObject)payEntrys.get(0)).containsProperty("seq");
            }
            StringBuilder sb = new StringBuilder();
            for (Object payEntry : payEntrys) {
                Set paymentChannels;
                DynamicObject settlementType;
                DynamicObject payerAcc;
                DynamicObject settleType = payEntry.getDynamicObject("entry_settlementtype");
                String settletNumber = payEntry.getString("entry_settletnumber");
                if (PayBillHepler.isLCSettlement((DynamicObject)settleType, (SettleMentTypeEnum)SettleMentTypeEnum.CREDITOPEN) && StringUtils.isNotEmpty((CharSequence)settletNumber)) {
                    List rowNoList = settleNumToIndexMap.getOrDefault(settletNumber, new ArrayList(10));
                    String seq = detailPage ? payEntry.getString("seq") : "1";
                    rowNoList.add(seq);
                    settleNumToIndexMap.put(settletNumber, rowNoList);
                }
                if (EmptyUtil.isEmpty((DynamicObject)(payerAcc = payEntry.getDynamicObject("entry_payeraccbank"))) || (settlementType = payEntry.getDynamicObject("entry_settlementtype")) == null) continue;
                String paymentChannel = settlementType.getString("paymentchannel");
                String currentPaymentChannel = payEntry.getString("entry_paymentchannel");
                if (StringUtils.isNotEmpty((CharSequence)paymentChannel) && StringUtils.isNotEmpty((CharSequence)currentPaymentChannel) && !(paymentChannels = Arrays.stream(paymentChannel.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toSet())).contains(currentPaymentChannel)) {
                    ArrayList<String> channelNames = new ArrayList<String>(paymentChannels.size());
                    for (String channel : paymentChannels) {
                        channelNames.add(PaymentChannelEnum.getName((String)channel));
                    }
                    String join = String.join((CharSequence)",", channelNames);
                    String error = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u3010%1$s\u3011\u7684\u9650\u5b9a\u652f\u4ed8\u6e20\u9053\u4e3a\u3010%2$s\u3011\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PayApplyEntryValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), settlementType.getString("name"), join);
                    if (!sb.toString().contains(error)) {
                        sb.append(error);
                    }
                }
                if (PaymentChannelEnum.ONLINEBANK.getValue().equals(currentPaymentChannel) && !payerAcc.getBoolean("isopenbank")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u7f51\u4e0a\u94f6\u884c\u3002", (String)"PayApplyEntryValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
                if (!PaymentChannelEnum.BEI.getValue().equals(currentPaymentChannel) || payerAcc.getBoolean("issetbankinterface")) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u94f6\u4f01\u63a5\u53e3\u3002", (String)"PayApplyEntryValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            List reSettletNumberList = settleNumToIndexMap.values().stream().filter(l -> l.size() > 1).collect(Collectors.toList());
            if (!reSettletNumberList.isEmpty()) {
                Object payEntry;
                payEntry = reSettletNumberList.iterator();
                while (payEntry.hasNext()) {
                    String msg;
                    List seqList = (List)payEntry.next();
                    if (detailPage) {
                        String seqStr = String.join((CharSequence)",", seqList);
                        msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u7b2c%s\u884c\u7ed3\u7b97\u53f7\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PayApplyEntryValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]), seqStr);
                    } else {
                        msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u201c%s\u201d\u7684\u4ed8\u6b3e\u660e\u7ec6\u4e2d\u9009\u62e9\u4e86\u91cd\u590d\u7684\u7ed3\u7b97\u53f7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PayApplyEntryValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]), dynamicObject.getString("billno"));
                    }
                    errorMsgSet.add(msg);
                }
            }
            if (!errorMsgSet.isEmpty()) {
                String errorMsg = String.join((CharSequence)"\r\n", errorMsgSet);
                this.addErrorMessage(dataEntity, errorMsg);
            }
            if (sb.length() <= 0) continue;
            this.addErrorMessage(dataEntity, sb.toString());
        }
    }
}

