/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.payapply;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayApplyIsFreezeValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set selectors = super.preparePropertys();
        selectors.add("cas_payapplyentry");
        selectors.add("e_payeetype");
        selectors.add("e_payee");
        selectors.add("paymentidentify");
        selectors.add("cas_payinfo");
        selectors.add("cas_payinfo.entry_settlementtype");
        selectors.add("cas_payinfo.entry_settletnumber");
        return selectors;
    }

    public void validate() {
        String psdAppId = AppMetadataCache.getAppInfo((String)"psd").getId();
        List orgIds = Arrays.stream(this.dataEntities).map(s -> s.getDataEntity().getDynamicObject("payorg").getLong("id")).collect(Collectors.toList());
        Map orgPsdMap = SystemParameterHelper.getSystemParamsByOrgIds((String)psdAppId, orgIds, (String)"psd001");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            QFilter[] filters;
            boolean exists;
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObjectCollection applyEntry = info.getDynamicObjectCollection("cas_payapplyentry");
            HashSet<Long> payeeIds = new HashSet<Long>(applyEntry.size());
            for (DynamicObject entry : applyEntry) {
                String ePayeeType = entry.getString("e_payeetype");
                DynamicObject ePayee = entry.getDynamicObject("e_payee");
                if (!AsstActTypeEnum.SUPPLIER.getValue().equals(ePayeeType) || ePayee == null || ePayee.getLong("id") == 0L) continue;
                payeeIds.add(ePayee.getLong("id"));
            }
            if (payeeIds.size() > 0 && (exists = QueryServiceHelper.exists((String)"bd_supplier", (QFilter[])(filters = new QFilter[]{new QFilter("id", "in", payeeIds), new QFilter("payhold", "=", (Object)"1")})))) {
                PaymentErrorCode paymentErrorCode = new PaymentErrorCode();
                this.addErrorMessage(dataEntity, paymentErrorCode.CANOTDOTHISOP_WHENSUPPLIERFREEZE().getMessage());
            }
            DynamicObject payOrg = info.getDynamicObject("payorg");
            boolean isOpenSche = (Boolean)orgPsdMap.get(payOrg.getString("id"));
            DynamicObject paymentIdentify = info.getDynamicObject("paymentidentify");
            boolean isPositivePay = EmptyUtil.isNoEmpty((DynamicObject)paymentIdentify) && "0".equals(paymentIdentify.getString("type"));
            DynamicObjectCollection payInfoEntry = info.getDynamicObjectCollection("cas_payinfo");
            for (DynamicObject infoEntry : payInfoEntry) {
                boolean isCredit;
                DynamicObject settleType = infoEntry.getDynamicObject("entry_settlementtype");
                boolean bl = isCredit = settleType != null && SettleMentTypeEnum.CREDIT.getValue().equals(settleType.getString("settlementtype"));
                if (isCredit && isPositivePay) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u4fe1\u7528\u8bc1\u5230\u5355\u65f6\uff0c\u4ed8\u6b3e\u6807\u8bc6\u4e0d\u5141\u8bb8\u662f\u4e3b\u52a8\u4ed8\u6b3e\u3002", (String)"PayApplyIsFreezeValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
                String settletNumber = infoEntry.getString("entry_settletnumber");
                if (isCredit && !isOpenSche && EmptyUtil.isEmpty((String)settletNumber)) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u7684\u3010\u7ed3\u7b97\u65b9\u5f0f.\u7c7b\u522b\u3011\u4e3a\u201c\u4fe1\u7528\u8bc1\u5230\u5355\u201d\u65f6\uff0c\u7ed3\u7b97\u53f7\u5fc5\u586b\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PayApplyIsFreezeValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (!isCredit || !isOpenSche || !EmptyUtil.isNoEmpty((String)settletNumber)) continue;
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7ec4\u7ec7\u5df2\u542f\u7528\u4ed8\u6b3e\u6392\u7a0b\u4e14\u4ed8\u6b3e\u660e\u7ec6\u7684\u3010\u7ed3\u7b97\u65b9\u5f0f.\u7c7b\u522b\u3011\u4e3a\u201c\u4fe1\u7528\u8bc1\u5230\u5355\u201d\u65f6\uff0c\u7ed3\u7b97\u53f7\u5fc5\u987b\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PayApplyIsFreezeValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

