/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.paymentbill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.CasHelper;

public class InterPayPlanSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject payPlan = dataEntity.getDataEntity();
            String number = payPlan.getString("number");
            String name = payPlan.getString("name");
            DynamicObject org = payPlan.getDynamicObject("org");
            if (CasHelper.isEmpty((Object)name) || CasHelper.isEmpty((Object)number) || CasHelper.isEmpty((Object)org)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6570\u636e\u3002", (String)"InterPayPlanSaveValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            QFilter numberQf = new QFilter("number", "=", (Object)number);
            QFilter nameQf = new QFilter("name", "=", (Object)name);
            QFilter qFilter = new QFilter("org", "=", org.getPkValue());
            QFilter idQf = new QFilter("id", "!=", payPlan.getPkValue());
            qFilter.and(idQf);
            Boolean isExist = QueryServiceHelper.exists((String)"cas_interpayplan", (QFilter[])new QFilter[]{qFilter, numberQf});
            if (isExist.booleanValue()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u76f8\u540c\u8d44\u91d1\u7ec4\u7ec7\u7684\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"InterPayPlanSaveValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (!(isExist = Boolean.valueOf(QueryServiceHelper.exists((String)"cas_interpayplan", (QFilter[])new QFilter[]{nameQf.and(idQf)}))).booleanValue()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"InterPayPlanSaveValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

