/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.paymentbill;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ChangeStatusEnum;
import kd.fi.cas.enums.SourceBillTypeEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaybillChgValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(PaybillChgValidator.class);

    public void validate() {
        if (EmptyUtil.isEmpty((Object[])this.dataEntities)) {
            return;
        }
        String operateKey = this.getOperateKey();
        if (this.dataEntities.length > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u652f\u4ed8\u4fe1\u606f\u53d8\u66f4\u3002", (String)"PaymentBillList_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        String entryName = this.dataEntities[0].getDataEntity().getDataEntityType().getName();
        DynamicObject dataEntity = this.dataEntities[0].getDataEntity();
        Long id = dataEntity.getLong("id");
        Long orgId = dataEntity.getDynamicObject("org").getLong("id");
        String billstatus = dataEntity.getString("billstatus");
        String matchflag = dataEntity.getString("matchflag");
        String changestatus = dataEntity.getString("changestatus");
        Set cs195 = SystemParameterHelper.getParameterComboxs((long)orgId, (String)"cs195");
        if (SourceBillTypeEnum.PAYBILL.getValue().equals(entryName)) {
            if (!AutoMatchFlagEnum.NONE.getValue().equals(matchflag) && !AutoMatchFlagEnum.NONEED.getValue().equals(matchflag)) {
                this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u5df2\u5339\u914d\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u53d8\u66f4\u3002", (String)"PaymentBillList_50", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!cs195.contains(billstatus)) {
                this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u6839\u636e\u7cfb\u7edf\u53c2\u6570\u5141\u8bb8\u53d1\u8d77\u53d8\u66f4\u7684\u5355\u636e\u72b6\u6001\u914d\u7f6e\uff0c\u60a8\u6240\u9009\u5355\u636e\u7684\u5355\u636e\u72b6\u6001\u4e0d\u5141\u8bb8\u8fdb\u884c\u652f\u4ed8\u4fe1\u606f\u53d8\u66f4\u3002", (String)"PaymentBillList_11", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject casPayBill = BusinessDataServiceHelper.loadSingle((String)"cas_paybill", (String)"id,billno,entrustorg,applyorg,entrustamt", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            if (!EmptyUtil.isEmpty((DynamicObject)casPayBill)) {
                if (!EmptyUtil.isEmpty((Object)casPayBill.get("entrustorg"))) {
                    if ("paypushchg".equals(operateKey)) {
                        String msg = ResManager.loadKDString((String)"\u59d4\u6258\u4ed8\u6b3e\u4e0a\u6e38\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4ed8\u6b3e\u4fe1\u606f\u53d8\u66f4\u3002", (String)"PaybillChgValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage(this.dataEntities[0], msg);
                        return;
                    }
                    if (casPayBill.getBigDecimal("entrustamt").compareTo(BigDecimal.ZERO) != 0) {
                        String msgFmt = ResManager.loadKDString((String)"\u5355\u636e[%s]\u5df2\u4e0b\u63a8\u6709\u6548\u7684\u59d4\u6258\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u3002", (String)"PaybillChgValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage(this.dataEntities[0], String.format(msgFmt, casPayBill.getString("billno")));
                        return;
                    }
                }
                if (!EmptyUtil.isEmpty((Object)casPayBill.get("applyorg")) && "recpushchg".equals(operateKey)) {
                    this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u59d4\u6258\u4ed8\u6b3e\u7684\u4ed8\u6b3e\u5904\u7406\u5355\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u6536\u6b3e\u4fe1\u606f\u3002", (String)"PaybillChgValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
        if (SourceBillTypeEnum.AGENTPAYBILL.getValue().equals(entryName)) {
            if (!cs195.contains(billstatus) && !this.isARepayAgt(dataEntity)) {
                this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u4ee3\u53d1\u5355\u6839\u636e\u7cfb\u7edf\u53c2\u6570\u5141\u8bb8\u53d1\u8d77\u53d8\u66f4\u7684\u5355\u636e\u72b6\u6001\u6216\u8005\u5931\u8d25\u91cd\u4ed8\u751f\u6210\u6682\u5b58\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u4ed8\u6b3e\u4fe1\u606f\u53d8\u66f4\u3002", (String)"AgentPayBillList_25", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject agentBill = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)SourceBillTypeEnum.AGENTPAYBILL.getValue(), (String)"id,billno,delegorg,applyorg,entrustamt");
            if (EmptyUtil.isNoEmpty((Object)agentBill.get("delegorg"))) {
                if ("paypushchg".equals(operateKey)) {
                    String msgFmt = ResManager.loadKDString((String)"\u59d4\u6258\u4ed8\u6b3e\u4e0a\u6e38\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4ed8\u6b3e\u4fe1\u606f\u53d8\u66f4\u3002", (String)"PaybillChgValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(this.dataEntities[0], msgFmt);
                    return;
                }
                if (agentBill.getBigDecimal("entrustamt").compareTo(BigDecimal.ZERO) != 0) {
                    String fmt = ResManager.loadKDString((String)"\u5355\u636e[%s]\u5df2\u4e0b\u63a8\u6709\u6548\u7684\u59d4\u6258\u4ee3\u53d1\u5355\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u3002", (String)"PaybillChgValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(this.dataEntities[0], String.format(fmt, agentBill.getString("billno")));
                    return;
                }
            }
            if (!EmptyUtil.isEmpty((Object)agentBill.get("applyorg")) && "recpushchg".equals(operateKey)) {
                this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u59d4\u6258\u4ed8\u6b3e\u7684\u4ee3\u53d1\u5904\u7406\u5355\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u6536\u6b3e\u4fe1\u606f\u3002", (String)"PaybillChgValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (ChangeStatusEnum.CHANGING.getValue().equals(changestatus)) {
            if ("recpushchg".equals(operateKey)) {
                QFilter qFilter = new QFilter("sourcetype", "=", (Object)entryName);
                qFilter.and("sourcebillid", "=", (Object)id);
                qFilter.and("iscashconfirm", "=", (Object)"0");
                Object[] payChgBills = BusinessDataServiceHelper.load((String)"cas_paychgbill", (String)"id,billno,applyuser,iscashconfirm", (QFilter[])new QFilter[]{qFilter});
                if (EmptyUtil.isNoEmpty((Object[])payChgBills)) {
                    String billno = payChgBills[0].getString("billno");
                    String applyuser = payChgBills[0].getDynamicObject("applyuser").getString("name");
                    this.addErrorMessage(this.dataEntities[0], String.format(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6b63\u5728\u8fdb\u884c\u6536\u4ed8\u6b3e\u4fe1\u606f\u53d8\u66f4\u6d41\u7a0b\u4e2d\uff0c\u8bf7\u7b49\u5355\u53f7\u3010%1$s\u3011\uff1a\u53d8\u66f4\u4eba\u3010%2$s\u3011\uff1a\u5b8c\u6210\u53d8\u66f4\u540e\u518d\u6b21\u53d1\u8d77\u53d8\u66f4\u3002", (String)"AgentPayBillList_24", (String)"fi-cas-formplugin", (Object[])new Object[0]), billno, applyuser));
                    return;
                }
            } else if ("paypushchg".equals(operateKey)) {
                this.addErrorMessage(this.dataEntities[0], String.format(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6b63\u5728\u53d8\u66f4\u652f\u4ed8\u4fe1\u606f\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u518d\u6b21\u53d8\u66f4\u3002", (String)"PayBillIsChangingValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), new Object[0]));
                return;
            }
        }
    }

    private boolean isARepayAgt(DynamicObject agtbillDO) {
        DynamicObject[] srcAgentPayBills;
        if (!BillStatusEnum.SAVE.getValue().equals(agtbillDO.getString("billstatus"))) {
            return false;
        }
        Set setLongs = CasBotpHelper.getSrcBillByDestBill((Long)agtbillDO.getLong("id"), (String)"cas_agentpaybill", (String)"cas_agentpaybill");
        if (EmptyUtil.isEmpty((Collection)setLongs)) {
            return false;
        }
        logger.info("\u5931\u8d25\u91cd\u4ed8\u7684\u4ee3\u53d1\u5355id" + setLongs);
        for (DynamicObject srcAgtABill : srcAgentPayBills = BusinessDataServiceHelper.load((Object[])setLongs.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_agentpaybill"))) {
            DynamicObjectCollection entry = srcAgtABill.getDynamicObjectCollection("entry");
            if (!entry.stream().anyMatch(e -> e.getBoolean("e_isrepaid"))) continue;
            return true;
        }
        return false;
    }
}

