/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.paymentbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.enums.AsstActTypeEnum;

public class PaymentDiffPayEmptyValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(PaymentDiffPayEmptyValidator.class);

    public void validate() {
        logger.info("PaymentDiffPayEmptyValidator validate start");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            BigDecimal dpamt;
            BigDecimal dpexchangerate;
            BigDecimal exchangerate;
            DynamicObject info = dataEntity.getDataEntity();
            if (!AsstActTypeEnum.OTHER.getValue().equals(info.getString("payeetype")) && info.get("payee") == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4eba\u3002", (String)"PaymentDiffPayEmptyValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            boolean isdiffcur = info.getBoolean("isdiffcur");
            String fnLoadKDString = "";
            fnLoadKDString = isdiffcur ? ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd,\u6536\u6b3e\u6c47\u7387,\u6536\u6b3e\u91d1\u989d,\u4ed8\u6b3e\u5e01\u79cd,\u4ed8\u6b3e\u6c47\u7387,\u4ed8\u6b3e\u91d1\u989d", (String)"PaymentDiffPayEmptyValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e\u5e01\u79cd,\u4ed8\u6b3e\u6c47\u7387,\u4ed8\u6b3e\u91d1\u989d", (String)"PaymentDiffPayEmptyValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            String[] fieldNames = fnLoadKDString.split(",");
            DynamicObject currency = info.getDynamicObject("currency");
            if (currency == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"PaymentDiffPayEmptyValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), fieldNames[0]));
            }
            if ((exchangerate = info.getBigDecimal("exchangerate")) == null || exchangerate.compareTo(new BigDecimal(0)) == 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"PaymentDiffPayEmptyValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), fieldNames[1]));
            }
            if (!isdiffcur) continue;
            DynamicObject dpCurrency = info.getDynamicObject("dpcurrency");
            if (dpCurrency == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"PaymentDiffPayEmptyValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), fieldNames[3]));
            }
            if ((dpexchangerate = info.getBigDecimal("dpexchangerate")) == null || dpexchangerate.compareTo(new BigDecimal(0)) == 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"PaymentDiffPayEmptyValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), fieldNames[4]));
            }
            if ((dpamt = info.getBigDecimal("dpamt")) != null && dpamt.compareTo(new BigDecimal(0)) != 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"PaymentDiffPayEmptyValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), fieldNames[5]));
        }
        logger.info("PaymentDiffPayEmptyValidator validate end");
    }
}

