/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.paymentbill;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.errorcode.CasErrorCode;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.business.helper.LinkagePaymentHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BillStatusHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.PayBillCrossHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class PaymentPayPushIfmValidator
extends AbstractValidator {
    private static final String SYSTEM_TYPE = "fi-cas-opplugin";

    public void validate() {
        List ids = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getLong("id")).collect(Collectors.toList());
        List dynamicObjects = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map idStatusMap = BillStatusHelper.batchIdToStatus((String)"cas_paybill", ids);
        Map idToIsIfm = PayBillCrossHelper.batchIsIfmAcc(dynamicObjects, (String)"payeracctbank");
        Map objCanUseAcc = AccountBankHelper.batchCanUseAccountMap(dynamicObjects);
        CasErrorCode casErrorCode = new CasErrorCode();
        PaymentErrorCode paymentErrorCode = new PaymentErrorCode();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            boolean tm018;
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObject settleType = info.getDynamicObject("settletype");
            if (PayBillHepler.isLCSettlement((DynamicObject)settleType, (SettleMentTypeEnum)SettleMentTypeEnum.CREDITOPEN)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5904\u7406\u5355\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b\u662f\u4fe1\u7528\u8bc1\u5f00\u7acb\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u94f6\u4f01\u6216\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u3002", (String)"PaymentPayPushIfmValidator_16", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            if (EmptyUtil.isNoEmpty((Object)info.get("entrustorg"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u59d4\u6258\u4ed8\u6b3e\u573a\u666f\u6682\u4e0d\u652f\u6301\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u3002", (String)"PaymentPayPushIfmValidator_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            if (BillStatusEnum.BEING.getValue().equals(idStatusMap.get(info.getLong("id")))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u7ed3\u7b97\u4e2d\u5fc3\u7684\u4ed8\u6b3e\u5355\u4e0d\u5141\u8bb8\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PaymentPayPushIfmValidator_13", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            if (!BillStatusEnum.AUDIT.getValue().equals(idStatusMap.get(info.getLong("id")))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u5141\u8bb8\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u3002", (String)"PaymentPayPushIfmValidator_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            if (PaymentBillPluginHelper.payIdentify((DynamicObject)info)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u4ed8\u6b3e\uff0c\u88ab\u52a8\u4ed8\u6b3e\u4e1a\u52a1\u4e0d\u5141\u8bb8\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u3002", (String)"PaymentPayPushIfmValidator_11", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            boolean isLinkagePayment = LinkagePaymentHelper.isLinkagePayment((DynamicObject)info);
            if (!isLinkagePayment) {
                if (!((Boolean)idToIsIfm.get(info.getLong("id"))).booleanValue()) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u4e0d\u662f\u5185\u90e8\u8d26\u6237\u4e0d\u80fd\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u3002", (String)"PaymentPayPushIfmValidator_14", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
            } else {
                if (info.getDynamicObject("inneraccount") == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u4ed8\u6b3e\u8d26\u6237\u5fc5\u987b\u5173\u8054\u5185\u90e8\u8d26\u6237\u3002", (String)"PaymentPayPushIfmValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if (StringUtils.isBlank((CharSequence)info.getString("usage"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\uff0c\u8f6c\u8d26\u9644\u8a00\u5fc5\u586b\u3002", (String)"PaymentPayPushIfmValidator_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
            }
            if (!CasHelper.isEmpty((Object)info.get("sourcebillid")) && !CasHelper.isEmpty((Object)info.get("sourcebilltype")) && (info.getString("sourcebilltype").equals("bei_transdetail_cas") || info.getString("sourcebilltype").equals("bei_transdetail") || info.getString("sourcebilltype").equals("bei_intelpay"))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u7531\u4ea4\u6613\u660e\u7ec6\u751f\u6210\u7684\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u3002", (String)"PaymentPayPushIfmValidator_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            if (info.getBoolean("isdiffcur")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5185\u90e8\u91d1\u878d\u6682\u4e0d\u652f\u6301\u5f02\u5e01\u79cd\u652f\u4ed8\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"PaymentPayPushIfmValidator_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            String recBankNumber = info.getString("recbanknumber");
            Object bankPkValue = info.get("payeeacctbank");
            boolean isInnerAcc = PayBillCrossHelper.isInnerAcct((Object)bankPkValue);
            if (!isInnerAcc && CasHelper.isEmpty((Object)recBankNumber)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u884c\u540d\u884c\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u3002", (String)"PaymentPayPushIfmValidator_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            if (!SystemStatusCtrolHelper.isInitEnable((long)info.getDynamicObject("org").getLong("id"))) {
                this.addMessage(dataEntity, SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)info.getDynamicObject("org"), (String)"name")));
                continue;
            }
            DynamicObject payerAcctBank = info.getDynamicObject("payeracctbank");
            if (payerAcctBank == null) {
                this.addMessage(dataEntity, String.format(paymentErrorCode.BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237", (String)"PayentBillCommitBEValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0])));
                continue;
            }
            if (AccountBankHelper.isClosed((long)payerAcctBank.getLong("id"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d26\u6237%s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PaymentErrorCode_47", (String)"fi-cas-business", (Object[])new Object[0]), payerAcctBank.getString("number")));
            }
            if (CasHelper.isEmpty((Object)info.getString("payeename")) || CasHelper.isEmpty((Object)info.getString("recaccbankname"))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u5b9e\u540d\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u3002", (String)"PaymentPayPushIfmValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            if (CasHelper.isEmpty((Object)info.getString("payeebanknum"))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u3002", (String)"PaymentPayPushIfmValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            if (!info.getBoolean("iscrosspay") && !((Boolean)idToIsIfm.get(info.getLong("id"))).booleanValue()) {
                if (CasHelper.isEmpty((Object)info.getString("recprovince"))) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u7701\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u3002", (String)"PaymentPayPushIfmValidator_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if (CasHelper.isEmpty((Object)info.getString("reccity"))) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u5e02\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u3002", (String)"PaymentPayPushIfmValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if (CasHelper.isEmpty((Object)info.getString("reccountry"))) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u3002", (String)"PaymentPayPushIfmValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
            }
            if (!(tm018 = SystemParameterHelper.isBizBillCommitBe((long)info.getDynamicObject("org").getLong("id")))) continue;
            DynamicObject accountBank = info.getDynamicObject("payeracctbank");
            if (!((Boolean)objCanUseAcc.get(info)).booleanValue()) {
                this.addMessage(dataEntity, casErrorCode.ORG_NOT_ACCTAUTH().getMessage());
                continue;
            }
            if ("normal".equals((accountBank = BusinessDataServiceHelper.loadSingleFromCache((Object)accountBank.getPkValue(), (String)"bd_accountbanks", (String)"id, acctstatus")).getString("acctstatus"))) continue;
            if ("freeze".equals(accountBank.getString("acctstatus"))) {
                this.addMessage(dataEntity, casErrorCode.ACCT_IS_FREEZE().getMessage());
                continue;
            }
            this.addMessage(dataEntity, casErrorCode.ACCT_IS_CLOSE().getMessage());
        }
    }
}

