/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.paymentbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.business.opservice.helper.RecPayRuleHelper;
import kd.fi.cas.business.opservice.helper.ValidAndSetMatchInfoHelper;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentSaveValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(PaymentSaveValidator.class);
    private static final List<String> SRCBILL_TYPES = Arrays.asList("bei_transdetail_cas", "bei_transdetail", "bei_intelpay");

    public void validate() {
        logger.info("PaymentSaveValidator validate start");
        Long[] pkIds = (Long[])((Stream)Arrays.stream(this.dataEntities).parallel()).map(d -> d.getDataEntity().getLong("id")).toArray(Long[]::new);
        DynamicObjectCollection actPayAmts = QueryServiceHelper.query((String)"cas_paybill", (String)"id,actpayamt", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
        Map<Long, BigDecimal> actPayAmtMap = actPayAmts.parallelStream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d.getBigDecimal("actpayamt")));
        DynamicObjectCollection virtualIds = null;
        Object[] virBankIds = (Long[])((Stream)Arrays.stream(this.dataEntities).parallel()).filter(d -> BaseDataHelper.isSettleTypeVirtual((DynamicObject)d.getDataEntity().getDynamicObject("settletype")) && d.getDataEntity().getDynamicObject("payeracctbank") != null).map(d -> d.getDataEntity().getDynamicObject("payeracctbank").getLong("id")).toArray(Long[]::new);
        if (EmptyUtil.isNoEmpty((Object[])virBankIds)) {
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)virBankIds), VisibleVirtualAcctHelper.virtualAcctQf()};
            virtualIds = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])qFilters);
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            long count;
            boolean settleTypeVirtual;
            DynamicObject paymentIdentify;
            DynamicObject settleType;
            DynamicObject info = dataEntity.getDataEntity();
            String paymentChannel = info.getString("paymentchannel");
            logger.info("PaymentSaveValidator payee:{}, paymentChannel:{}", (Object)info.getString("payee"), (Object)paymentChannel);
            if (PaymentChannelEnum.COUNTER.getValue().equals(paymentChannel) && StringUtils.isEmpty((CharSequence)info.getString("payee")) && StringUtils.isEmpty((CharSequence)info.getString("payeename"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u5fc5\u586b\u3002", (String)"PaymentErrorCode_41", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            if (this.getOption().containsVariable("save_issupplecontract")) {
                this.getOption().removeVariable("save_issupplecontract");
                BigDecimal tmpAmt = info.getBigDecimal("actpayamt");
                BigDecimal actPayAmt = actPayAmtMap.get(info.getLong("id"));
                String amtStr = "";
                if (!CasHelper.isEmpty((Object)actPayAmt) && !CasHelper.isEmpty((Object)tmpAmt)) {
                    amtStr = actPayAmt.setScale(2, RoundingMode.HALF_UP).toString();
                    if (tmpAmt.compareTo(actPayAmt) != 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fee\u6539\u540e\u7684\u5b9e\u4ed8\u91d1\u989d\u6570\u503c\u4e0e\u539f\u6765\u91d1\u989d\u6570\u503c\u201c%s\u201d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"PaymentSaveValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), amtStr));
                    }
                } else {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fee\u6539\u540e\u7684\u5b9e\u4ed8\u91d1\u989d\u6570\u503c\u4e0e\u539f\u6765\u91d1\u989d\u6570\u503c\u201c%s\u201d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"PaymentSaveValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), amtStr));
                }
            }
            this.validMatchInfo(dataEntity);
            DynamicObject cash = info.getDynamicObject("payeracctcash");
            DynamicObject accBank = info.getDynamicObject("payeracctbank");
            if (EmptyUtil.isNoEmpty((DynamicObject)cash) && EmptyUtil.isNoEmpty((DynamicObject)accBank)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u548c\u73b0\u91d1\u8d26\u53f7\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u3002", (String)"PaymentSaveValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if ((settleType = info.getDynamicObject("settletype")) != null && SettleMentTypeEnum.MONEY.getValue().equals(settleType.getString("settlementtype"))) {
                boolean singlestream = info.getBoolean("singlestream");
                BigDecimal fee = info.getBigDecimal("fee");
                if (singlestream || fee.compareTo(BigDecimal.ZERO) != 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u73b0\u91d1\u652f\u4ed8\u4e1a\u52a1\uff0c\u4e0d\u6d89\u53ca\u624b\u7eed\u8d39\uff0c\u8bf7\u5173\u95ed\u624b\u7eed\u5206\u72ec\u7acb\u6d41\u6c34\u6807\u8bc6\u5e76\u4fdd\u8bc1\u624b\u7eed\u8d39\u91d1\u989d\u4e3a0", (String)"PaymentSaveValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(paymentIdentify = info.getDynamicObject("paymentidentify"))) && "1".equals(paymentIdentify.getString("type")) && PaymentChannelEnum.BEI.getValue().equals(paymentChannel)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672c\u5355\u4ed8\u6b3e\u6807\u8bc6\u7c7b\u522b\u4e3a\u88ab\u52a8\uff0c\u652f\u4ed8\u6e20\u9053\u4e0d\u5e94\u4e3a\u94f6\u4f01\u4e92\u8054\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u64cd\u4f5c\u3002", (String)"PaymentSaveValidator_9", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (!(settleTypeVirtual = BaseDataHelper.isSettleTypeVirtual((DynamicObject)info.getDynamicObject("settletype"))) || !EmptyUtil.isNoEmpty((DynamicObjectCollection)virtualIds) || null == accBank || (count = virtualIds.stream().map(o -> accBank.getPkValue().equals(o.get("id"))).filter(o -> o).count()) != 0L) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u865a\u62df\u7ed3\u7b97\u65b9\u5f0f\u53ea\u80fd\u9009\u62e9\u865a\u62df\u94f6\u884c\u8d26\u6237\u3002", (String)"PaymentSaveValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        logger.info("PaymentSaveValidator validate end");
    }

    private void validMatchInfo(ExtendedDataEntity dataEntity) {
        DynamicObject info = dataEntity.getDataEntity();
        String sourceBillType = info.getString("sourcebilltype");
        boolean isFromDb = info.getDataEntityState().getFromDatabase();
        String errInfo = "";
        if (!isFromDb && SRCBILL_TYPES.contains(sourceBillType)) {
            String returnDataStr = "";
            Map returnData = null;
            if (this.getOption().containsVariable("returnDataByOpHolding")) {
                returnDataStr = String.valueOf(this.getOption().getVariables().get("returnDataByOpHolding"));
                returnData = (Map)SerializationUtils.fromJsonString((String)returnDataStr, Map.class);
            } else if (this.getOption().containsVariable("returnDataByOpHand")) {
                returnDataStr = String.valueOf(this.getOption().getVariables().get("returnDataByOpHand"));
                returnData = (Map)SerializationUtils.fromJsonString((String)returnDataStr, Map.class);
            } else if (this.getOption().containsVariable("returnDataByOpHandMerge")) {
                returnDataStr = String.valueOf(this.getOption().getVariables().get("returnDataByOpHandMerge"));
                returnData = (Map)SerializationUtils.fromJsonString((String)returnDataStr, Map.class);
            } else {
                returnData = RecPayRuleHelper.getInfoByMatchRule((DynamicObject)info, (String)"pay");
            }
            if (!CasHelper.isEmpty((Object)returnData) && returnData.size() > 0) {
                logger.info("validMatchInfo returnData: {}", (Object)returnData);
                String payeeType = String.valueOf(returnData.get("e_payeetype"));
                Object e_recer = returnData.get("e_recer");
                if (EmptyUtil.isEmpty(e_recer)) {
                    errInfo = ValidAndSetMatchInfoHelper.validAndSetMatchInfo((DynamicObject)info, (String)payeeType, (String)"pay", (boolean)false);
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)errInfo)) {
            this.addErrorMessage(dataEntity, errInfo);
        }
    }
}

