/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.paymentbilltype;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PaymentBillTypeValidator
extends AbstractValidator {
    public void validate() {
        List ids = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getLong("id")).collect(Collectors.toList());
        QFilter qFilterId = new QFilter("id", "in", ids);
        DynamicObject[] pbTypes = BusinessDataServiceHelper.load((String)"cas_paymentbilltype", (String)"number,name,ispartpayment,biztype", (QFilter[])new QFilter[]{qFilterId});
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject pbType = dataEntity.getDataEntity();
            Boolean isPartPayment = pbType.getBoolean("ispartpayment");
            String bizType = pbType.getString("biztype");
            Boolean preData = pbType.getBoolean("predata");
            Long paymentTypeId = pbType.getLong("id");
            String number = pbType.getString("number");
            String name = ((OrmLocaleValue)pbType.get("name")).get((Object)"zh_CN");
            Boolean isNotModify = true;
            Set idsInDb = Arrays.stream(pbTypes).map(o -> o.getLong("id")).collect(Collectors.toSet());
            if (!idsInDb.contains(paymentTypeId)) continue;
            DynamicObject dbObj = Arrays.stream(pbTypes).filter(o -> Objects.equals(o.getLong("id"), paymentTypeId)).findFirst().orElse(null);
            if (idsInDb != null && idsInDb.size() != 0) {
                isNotModify = dbObj.getString("number").equals(number) && dbObj.getString("name").equals(name) && Boolean.valueOf(dbObj.getBoolean("ispartpayment")).equals(isPartPayment) && dbObj.getString("biztype").equals(bizType);
            }
            if (this.getOption().containsVariable("importtype") && this.getOption().getVariableValue("importtype") != null) {
                if (!isNotModify.booleanValue() && Boolean.TRUE.equals(preData)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u8bbe\u6570\u636e\u4e3a\u662f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u7f16\u7801\u3001\u540d\u79f0\u3001\u53c2\u4e0e\u5e94\u4ed8\u7ed3\u7b97\u3001\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"PaymentBillTypeSaveOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (!Boolean.FALSE.equals(preData)) continue;
                this.quoteValidate(paymentTypeId, isNotModify, dataEntity);
                continue;
            }
            this.quoteValidate(paymentTypeId, isNotModify, dataEntity);
        }
    }

    private void quoteValidate(Long id, Boolean isNotModify, ExtendedDataEntity dataEntity) {
        QFilter qFilterType = new QFilter("paymenttype", "=", (Object)id);
        boolean existPayBill = QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])new QFilter[]{qFilterType});
        boolean existAgentPayBill = QueryServiceHelper.exists((String)"cas_agentpaybill", (QFilter[])new QFilter[]{qFilterType});
        if (!isNotModify.booleanValue() && (existPayBill || existAgentPayBill)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u7f16\u7801\u3001\u540d\u79f0\u3001\u53c2\u4e0e\u5e94\u4ed8\u7ed3\u7b97\u3001\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"PaymentBillTypeSaveOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

