/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.rec;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import org.apache.commons.lang3.StringUtils;

public class RecBackstageRefundRenoteValidator
extends AbstractValidator {
    private static final Set<String> BILL_TYPES = new HashSet<String>(){
        {
            this.add("cas_paybill");
            this.add("cas_agentpaybill");
        }
    };
    private static final Set<String> OP_TYPES = new HashSet<String>(){
        {
            this.add("refund");
            this.add("renote");
        }
    };

    public void validate() {
        String billId;
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        ExtendedDataEntity dataEntity = this.getDataEntities()[0];
        String billType = (String)variables.get("billType");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{billType, billId = (String)variables.get("billId")})) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u6216\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RecBackstageRefundRenoteValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            return;
        }
        if (!BILL_TYPES.contains(billType)) {
            String msg = ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301[%s]\u5355\u636e\u7c7b\u578b\u3002", (String)"RecBackstageRefundRenoteValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(msg, billType));
            return;
        }
        String entryIdsStr = (String)variables.get("entryIds");
        if ("cas_agentpaybill".equals(billType) && StringUtils.isBlank((CharSequence)entryIdsStr)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ee3\u53d1\u5355\u5fc5\u987b\u4f20\u5206\u5f55ID\u3002", (String)"RecBackstageRefundRenoteValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            return;
        }
        String operateKey = (String)variables.get("operateKey");
        if (!OP_TYPES.contains(operateKey)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b\u6709\u8bef\u3002", (String)"RecBackstageRefundRenoteValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

