/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.rec;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.util.EmptyUtil;

public class ReceivingDcepSubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            String payerAcctbankNum;
            DynamicObject payAccBank;
            DynamicObject info = data.getDataEntity();
            DynamicObject settleType = info.getDynamicObject("settletype");
            boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
            if (isDcep) {
                String businessType = info.getString("businesstype");
                DynamicObject recAccBank = info.getDynamicObject("accountbank");
                if (!EmptyUtil.isNoEmpty((DynamicObject)recAccBank)) continue;
                boolean isElecPaymentRec = recAccBank.getBoolean("iselecpayment");
                if (!PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType)) continue;
                if (!isElecPaymentRec) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u6570\u5e01\u94b1\u5305\u7684\u4e1a\u52a1\uff0c\u6536\u6b3e\u65b9\u8d26\u6237\u548c\u4ed8\u6b3e\u65b9\u8d26\u6237\u5fc5\u987b\u5747\u4e3a\u6570\u5e01\u94b1\u5305\u8d26\u6237\u3002", (String)"PaymentDcepSubmitValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
                String payerType = info.getString("payertype");
                if (!AsstActTypeEnum.COMPANY.getValue().equals(payerType) && !AsstActTypeEnum.SUPPLIER.getValue().equals(payerType) && !AsstActTypeEnum.CUSTOMER.getValue().equals(payerType)) continue;
                String payerAcctbankNum2 = info.getString("payeracctbanknum");
                boolean checkInternalOrg = true;
                if (!AsstActTypeEnum.COMPANY.getValue().equals(payerType)) {
                    long payerId = info.getLong("payer");
                    DynamicObject payeeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)payerId, (String)payerType, (String)"name");
                    DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)info.getDynamicObject("org"), (DynamicObject)payeeObj);
                    checkInternalOrg = EmptyUtil.isNoEmpty((DynamicObject)internalOrg);
                }
                DynamicObject payAccBank2 = AccountBankHelper.getAccountByNumber((String)payerAcctbankNum2);
                if (!checkInternalOrg || !EmptyUtil.isNoEmpty((DynamicObject)payAccBank2) || payAccBank2.getBoolean("iselecpayment")) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u6570\u5e01\u94b1\u5305\u7684\u4e1a\u52a1\uff0c\u6536\u6b3e\u65b9\u8d26\u6237\u548c\u4ed8\u6b3e\u65b9\u8d26\u6237\u5fc5\u987b\u5747\u4e3a\u6570\u5e01\u94b1\u5305\u8d26\u6237\u3002", (String)"PaymentDcepSubmitValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject recAccBank = info.getDynamicObject("accountbank");
            if (!EmptyUtil.isNoEmpty((DynamicObject)recAccBank)) continue;
            boolean isElecPaymentRec = recAccBank.getBoolean("iselecpayment");
            if (isElecPaymentRec) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u975e\u6570\u5e01\u94b1\u5305\uff0c\u6536\u6b3e\u8d26\u6237\u4e0d\u5141\u8bb8\u662f\u94b1\u5305\u8d26\u6237\u3002", (String)"PaymentDcepSubmitValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)(payAccBank = AccountBankHelper.getAccountByNumber((String)(payerAcctbankNum = info.getString("payeracctbanknum"))))) || !payAccBank.getBoolean("iselecpayment")) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u975e\u6570\u5e01\u94b1\u5305\uff0c\u4ed8\u6b3e\u8d26\u6237\u4e0d\u5141\u8bb8\u662f\u94b1\u5305\u8d26\u6237\u3002", (String)"PaymentDcepSubmitValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

