/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.recclaim;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.ClaimTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemParameterHelper;

public class ClaimBeforeValidator
extends AbstractValidator {
    public void validate() {
        Map<String, List<ExtendedDataEntity>> businessType = Arrays.stream(this.dataEntities).collect(Collectors.groupingBy(o -> o.getDataEntity().getString("businesstype")));
        List billNoList = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getString("billno")).collect(Collectors.toList());
        ArrayList<String> billStatusList = new ArrayList<String>();
        billStatusList.add(BillStatusEnum.SUBMIT.getValue());
        billStatusList.add(BillStatusEnum.SAVE.getValue());
        QFilter qFilter = new QFilter("claimno", "in", billNoList);
        QFilter billstatusQf = new QFilter("billstatus", "in", billStatusList);
        QFilter creatorQf = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        QFilter claimtypeQf = new QFilter("claimtype", "=", (Object)ClaimTypeEnum.CLAIM.getValue());
        DynamicObject[] claimBills = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,claimno,billstatus,createtime,entryentity", (QFilter[])new QFilter[]{qFilter, billstatusQf, creatorQf, claimtypeQf});
        Map<String, List<DynamicObject>> claimMap = Arrays.stream(claimBills).collect(Collectors.groupingBy(o -> o.getString("claimno")));
        for (ExtendedDataEntity data : this.dataEntities) {
            List<DynamicObject> claimblls;
            String msg;
            DynamicObject claimData = data.getDataEntity();
            BigDecimal reAmount = claimData.getBigDecimal("reamount");
            BigDecimal unClaimAmount = claimData.getBigDecimal("unclaimamount");
            if (!(StringUtils.equals((CharSequence)claimData.getString("claimstatus"), (CharSequence)ClaimStatusEnum.WAIT.getValue()) || StringUtils.equals((CharSequence)claimData.getString("claimstatus"), (CharSequence)ClaimStatusEnum.PART.getValue()) || StringUtils.equals((CharSequence)claimData.getString("claimstatus"), (CharSequence)ClaimStatusEnum.CLAIMED.getValue()))) {
                String msg2 = ResManager.loadKDString((String)"\u53ea\u6709\u53ef\u8ba4\u9886\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u8fdb\u884c\u8ba4\u9886\u64cd\u4f5c\u3002", (String)"ClaimNoticeEditPlugin_31", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                this.addMessage(data, msg2, ErrorLevel.Error);
            }
            boolean isExcess = SystemParameterHelper.getParameterBoolean((long)claimData.getDynamicObject("org").getLong("id"), (String)"cs120");
            if (businessType.containsKey("pay") && (businessType.containsKey("rec") || businessType.containsKey("recticket"))) {
                msg = ResManager.loadKDString((String)"\u6279\u91cf\u8ba4\u9886\u4e0d\u540c\u65f6\u652f\u6301\u4ed8\u6b3e\u548c\u6536\u6b3e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ClaimBeforeValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(data, msg, ErrorLevel.Error);
            }
            if (!isExcess) {
                if (reAmount.compareTo(BigDecimal.ZERO) > 0 && unClaimAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    msg = ResManager.loadKDString((String)"\u672a\u8ba4\u9886\u91d1\u989d\u5927\u4e8e0\u7684\u8ba4\u9886\u901a\u77e5\u5355\uff0c\u624d\u80fd\u591f\u8ba4\u9886/\u6279\u91cf\u8ba4\u9886\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ClaimBeforeValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addMessage(data, msg, ErrorLevel.Error);
                } else if (reAmount.compareTo(BigDecimal.ZERO) < 0 && unClaimAmount.compareTo(BigDecimal.ZERO) >= 0) {
                    msg = ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u4e3a\u8d1f\u6570\uff0c\u672a\u8ba4\u9886\u91d1\u989d\u5c0f\u4e8e0\u7684\u8ba4\u9886\u901a\u77e5\u5355\uff0c\u624d\u80fd\u591f\u8ba4\u9886/\u6279\u91cf\u8ba4\u9886\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ClaimBeforeValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addMessage(data, msg, ErrorLevel.Error);
                }
            }
            if (null != (claimblls = claimMap.get(claimData.getString("billno"))) && claimblls.size() > 0) {
                List submitDtList = claimblls.stream().filter(o -> BillStatusEnum.SUBMIT.getValue().equals(o.get("billstatus"))).collect(Collectors.toList());
                if (null == submitDtList || submitDtList.size() <= 0) continue;
                String msg3 = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5df2\u6709\u5df2\u63d0\u4ea4\u7684\u8ba4\u9886\u5355\uff0c\u4e0d\u80fd\u8ba4\u9886/\u6279\u91cf\u8ba4\u9886\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ClaimBeforeValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(data, msg3, ErrorLevel.Error);
                continue;
            }
            List<DynamicObject> claimbllsSave = claimMap.get(BillStatusEnum.SAVE.getValue());
            if (null == claimbllsSave || claimbllsSave.size() <= 0) continue;
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cas_claimbill");
            DynamicObject recentObj = new DynamicObject((DynamicObjectType)entityType);
            Date recentDate = null;
            for (DynamicObject claimbill : claimbllsSave) {
                Date createtime = claimbill.getDate("createtime");
                if (recentDate == null) {
                    recentDate = createtime;
                    recentObj = claimbill;
                }
                recentObj = createtime.compareTo(recentDate) > 0 ? claimbill : recentObj;
            }
            if (!CasHelper.isNotEmpty((Object)recentObj) || recentObj.getDynamicObjectCollection("entryentity").size() <= 1) continue;
            String msg4 = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5df2\u6709\u6682\u5b58\u7684\u8ba4\u9886\u5355\uff0c\u4e14\u5b58\u5728\u591a\u6761\u8ba4\u9886\u660e\u7ec6\uff0c\u4e0d\u80fd\u8fdb\u884c\u8ba4\u9886/\u6279\u91cf\u8ba4\u9886\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ClaimBeforeValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            this.addMessage(data, msg4, ErrorLevel.Error);
        }
    }
}

