/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.recclaim;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.BusinessTypeEnum;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.ClaimTypeEnum;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.mutex.impl.DataLocker;
import kd.fi.cas.util.EmptyUtil;

public class ClaimBillAuditValidator
extends AbstractValidator {
    private Set<String> successLatKeys = new HashSet<String>(2);

    public Set<String> getSuccessLatKeys() {
        return this.successLatKeys;
    }

    public void validate() {
        DataLocker dataLocker = new DataLocker();
        try {
            Set claimNoSet = Arrays.stream(this.dataEntities).map(o -> {
                DynamicObject claimData = o.getDataEntity();
                return claimData.getString("claimno");
            }).collect(Collectors.toSet());
            HashSet failedLatKeys = new HashSet(claimNoSet.size());
            dataLocker.batchLock(claimNoSet, this.successLatKeys, failedLatKeys, "cas_claimannounce", "ClaimBillClaimAuditOp");
            HashMap<String, BigDecimal> unClaimAmountMap = new HashMap<String, BigDecimal>(claimNoSet.size());
            QFilter qFilter = new QFilter("billno", "in", claimNoSet);
            DataSet ds = QueryServiceHelper.queryDataSet((String)"queryClaimAnnounce", (String)"cas_claimannounce", (String)"billno,unclaimamount", (QFilter[])qFilter.toArray(), (String)"");
            while (ds.hasNext()) {
                Row row = ds.next();
                unClaimAmountMap.put(row.getString("billno"), row.getBigDecimal("unclaimamount"));
            }
            ds.close();
            List orgIds = Arrays.stream(this.dataEntities).map(s -> s.getDataEntity().getDynamicObject("org").getLong("id")).distinct().collect(Collectors.toList());
            Map orgParams = SystemParameterHelper.getSystemParamsByOrgIds(orgIds);
            QFilter billnoQf = new QFilter("billno", "in", claimNoSet);
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,billno,claimstatus,recpaytype,paymenttype,recpayer", (QFilter[])new QFilter[]{billnoQf});
            Map billNo_claimCenterBill = Arrays.stream(bills).collect(Collectors.toMap(o -> o.getString("billno"), Function.identity()));
            Map<String, List<ExtendedDataEntity>> claimDataMap = Arrays.stream(this.dataEntities).filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getDataEntity().getString("claimno")));
            for (ExtendedDataEntity data : this.dataEntities) {
                BigDecimal diff;
                List<ExtendedDataEntity> claimDataList;
                Long orgId;
                Boolean isExcess;
                String msg;
                DynamicObject cas_claimnoticebill;
                DynamicObject claimData = data.getDataEntity();
                String claimno = claimData.getString("claimno");
                if (failedLatKeys.contains(claimno)) {
                    String msg2 = String.format(ResManager.loadKDString((String)"\u8ba4\u9886\u901a\u77e5\u5355\u3010%s\u3011\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u5728\u8bd5\u3002", (String)"ClaimBillAuditValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), claimno);
                    this.addMessage(data, msg2, ErrorLevel.Error);
                    continue;
                }
                DynamicObjectCollection currencyNewCol = claimData.getDynamicObjectCollection("entryentity");
                if (currencyNewCol == null || currencyNewCol.size() < 1) {
                    String msg3 = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8ba4\u9886\u5355\uff0c\u6536\u6b3e\u8ba4\u9886\u660e\u7ec6\u6570\u636e\u3002", (String)"ClaimBillSubmitValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addMessage(data, msg3, ErrorLevel.Error);
                }
                if (EmptyUtil.isEmpty((DynamicObject)(cas_claimnoticebill = (DynamicObject)billNo_claimCenterBill.get(claimno)))) {
                    String msg4 = ResManager.loadKDString((String)"\u8ba4\u9886\u5355\u5df2\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"ClaimBillSubmitValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addMessage(data, msg4, ErrorLevel.Error);
                    continue;
                }
                String claimtype = claimData.getString("claimtype");
                String claimstatus = cas_claimnoticebill.getString("claimstatus");
                if (StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.CLAIM.getValue()) && !ClaimStatusEnum.WAIT.getValue().equals(claimstatus) && !ClaimStatusEnum.PART.getValue().equals(claimstatus) && !ClaimStatusEnum.CLAIMED.getValue().equals(claimstatus)) {
                    msg = ResManager.loadKDString((String)"\u901a\u77e5\u5355\u4e0d\u4e3a\u5f85\u8ba4\u9886\u3001\u90e8\u5206\u8ba4\u9886\u3001\u5df2\u8ba4\u9886\uff0c\u65e0\u6cd5\u5ba1\u6838\u8ba4\u9886\u5355\uff0c\u8bf7\u8fdb\u884c\u7533\u8bc9\u5904\u7406\u3002", (String)"ClaimBillSubmitValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addMessage(data, msg, ErrorLevel.Error);
                }
                if (StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.CHANGE.getValue()) && !ClaimStatusEnum.SURE.getValue().equals(claimstatus) && !ClaimStatusEnum.CHANGE.getValue().equals(claimstatus)) {
                    msg = ResManager.loadKDString((String)"\u8ba4\u9886\u901a\u77e5\u5355\u4e0d\u4e3a\u5df2\u786e\u8ba4\u3001\u53d8\u66f4\u4e2d\u7684\u72b6\u6001\uff0c\u65e0\u6cd5\u5ba1\u6838\u53d8\u66f4\u5355\u3002", (String)"ClaimBillSubmitValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addMessage(data, msg, ErrorLevel.Error);
                }
                if ((StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.APPEAL.getValue()) || StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.ADJUST.getValue())) && !ClaimStatusEnum.SURE.getValue().equals(claimstatus) && !ClaimStatusEnum.APPEAL.getValue().equals(claimstatus)) {
                    msg = ResManager.loadKDString((String)"\u901a\u77e5\u5355\u4e0d\u4e3a\u5df2\u786e\u8ba4\u3001\u7533\u8bc9\u4e2d\uff0c\u65e0\u6cd5\u5ba1\u6838\u7533\u8bc9\u5355\u3002", (String)"ClaimBillSubmitValidator_9", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addMessage(data, msg, ErrorLevel.Error);
                }
                BigDecimal payAmount = claimData.getBigDecimal("payamount");
                if ((ClaimStatusEnum.PART.getValue().equals(claimstatus) || ClaimStatusEnum.CLAIMED.getValue().equals(claimstatus)) && payAmount.compareTo(BigDecimal.ZERO) == 0) {
                    String paymenttype = cas_claimnoticebill.getString("paymenttype");
                    String recpayer = cas_claimnoticebill.getString("recpayer");
                    String paymenttypeStr = claimData.getString("paymenttype");
                    String recpayerDy = claimData.getString("recpayer");
                    if (!StringUtils.equals((CharSequence)paymenttypeStr, (CharSequence)paymenttype) || !StringUtils.equals((CharSequence)recpayerDy, (CharSequence)recpayer)) {
                        String msg5 = ResManager.loadKDString((String)"\u8ba4\u9886\u901a\u77e5\u5355\u4e0e\u8ba4\u9886\u5355\u4ed8\u6b3e\u4eba\u6570\u636e\u5b58\u5728\u4e0d\u4e00\u81f4\u3002", (String)"ClaimBillSubmitValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addMessage(data, msg5, ErrorLevel.Error);
                    }
                }
                if ((isExcess = (Boolean)((Map)orgParams.get(String.valueOf(orgId = Long.valueOf(claimData.getDynamicObject("org").getLong("id"))))).get("cs120")).booleanValue() || !StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.CLAIM.getValue())) continue;
                String businessType = claimData.getString("businesstype");
                BigDecimal sumActamt = BigDecimal.ZERO;
                if (BusinessTypeEnum.PAY.getValue().equals(businessType)) {
                    DynamicObjectCollection entryEntity = claimData.getDynamicObjectCollection("payentity");
                    for (DynamicObject dynamicObject : entryEntity) {
                        BigDecimal e_payActAmt = dynamicObject.getBigDecimal("e_payactamt");
                        sumActamt = sumActamt.add(e_payActAmt);
                    }
                } else if (BusinessTypeEnum.REC.getValue().equals(businessType) || BusinessTypeEnum.RECTICKET.getValue().equals(businessType)) {
                    DynamicObjectCollection entryentity = claimData.getDynamicObjectCollection("entryentity");
                    for (DynamicObject dynamicObject : entryentity) {
                        BigDecimal e_actamt = dynamicObject.getBigDecimal("e_actamt");
                        sumActamt = sumActamt.add(e_actamt);
                    }
                }
                if (null != (claimDataList = claimDataMap.get(claimData.getString("claimno"))) && claimDataList.size() > 0) {
                    for (ExtendedDataEntity extendedDataEntity : claimDataList) {
                        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                        if (claimData.getString("billno").equals(dataEntity.getString("billno"))) continue;
                        String busType = dataEntity.getString("businesstype");
                        if (BusinessTypeEnum.PAY.getValue().equals(busType)) {
                            DynamicObjectCollection entryEntity = claimData.getDynamicObjectCollection("payentity");
                            for (DynamicObject dynamicObject : entryEntity) {
                                BigDecimal e_payActAmt = dynamicObject.getBigDecimal("e_payactamt");
                                sumActamt = sumActamt.add(e_payActAmt);
                            }
                            continue;
                        }
                        if (!BusinessTypeEnum.REC.getValue().equals(busType) && !BusinessTypeEnum.RECTICKET.getValue().equals(busType)) continue;
                        DynamicObjectCollection entryentity = claimData.getDynamicObjectCollection("entryentity");
                        for (DynamicObject dynamicObject : entryentity) {
                            BigDecimal e_actamt = dynamicObject.getBigDecimal("e_actamt");
                            sumActamt = sumActamt.add(e_actamt);
                        }
                    }
                }
                BigDecimal unClaimAmount = BigDecimal.ZERO;
                if (unClaimAmountMap.get(claimno) != null) {
                    unClaimAmount = (BigDecimal)unClaimAmountMap.get(claimno);
                }
                if ((diff = sumActamt.abs().subtract(unClaimAmount.abs())).compareTo(BigDecimal.ZERO) <= 0) continue;
                String msg6 = ResManager.loadKDString((String)"\u8be5\u8ba4\u9886\u901a\u77e5\u5355\u5b58\u5728\u5176\u4ed6\u7684\u5df2\u5ba1\u6838\u8ba4\u9886\u5904\u7406\u5355\uff0c\u672c\u6b21\u8ba4\u9886\u91d1\u989d\u5927\u4e8e\u5b9e\u9645\u7684\u672a\u8ba4\u9886\u91d1\u989d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ClaimBillAuditValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(data, msg6, ErrorLevel.Error);
            }
        }
        catch (Exception ex) {
            dataLocker.batchRelease(this.successLatKeys, "cas_claimannounce", "ClaimBillClaimAuditOp");
            throw new KDBizException(ex.getMessage());
        }
    }
}

