/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.recclaim;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.RecBillOverAmountHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BusinessTypeEnum;
import kd.fi.cas.enums.ClaimCoreBillTypeEnum;
import kd.fi.cas.enums.ClaimTypeEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.mutex.impl.DataLocker;
import kd.fi.cas.util.EmptyUtil;

public class ClaimBillSubmitValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(ClaimBillSubmitValidator.class);
    private Set<String> successLatKeys = new HashSet<String>(2);

    public Set<String> getSuccessLatKeys() {
        return this.successLatKeys;
    }

    public void validate() {
        List orgIds = Arrays.stream(this.dataEntities).map(s -> s.getDataEntity().getDynamicObject("org").getLong("id")).distinct().collect(Collectors.toList());
        Map orgParams = SystemParameterHelper.getSystemParamsByOrgIds(orgIds);
        DataLocker dataLocker = new DataLocker();
        try {
            Set<String> claimNoSet = Arrays.stream(this.dataEntities).map(o -> {
                DynamicObject claimData = o.getDataEntity();
                return claimData.getString("claimno");
            }).collect(Collectors.toSet());
            HashSet failedLatKeys = new HashSet(claimNoSet.size());
            dataLocker.batchLock(claimNoSet, this.successLatKeys, failedLatKeys, "cas_claimannounce", "ClaimBillClaimSubmitOp");
            Map<String, BigDecimal> unClaimAmountMap = this.getUnClaimAmtMap(claimNoSet);
            QFilter billnoQf = new QFilter("billno", "in", claimNoSet);
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,billno,unclaimamount,isaddfee,fee,singlestream", (QFilter[])new QFilter[]{billnoQf});
            Map billNo_claimCenterBill = Arrays.stream(bills).collect(Collectors.toMap(o -> o.getString("billno"), Function.identity()));
            HashMap<Long, Boolean> isSettleCenterMap = new HashMap<Long, Boolean>(16);
            for (ExtendedDataEntity data : this.dataEntities) {
                String valuedateInfo;
                Object sourceclaim;
                DynamicObjectCollection entrys;
                BigDecimal oldsumact;
                Long sourceclaimid;
                Object[] sourceclaims;
                String msg;
                String msg2;
                String msg3;
                Object entry;
                String msg4;
                Iterator iterator;
                String msg5;
                String msg6;
                long disTypeNum;
                DynamicObject claimData = data.getDataEntity();
                String claimno = claimData.getString("claimno");
                if (failedLatKeys.contains(claimno)) {
                    String msg7 = String.format(ResManager.loadKDString((String)"\u8ba4\u9886\u901a\u77e5\u5355\u3010%s\u3011\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u5728\u8bd5\u3002", (String)"ClaimBillAuditValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), claimno);
                    this.addMessage(data, msg7, ErrorLevel.Error);
                    continue;
                }
                DynamicObject recpaytype = claimData.getDynamicObject("recpaytype");
                DynamicObject org = claimData.getDynamicObject("org");
                if (!EmptyUtil.isEmpty((DynamicObject)recpaytype)) {
                    String bizType = recpaytype.getString("biztype");
                    if (PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue().equals(bizType)) {
                        DynamicObject innerAccount;
                        if (isSettleCenterMap.containsKey(org.getLong("id"))) {
                            if (!((Boolean)isSettleCenterMap.get(org.getLong("id"))).booleanValue()) {
                                String msg8 = ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u91d1\u878d\u673a\u6784\u7c7b\u522b\u4e0d\u662f\u7ed3\u7b97\u4e2d\u5fc3\uff0c\u6536\u6b3e\u7c7b\u578b\u4e0d\u80fd\u9009\u7ed3\u7b97\u4e2d\u5fc3\u6536\u6b3e\u3002", (String)"ClaimBillSubmitValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                                this.addMessage(data, msg8, ErrorLevel.Error);
                                continue;
                            }
                        } else {
                            QFilter typeFilter = new QFilter("finorgtype.type", "=", (Object)"1");
                            QFilter orgFilter = new QFilter("org.id", "=", org.getPkValue());
                            DataSet ds = QueryServiceHelper.queryDataSet((String)"queryFinOrg", (String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{typeFilter.and(orgFilter)}, (String)"");
                            if (!ds.hasNext()) {
                                isSettleCenterMap.put(org.getLong("id"), Boolean.FALSE);
                                ds.close();
                                String msg9 = ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u91d1\u878d\u673a\u6784\u7c7b\u522b\u4e0d\u662f\u7ed3\u7b97\u4e2d\u5fc3\uff0c\u6536\u6b3e\u7c7b\u578b\u4e0d\u80fd\u9009\u7ed3\u7b97\u4e2d\u5fc3\u6536\u6b3e\u3002", (String)"ClaimBillSubmitValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                                this.addMessage(data, msg9, ErrorLevel.Error);
                                continue;
                            }
                            isSettleCenterMap.put(org.getLong("id"), Boolean.TRUE);
                            ds.close();
                        }
                        if (EmptyUtil.isEmpty((DynamicObject)(innerAccount = claimData.getDynamicObject("inneraccount")))) {
                            String msg10 = ResManager.loadKDString((String)"\u6536\u6b3e\u7c7b\u578b\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u6536\u6b3e\u65f6\uff0c\u5173\u8054\u5185\u90e8\u8d26\u6237\u4fe1\u606f\u4e2d\u8d26\u53f7\u5fc5\u586b\u3002", (String)"RecBillInnerAccountValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                            this.addMessage(data, msg10, ErrorLevel.Error);
                            continue;
                        }
                    }
                }
                String claimtype = claimData.getString("claimtype");
                String businessType = claimData.getString("businesstype");
                Boolean isPay = Arrays.asList(BusinessTypeEnum.PAY.getName(), BusinessTypeEnum.PAY.getValue()).contains(businessType);
                if (isPay.booleanValue()) {
                    DynamicObject ePaymentType;
                    boolean multiPaymentType = claimData.getBoolean("multipaymenttype");
                    DynamicObjectCollection payEntries = claimData.getDynamicObjectCollection("payentity");
                    disTypeNum = payEntries.stream().filter(o -> o.getDynamicObject("e_paymenttype") != null).map(o -> o.getDynamicObject("e_paymenttype").getLong("id")).distinct().count();
                    if (multiPaymentType && disTypeNum == 1L) {
                        msg6 = ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u53ea\u6709\u4e00\u79cd\u4ed8\u6b3e\u7c7b\u578b\uff0c\u8bf7\u5173\u95ed\u591a\u4ed8\u6b3e\u7c7b\u578b\u3002", (String)"ClaimBillSubmitValidator_17", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addMessage(data, msg6, ErrorLevel.Error);
                        continue;
                    }
                    if (!multiPaymentType && disTypeNum > 1L) {
                        msg6 = ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u6709\u591a\u79cd\u4ed8\u6b3e\u7c7b\u578b\uff0c\u8bf7\u5f00\u542f\u591a\u4ed8\u6b3e\u7c7b\u578b\u3002", (String)"ClaimBillSubmitValidator_18", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addMessage(data, msg6, ErrorLevel.Error);
                        continue;
                    }
                    DynamicObject payType = claimData.getDynamicObject("paytype");
                    Set ePaymentTypes = payEntries.stream().filter(o -> o.getDynamicObject("e_paymenttype") != null).map(o -> o.getDynamicObject("e_paymenttype")).collect(Collectors.toSet());
                    if (EmptyUtil.isNoEmpty((DynamicObject)payType) && "110".equals(payType.getString("biztype")) && disTypeNum == 1L) {
                        msg5 = ResManager.loadKDString((String)"\u5206\u5f55\u53ea\u6709\u4e00\u79cd\u4ed8\u6b3e\u7c7b\u578b\uff0c\u4f46\u8ba4\u9886\u4fe1\u606f\u4e2d\u5355\u5934\u4ed8\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7efc\u5408\u4ed8\u6b3e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ClaimBillSubmitValidator_19", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addMessage(data, msg5, ErrorLevel.Error);
                        continue;
                    }
                    if (EmptyUtil.isNoEmpty((DynamicObject)payType) && !"110".equals(payType.getString("biztype")) && disTypeNum > 1L) {
                        msg5 = ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u5b58\u5728\u591a\u79cd\u4ed8\u6b3e\u7c7b\u578b\uff0c\u4f46\u8ba4\u9886\u4fe1\u606f\u4e2d\u5355\u5934\u4ed8\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e0d\u4e3a\u7efc\u5408\u4ed8\u6b3e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ClaimBillSubmitValidator_20", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addMessage(data, msg5, ErrorLevel.Error);
                        continue;
                    }
                    if ((!multiPaymentType || disTypeNum == 1L) && EmptyUtil.isNoEmpty((DynamicObject)payType) && (iterator = ePaymentTypes.iterator()).hasNext() && EmptyUtil.isNoEmpty((DynamicObject)(ePaymentType = (DynamicObject)iterator.next())) && ePaymentType.getLong("id") != payType.getLong("id")) {
                        msg4 = ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u53ea\u6709\u4e00\u79cd\u4ed8\u6b3e\u7c7b\u578b\u6216\u975e\u591a\u4ed8\u6b3e\u7c7b\u578b\u65f6\uff0c\u5206\u5f55\u7684\u4ed8\u6b3e\u7c7b\u578b\u5fc5\u987b\u4e0e\u8ba4\u9886\u4fe1\u606f\u4e2d\u5355\u5934\u4ed8\u6b3e\u7c7b\u578b\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ClaimBillSubmitValidator_21", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addMessage(data, msg4, ErrorLevel.Error);
                        continue;
                    }
                    iterator = payEntries.iterator();
                    while (iterator.hasNext()) {
                        entry = (DynamicObject)iterator.next();
                        DynamicObject ePaymentType2 = entry.getDynamicObject("e_paymenttype");
                        if (ePaymentType2 == null || !"110".equals(ePaymentType2.getString("biztype"))) continue;
                        msg3 = ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7684\u4ed8\u6b3e\u7c7b\u578b\u4e0d\u80fd\u662f\u7efc\u5408\u4ed8\u6b3e\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u3002", (String)"ClaimBillSubmitValidator_22", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addMessage(data, msg3, ErrorLevel.Error);
                    }
                } else {
                    DynamicObject eReceivingType;
                    boolean multiReceivingType = claimData.getBoolean("multireceivingtype");
                    DynamicObjectCollection recEntries = claimData.getDynamicObjectCollection("entryentity");
                    disTypeNum = recEntries.stream().filter(o -> o.getDynamicObject("e_receivingtype") != null).map(o -> o.getDynamicObject("e_receivingtype").getLong("id")).distinct().count();
                    if (multiReceivingType && disTypeNum == 1L) {
                        msg6 = ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u53ea\u6709\u4e00\u79cd\u6536\u6b3e\u7c7b\u578b\uff0c\u8bf7\u5173\u95ed\u591a\u6536\u6b3e\u7c7b\u578b\u3002", (String)"ClaimBillSubmitValidator_14", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addMessage(data, msg6, ErrorLevel.Error);
                        continue;
                    }
                    if (!multiReceivingType && disTypeNum > 1L) {
                        msg6 = ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u6709\u591a\u79cd\u6536\u6b3e\u7c7b\u578b\uff0c\u8bf7\u5f00\u542f\u591a\u6536\u6b3e\u7c7b\u578b\u3002", (String)"ClaimBillSubmitValidator_15", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addMessage(data, msg6, ErrorLevel.Error);
                        continue;
                    }
                    DynamicObject recPayType = claimData.getDynamicObject("recpaytype");
                    Set eReceivingTypes = recEntries.stream().filter(o -> o.getDynamicObject("e_receivingtype") != null).map(o -> o.getDynamicObject("e_receivingtype")).collect(Collectors.toSet());
                    if (EmptyUtil.isNoEmpty((DynamicObject)recPayType) && "110".equals(recPayType.getString("biztype")) && disTypeNum == 1L) {
                        msg5 = ResManager.loadKDString((String)"\u5206\u5f55\u53ea\u6709\u4e00\u79cd\u6536\u6b3e\u7c7b\u578b\uff0c\u4f46\u8ba4\u9886\u4fe1\u606f\u4e2d\u5355\u5934\u6536\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7efc\u5408\u6536\u6b3e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ClaimBillSubmitValidator_23", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addMessage(data, msg5, ErrorLevel.Error);
                        continue;
                    }
                    if (EmptyUtil.isNoEmpty((DynamicObject)recPayType) && !"110".equals(recPayType.getString("biztype")) && disTypeNum > 1L) {
                        msg5 = ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u5b58\u5728\u591a\u79cd\u6536\u6b3e\u7c7b\u578b\uff0c\u4f46\u8ba4\u9886\u4fe1\u606f\u4e2d\u5355\u5934\u6536\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e0d\u4e3a\u7efc\u5408\u6536\u6b3e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ClaimBillSubmitValidator_24", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addMessage(data, msg5, ErrorLevel.Error);
                        continue;
                    }
                    if ((!multiReceivingType || disTypeNum == 1L) && EmptyUtil.isNoEmpty((DynamicObject)recPayType) && (iterator = eReceivingTypes.iterator()).hasNext() && EmptyUtil.isNoEmpty((DynamicObject)(eReceivingType = (DynamicObject)iterator.next())) && eReceivingType.getLong("id") != recPayType.getLong("id")) {
                        msg4 = ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u53ea\u6709\u4e00\u79cd\u6536\u6b3e\u7c7b\u578b\u6216\u975e\u591a\u6536\u6b3e\u7c7b\u578b\u65f6\uff0c\u5206\u5f55\u7684\u6536\u6b3e\u7c7b\u578b\u5fc5\u987b\u4e0e\u8ba4\u9886\u4fe1\u606f\u4e2d\u5355\u5934\u6536\u6b3e\u7c7b\u578b\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ClaimBillSubmitValidator_25", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addMessage(data, msg4, ErrorLevel.Error);
                        continue;
                    }
                    iterator = recEntries.iterator();
                    while (iterator.hasNext()) {
                        entry = (DynamicObject)iterator.next();
                        DynamicObject eReceivingType2 = entry.getDynamicObject("e_receivingtype");
                        if (eReceivingType2 == null || !"110".equals(eReceivingType2.getString("biztype"))) continue;
                        msg3 = ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7684\u6536\u6b3e\u7c7b\u578b\u4e0d\u80fd\u662f\u7efc\u5408\u6536\u6b3e\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u3002", (String)"ClaimBillSubmitValidator_26", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addMessage(data, msg3, ErrorLevel.Error);
                    }
                }
                if (!billNo_claimCenterBill.containsKey(claimno)) {
                    String msg11 = ResManager.loadKDString((String)"\u8ba4\u9886\u5355\u5df2\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"ClaimBillSaveValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addMessage(data, msg11, ErrorLevel.Error);
                    continue;
                }
                Long orgId = org.getLong("id");
                boolean isExcess = (Boolean)((Map)orgParams.get(String.valueOf(orgId))).get("cs120");
                DynamicObject clainmCenterBill = (DynamicObject)billNo_claimCenterBill.get(claimno);
                BigDecimal payAmount = claimData.getBigDecimal("payamount");
                if (isPay.booleanValue()) {
                    BigDecimal sumpay = BigDecimal.ZERO;
                    BigDecimal sumact = BigDecimal.ZERO;
                    DynamicObjectCollection payentityCol = claimData.getDynamicObjectCollection("payentity");
                    for (DynamicObject payentity : payentityCol) {
                        sumpay = sumpay.add(payentity.getBigDecimal("e_payableamt"));
                        if ("pay".equals(claimData.getString("businesstype")) && BigDecimal.ZERO.compareTo(payentity.getBigDecimal("e_payactamt")) == 0) {
                            this.addMessage(data, ResManager.loadKDString((String)"\u5b9e\u4ed8\u91d1\u989d\u5e94\u8be5\u5927\u4e8e\u96f6\u3002", (String)"ClaimBillSaveValidator_9", (String)"fi-cas-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        }
                        sumact = sumact.add(payentity.getBigDecimal("e_payactamt"));
                    }
                    BigDecimal claimAmount = claimData.getBigDecimal("claimamount");
                    BigDecimal claimNotAmount = payAmount.subtract(clainmCenterBill.getBigDecimal("fee")).add(sumpay).subtract(sumact);
                    if (clainmCenterBill.getBoolean("singlestream")) {
                        claimNotAmount = claimNotAmount.add(clainmCenterBill.getBigDecimal("fee"));
                    }
                    if (payAmount.compareTo(BigDecimal.ZERO) > 0 && claimAmount.compareTo(BigDecimal.ZERO) < 0) {
                        msg3 = ResManager.loadKDString((String)"\u8ba4\u9886\u91d1\u989d\u7684\u65b9\u5411\u5fc5\u987b\u4e0e\u4ed8\u6b3e\u91d1\u989d\u7684\u65b9\u5411\u4e00\u81f4\u3002", (String)"ClaimBillSaveValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addMessage(data, msg3, ErrorLevel.Error);
                    }
                    if (payAmount.compareTo(BigDecimal.ZERO) < 0 && claimAmount.compareTo(BigDecimal.ZERO) > 0) {
                        msg3 = ResManager.loadKDString((String)"\u8ba4\u9886\u91d1\u989d\u7684\u65b9\u5411\u5fc5\u987b\u4e0e\u4ed8\u6b3e\u91d1\u989d\u7684\u65b9\u5411\u4e00\u81f4\u3002", (String)"ClaimBillSaveValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addMessage(data, msg3, ErrorLevel.Error);
                    }
                    if (null != claimAmount && claimAmount.compareTo(claimNotAmount) > 0) {
                        msg3 = String.format(ResManager.loadKDString((String)"\u8ba4\u9886\u91d1\u989d\u4e0d\u7b49\u4e8e0\uff0c\u4e14\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u53ef\u8ba4\u9886\u91d1\u989d%s", (String)"ClaimBillSaveValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), claimNotAmount);
                        this.addMessage(data, msg3, ErrorLevel.Error);
                    }
                    if (!isExcess) {
                        if (payAmount.compareTo(BigDecimal.ZERO) > 0 && sumact.compareTo(clainmCenterBill.getBigDecimal("unclaimamount")) > 0) {
                            msg3 = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8d85\u989d\u8ba4\u9886\uff0c\u5373\u8ba4\u9886\u5355\u660e\u7ec6\u7684\u201c\u5b9e\u4ed8\u91d1\u989d\u201d\u5408\u8ba1\uff0c\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u672a\u8ba4\u9886\u91d1\u989d\u3002", (String)"ClaimBillSaveValidator_1_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                            this.addMessage(data, msg3, ErrorLevel.Error);
                        } else if (payAmount.compareTo(BigDecimal.ZERO) < 0 && sumact.compareTo(clainmCenterBill.getBigDecimal("unclaimamount")) < 0) {
                            msg3 = ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u4e3a\u8d1f\u6570\uff0c\u4e0d\u5141\u8bb8\u8d85\u989d\u8ba4\u9886\uff0c\u5373\u8ba4\u9886\u5355\u660e\u7ec6\u7684\u201c\u5b9e\u4ed8\u91d1\u989d\u201d\u5408\u8ba1\uff0c\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u672a\u8ba4\u9886\u91d1\u989d\u3002", (String)"ClaimBillSaveValidator_1_4", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                            this.addMessage(data, msg3, ErrorLevel.Error);
                        }
                    }
                    this.checkFields(data, claimData);
                    this.checkOverAmount(isExcess, data, claimData, unClaimAmountMap, claimno, claimtype);
                    continue;
                }
                BigDecimal reamount = claimData.getBigDecimal("reamount");
                DynamicObjectCollection entryentity = claimData.getDynamicObjectCollection("entryentity");
                BigDecimal sumrec = BigDecimal.ZERO;
                BigDecimal sumfee = BigDecimal.ZERO;
                BigDecimal sumdis = BigDecimal.ZERO;
                BigDecimal sumact = BigDecimal.ZERO;
                int i = 1;
                for (DynamicObject dynamicObject : entryentity) {
                    DynamicObject eReceivingType = dynamicObject.getDynamicObject("e_receivingtype");
                    boolean isPartReceivable = eReceivingType != null && eReceivingType.getBoolean("ispartreceivable");
                    String coreBillType = dynamicObject.getString("e_corebilltype");
                    if (Arrays.asList("recticket", "rec").contains(businessType) && isPartReceivable && StringUtils.equals((CharSequence)coreBillType, (CharSequence)ClaimCoreBillTypeEnum.PAYBILL.getValue())) {
                        String payBillNo = dynamicObject.getString("e_corebillno");
                        DynamicObject payBill = BusinessDataServiceHelper.loadSingle((String)"cas_paybill", (String)"id,billno,entry,entry.settleorg,entry.e_localamt,currency", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)payBillNo)});
                        BigDecimal actAmt = dynamicObject.getBigDecimal("e_actamt");
                        DynamicObject settleOrg = dynamicObject.getDynamicObject("e_settleorg");
                        long coreBillEntryId = dynamicObject.getLong("e_corebillentryid");
                        if (payBill != null) {
                            DynamicObjectCollection entryCol = payBill.getDynamicObjectCollection("entry");
                            BigDecimal localAmt = BigDecimal.ZERO;
                            localAmt = coreBillEntryId != 0L ? entryCol.stream().filter(o -> coreBillEntryId == o.getLong("id")).map(o -> o.getBigDecimal("e_localamt")).findFirst().orElse(BigDecimal.ZERO) : entryCol.stream().filter(o -> o.getDynamicObject("settleorg") != null ? o.getDynamicObject("settleorg").getPkValue().equals(settleOrg.getPkValue()) : false).map(o -> o.getBigDecimal("e_localamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                            DynamicObject payBillCurrency = payBill.getDynamicObject("currency");
                            DynamicObject claimBillCurrency = claimData.getDynamicObject("currency");
                            if (payBillCurrency != null && claimBillCurrency != null && payBillCurrency.getPkValue().equals(claimBillCurrency.getPkValue()) && actAmt.compareTo(localAmt) > 0) {
                                String msg12 = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u9000\u6b3e\u7684\u573a\u666f\uff0c\u5b9e\u6536\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u4ed8\u6b3e\u5355\u7684\u201c\u5b9e\u4ed8\u91d1\u989d\u201d\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u9009\u9519\u4ed8\u6b3e\u5355\u3002", (String)"ClaimBillSaveValidator_14", (String)"fi-cas-opplugin", (Object[])new Object[0]), i);
                                this.addMessage(data, msg12, ErrorLevel.Error);
                            }
                        }
                    }
                    if (!StringUtils.equals((CharSequence)ClaimTypeEnum.CHANGE.getValue(), (CharSequence)claimData.getString("claimtype")) && !StringUtils.equals((CharSequence)ClaimTypeEnum.APPEAL.getValue(), (CharSequence)claimData.getString("claimtype")) && clainmCenterBill.getBoolean("isaddfee") && dynamicObject.getBigDecimal("e_fee").compareTo(BigDecimal.ZERO) != 0) {
                        msg2 = String.format(ResManager.loadKDString((String)"\u901a\u77e5\u5355\u5df2\u8865\u5145\u624b\u7eed\u8d39\u3002\u7b2c%s\u884c\u624b\u7eed\u8d39\u91d1\u989d\u5fc5\u987b\u4e3a0\uff0c\u8bf7\u5220\u9664\u6b64\u8ba4\u9886\u5355\u5e76\u91cd\u65b0\u8ba4\u9886\u3002", (String)"ClaimBillSaveValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), i);
                        this.addMessage(data, msg2, ErrorLevel.Error);
                        return;
                    }
                    ++i;
                    sumrec = sumrec.add(dynamicObject.getBigDecimal("e_receivableamt"));
                    sumfee = sumfee.add(dynamicObject.getBigDecimal("e_fee"));
                    sumdis = sumdis.add(dynamicObject.getBigDecimal("e_discountamt"));
                    sumact = sumact.add(dynamicObject.getBigDecimal("e_actamt"));
                }
                reamount = reamount.add(sumdis);
                reamount = clainmCenterBill.getBoolean("isaddfee") ? reamount.add(clainmCenterBill.getBigDecimal("fee")) : reamount.add(sumfee);
                if (reamount.compareTo(BigDecimal.ZERO) > 0 && (sumrec.compareTo(BigDecimal.ZERO) <= 0 || sumrec.compareTo(reamount) > 0)) {
                    msg = String.format(ResManager.loadKDString((String)"\u8ba4\u9886\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff0c\u4e14\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u53ef\u8ba4\u9886\u91d1\u989d%s\uff08\u6536\u6b3e\u91d1\u989d+\u8865\u5145\u624b\u7eed\u8d39\u91d1\u989d+\u73b0\u91d1\u6298\u6263\u5408\u8ba1\uff09\u3002", (String)"ClaimBillSaveValidator_1_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), reamount.setScale(claimData.getDynamicObject("currency").getInt("amtprecision"), 4));
                    this.addMessage(data, msg, ErrorLevel.Error);
                } else if (reamount.compareTo(BigDecimal.ZERO) < 0 && (sumrec.compareTo(BigDecimal.ZERO) >= 0 || sumrec.compareTo(reamount) < 0)) {
                    msg = String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u4e3a\u8d1f\u6570\uff0c\u8ba4\u9886\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e0\uff0c\u4e14\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u53ef\u8ba4\u9886\u91d1\u989d%s\uff08\u6536\u6b3e\u91d1\u989d+\u8865\u5145\u624b\u7eed\u8d39\u91d1\u989d+\u73b0\u91d1\u6298\u6263\u5408\u8ba1\uff09\u3002", (String)"ClaimBillSaveValidator_1_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), reamount.setScale(claimData.getDynamicObject("currency").getInt("amtprecision"), 4));
                    this.addMessage(data, msg, ErrorLevel.Error);
                }
                if (StringUtils.equals((CharSequence)ClaimTypeEnum.CHANGE.getValue(), (CharSequence)claimData.getString("claimtype")) && EmptyUtil.isNoEmpty((Object[])(sourceclaims = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"entryentity.e_actamt", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(sourceclaimid = Long.valueOf(claimData.getLong("sourceclaimid"))))}))) && sumact.compareTo(oldsumact = (entrys = (sourceclaim = sourceclaims[0]).getDynamicObjectCollection("entryentity")).stream().map(dy -> dy.getBigDecimal("e_actamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)) != 0) {
                    msg2 = String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u53d8\u66f4\u5b9e\u6536\u603b\u91d1\u989d\uff0c\u539f\u5b9e\u6536\u603b\u91d1\u989d\u4e3a\u201c%s\u201d\u3002", (String)"ClaimBillSaveValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), oldsumact.setScale(claimData.getDynamicObject("currency").getInt("amtprecision"), 4));
                    this.addMessage(data, msg2, ErrorLevel.Error);
                }
                if (EmptyUtil.isNoEmpty((String)(valuedateInfo = RecClaimHelper.validateAmount((DynamicObject)claimData)))) {
                    this.addMessage(data, valuedateInfo, ErrorLevel.Error);
                }
                this.checkFields(data, claimData);
                RecBillOverAmountHelper.getWriteBackVad((DynamicObject)claimData, (WriteBackOperateEnum)WriteBackOperateEnum.SUBMITVALIDATE, (boolean)true);
                this.checkOverAmount(isExcess, data, claimData, unClaimAmountMap, claimno, claimtype);
            }
        }
        catch (Exception ex) {
            dataLocker.batchRelease(this.successLatKeys, "cas_claimannounce", "ClaimBillClaimSubmitOp");
            throw new KDBizException(ex.getMessage());
        }
    }

    private void checkOverAmount(boolean isExcess, ExtendedDataEntity data, DynamicObject claimData, Map<String, BigDecimal> unClaimAmountMap, String claimno, String claimtype) {
        if (!isExcess && !unClaimAmountMap.isEmpty() && StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.CLAIM.getValue())) {
            BigDecimal diff;
            DynamicObjectCollection entryEntity;
            String headBusinessType = claimData.getString("businesstype");
            BigDecimal sumActamt = BigDecimal.ZERO;
            if (BusinessTypeEnum.PAY.getValue().equals(headBusinessType)) {
                entryEntity = claimData.getDynamicObjectCollection("payentity");
                for (DynamicObject dynamicObject : entryEntity) {
                    BigDecimal e_payActAmt = dynamicObject.getBigDecimal("e_payactamt");
                    sumActamt = sumActamt.add(e_payActAmt);
                }
            } else if (BusinessTypeEnum.REC.getValue().equals(headBusinessType) || BusinessTypeEnum.RECTICKET.getValue().equals(headBusinessType)) {
                entryEntity = claimData.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : entryEntity) {
                    BigDecimal e_actamt = dynamicObject.getBigDecimal("e_actamt");
                    sumActamt = sumActamt.add(e_actamt);
                }
            }
            BigDecimal unClaimAmount = sumActamt;
            if (unClaimAmountMap.get(claimno) != null) {
                unClaimAmount = unClaimAmountMap.get(claimno);
            }
            if ((diff = sumActamt.abs().subtract(unClaimAmount.abs())).compareTo(BigDecimal.ZERO) > 0) {
                String msg = ResManager.loadKDString((String)"\u672c\u6b21\u8ba4\u9886\u91d1\u989d\u5927\u4e8e\u5b9e\u9645\u7684\u53ef\u8ba4\u9886\u91d1\u989d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CAS-E-151630", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(data, msg, ErrorLevel.Error);
            }
        }
    }

    private void checkFields(ExtendedDataEntity data, DynamicObject claimData) {
        String businessType = claimData.getString("businesstype");
        if (Arrays.asList(BusinessTypeEnum.PAY.getName(), BusinessTypeEnum.PAY.getValue()).contains(businessType)) {
            DynamicObject payType = claimData.getDynamicObject("paytype");
            this.message(data, payType, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ClaimBillSubmitValidator_10", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            String receiveType = claimData.getString("payeetype");
            this.message(data, receiveType, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ClaimBillSubmitValidator_11", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            if (!"other".equals(receiveType)) {
                String recPayee = claimData.getString("recpayee");
                this.message(data, recPayee, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ClaimBillSubmitValidator_12", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
        } else {
            DynamicObject receiveType = claimData.getDynamicObject("recpaytype");
            this.message(data, receiveType, ResManager.loadKDString((String)"\u6536\u6b3e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ClaimBillSubmitValidator_13", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            String paymentType = claimData.getString("paymenttype");
            if (!"other".equals(paymentType)) {
                String recPayee = claimData.getString("recpayer");
                this.message(data, recPayee, ResManager.loadKDString((String)"\u4ed8\u6b3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ClaimBillSaveValidator_15", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private Map<String, BigDecimal> getUnClaimAmtMap(Set<String> claimNoSet) {
        HashMap<String, BigDecimal> unClaimAmountMap = new HashMap<String, BigDecimal>(2);
        QFilter claimQFilter = new QFilter("claimno", "in", claimNoSet);
        String[] status = new String[]{"B", "C"};
        claimQFilter.and("billstatus", "in", (Object)status);
        DynamicObjectCollection claimBills = QueryServiceHelper.query((String)"cas_claimbill", (String)"billno,claimno,payamount,reamount,businesstype,payentity,entryentity,payentity.e_payactamt,entryentity.e_actamt", (QFilter[])claimQFilter.toArray());
        for (DynamicObject claimBill : claimBills) {
            String claimNo = claimBill.getString("claimno");
            String businessType = claimBill.getString("businesstype");
            if (unClaimAmountMap.get(claimNo) == null) {
                if (BusinessTypeEnum.PAY.getValue().equals(businessType)) {
                    unClaimAmountMap.put(claimNo, claimBill.getBigDecimal("payamount"));
                } else if (BusinessTypeEnum.REC.getValue().equals(businessType) || BusinessTypeEnum.RECTICKET.getValue().equals(businessType)) {
                    unClaimAmountMap.put(claimNo, claimBill.getBigDecimal("reamount"));
                }
            }
            BigDecimal decimal = (BigDecimal)unClaimAmountMap.get(claimNo);
            BigDecimal sumActamt = BigDecimal.ZERO;
            if (BusinessTypeEnum.PAY.getValue().equals(businessType)) {
                BigDecimal e_payActAmt = claimBill.getBigDecimal("payentity.e_payactamt");
                sumActamt = sumActamt.add(e_payActAmt);
            } else if (BusinessTypeEnum.REC.getValue().equals(businessType) || BusinessTypeEnum.RECTICKET.getValue().equals(businessType)) {
                BigDecimal e_actamt = claimBill.getBigDecimal("entryentity.e_actamt");
                sumActamt = sumActamt.add(e_actamt);
            }
            BigDecimal unClaimAmt = decimal.subtract(sumActamt);
            unClaimAmountMap.put(claimNo, unClaimAmt);
        }
        return unClaimAmountMap;
    }

    private void message(ExtendedDataEntity data, Object value, String message) {
        if (EmptyUtil.isEmpty((Object)value)) {
            this.addMessage(data, message, ErrorLevel.Error);
        }
    }
}

