/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.recclaim;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ClaimHandleStatusEnum;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.ClaimTypeEnum;
import kd.fi.cas.util.EmptyUtil;

public class ClaimBillUnAuditValidator
extends AbstractValidator {
    public void validate() {
        Set claimNoSet = Arrays.stream(this.dataEntities).map(o -> {
            DynamicObject claimData = o.getDataEntity();
            return claimData.getString("claimno");
        }).collect(Collectors.toSet());
        HashMap<String, String> billNo_claimStatus = new HashMap<String, String>(10);
        QFilter billnoQf = new QFilter("billno", "in", claimNoSet);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryClaimCenterBill", (String)"cas_claimcenterbill", (String)"id,billno,claimstatus", (QFilter[])new QFilter[]{billnoQf}, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                billNo_claimStatus.put(row.getString("billno"), row.getString("claimstatus"));
            }
        }
        for (ExtendedDataEntity data : this.dataEntities) {
            String msg;
            String claimno;
            DynamicObject claimData = data.getDataEntity();
            String billstatus = claimData.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billstatus)) {
                String msg2 = ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd\u6267\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"ClaimBillUnSubmitValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(data, msg2, ErrorLevel.Error);
            }
            if (!billNo_claimStatus.containsKey(claimno = claimData.getString("claimno"))) {
                String msg3 = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u901a\u77e5\u5355\u3002", (String)"ClaimBillUnSubmitValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(data, msg3, ErrorLevel.Error);
            }
            String claimstatus = (String)billNo_claimStatus.get(claimno);
            String claimtype = claimData.getString("claimtype");
            String handlestatus = claimData.getString("handlestatus");
            if (StringUtils.equals((CharSequence)handlestatus, (CharSequence)ClaimHandleStatusEnum.CLAIMED.getValue())) {
                msg = ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\u7684\u8ba4\u9886\u5355\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ClaimBillUnSubmitValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(data, msg, ErrorLevel.Error);
            }
            if (StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.CLAIM.getValue()) && !ClaimStatusEnum.WAIT.getValue().equals(claimstatus) && !ClaimStatusEnum.PART.getValue().equals(claimstatus) && !ClaimStatusEnum.CLAIMED.getValue().equals(claimstatus)) {
                msg = ResManager.loadKDString((String)"\u901a\u77e5\u5355\u4e0d\u4e3a\u5f85\u8ba4\u9886\u3001\u90e8\u5206\u8ba4\u9886\u3001\u5df2\u8ba4\u9886\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u8ba4\u9886\u5355\u3002", (String)"ClaimBillUnSubmitValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(data, msg, ErrorLevel.Error);
            }
            if (StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.CHANGE.getValue()) && !ClaimStatusEnum.CHANGE.getValue().equals(claimstatus)) {
                msg = ResManager.loadKDString((String)"\u901a\u77e5\u5355\u4e0d\u4e3a\u53d8\u66f4\u4e2d\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u53d8\u66f4\u5355\u3002", (String)"ClaimBillUnSubmitValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(data, msg, ErrorLevel.Error);
            }
            if ((StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.APPEAL.getValue()) || StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.ADJUST.getValue())) && !ClaimStatusEnum.APPEAL.getValue().equals(claimstatus)) {
                msg = ResManager.loadKDString((String)"\u901a\u77e5\u5355\u4e0d\u4e3a\u201c\u7533\u8bc9\u4e2d\u201d\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u7533\u8bc9\u5355\u6216\u8c03\u6574\u5355\u3002", (String)"ClaimBillUnSubmitValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(data, msg, ErrorLevel.Error);
            }
            if (!StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.APPEAL.getValue())) continue;
            QFilter qFilter = new QFilter("claimno", "=", (Object)claimno);
            qFilter.and(new QFilter("handlestatus", "=", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue())).and(new QFilter("billstatus", "=", (Object)"H"));
            Object[] claimbills = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (!EmptyUtil.isNoEmpty((Object[])claimbills)) continue;
            String msg4 = ResManager.loadKDString((String)"\u7533\u8bc9\u5df2\u5728\u5904\u7406\u4e2d\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u3002\u5982\u6709\u95ee\u9898\uff0c\u53ef\u8054\u7cfb\u8ba4\u9886\u7ed3\u679c\u786e\u8ba4\u4eba\u5458\u8fdb\u884c\u9a73\u56de\u3002", (String)"ClaimBillUnSubmitValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            this.addMessage(data, msg4, ErrorLevel.Error);
        }
    }
}

