/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.recclaim;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.MergeStatusEnum;
import kd.fi.cas.util.EmptyUtil;

public class RecClaimCancelNoticeValidator
extends AbstractValidator {
    public void validate() {
        if (!EmptyUtil.isEmpty((Object[])this.dataEntities)) {
            Set claimCenterBillNos = Arrays.stream(this.dataEntities).map(entity -> entity.getDataEntity().getString("billno")).collect(Collectors.toSet());
            Set claimBillNumbers = QueryServiceHelper.query((String)"cas_claimbill", (String)"id,claimno", (QFilter[])new QFilter("claimno", "in", claimCenterBillNos).toArray()).stream().map(claimbill -> claimbill.getString("claimno")).collect(Collectors.toSet());
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                Boolean isunclaims;
                DynamicObject info = dataEntity.getDataEntity();
                String claimstatus = info.getString("claimstatus");
                if (!ClaimStatusEnum.WAIT.getValue().equals(claimstatus)) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u53d1\u8d77\u8ba4\u9886\u901a\u77e5\uff0c\u4e14\u5904\u4e8e\u201c\u5f85\u8ba4\u9886\u201d\u72b6\u6001\u7684\uff0c\u624d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"RecClaimCancelNoticeValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                if (claimBillNumbers.contains(info.getString("billno"))) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u53d1\u8d77\u8ba4\u9886\u901a\u77e5\uff0c\u4e14\u4e0d\u5b58\u5728\u672a\u5904\u7406\u7684\u8ba4\u9886\u5355\uff0c\u624d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"RecClaimCancelNoticeValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
                if ((isunclaims = Boolean.valueOf(info.getBoolean("isunclaim"))).booleanValue()) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u901a\u77e5\u5355\u5df2\u7ecf\u8fdb\u884c\u4e86\u672a\u8ba4\u9886\u5165\u8d26\u64cd\u4f5c\uff0c\u65e0\u6cd5\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"RecClaimCancelNoticeValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                String mergestatus = info.getString("mergestatus");
                if (StringUtils.equals((CharSequence)MergeStatusEnum.UNMARGE.getValue(), (CharSequence)mergestatus)) continue;
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u901a\u77e5\u5355\u4e0d\u662f\u672a\u5408\u5e76\u72b6\u6001\uff0c\u65e0\u6cd5\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"RecClaimCancelNoticeValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            }
        }
    }
}

