/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.receivingbill;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.opservice.helper.RecPayRuleHelper;
import kd.fi.cas.business.opservice.helper.ValidAndSetMatchInfoHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;

public class ReceivingIntelRecValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(ReceivingIntelRecValidator.class);

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            String errInfo = this.RecBillSaveImpl_validate(info);
            if (!StringUtils.isEmpty((CharSequence)errInfo)) {
                this.addErrorMessage(dataEntity, errInfo);
                break;
            }
            errInfo = this.isNotIniOrg(info);
            if (!StringUtils.isEmpty((CharSequence)errInfo)) {
                this.addErrorMessage(dataEntity, errInfo);
                break;
            }
            String sourceBillType = info.getString("sourcebilltype");
            boolean isFromDb = info.getDataEntityState().getFromDatabase();
            if (!isFromDb && "bei_intelrec".equals(sourceBillType) && !this.getOption().containsVariable("returnDataByOpHand") && !this.getOption().containsVariable("returnDataByOpHandMerge")) {
                DynamicObject payEntry = (DynamicObject)info.getDynamicObjectCollection("entry").get(0);
                Map returnPay = RecPayRuleHelper.getInfoByMatchRule((DynamicObject)info, (String)"rec");
                if (!CasHelper.isEmpty((Object)returnPay) && returnPay.size() > 0) {
                    errInfo = this.setRecValueByRule(returnPay, info, payEntry, "bei_intelrec");
                }
            }
            if (StringUtils.isEmpty((CharSequence)errInfo)) continue;
            this.addErrorMessage(dataEntity, errInfo);
        }
    }

    private String isNotIniOrg(DynamicObject recBill) {
        Long orgId;
        DynamicObject baseCurrency;
        Long baseCurrencyId;
        String sourceBillType = recBill.getString("sourcebilltype");
        String formID = recBill.getDataEntityType().getName();
        if ((!CasHelper.isEmpty((Object)sourceBillType) || "cas_paybill".equals(formID)) && CasHelper.isEmpty((Object)(baseCurrencyId = DynamicObjectHelper.getPk((DynamicObject)recBill, (String)"basecurrency"))) && (baseCurrency = OrgHelper.getBaseCurrency((long)(orgId = DynamicObjectHelper.getPk((DynamicObject)recBill, (String)"org")))) == null) {
            return ResManager.loadKDString((String)"\u7ec4\u7ec7\u672a\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u4e0d\u80fd\u4fdd\u5b58\u5355\u636e\u3002", (String)"RecBillSaveImpl_1", (String)"fi-cas-business", (Object[])new Object[0]);
        }
        return "";
    }

    private String setRecValueByRule(Map<String, Object> returnRec, DynamicObject recBill, DynamicObject entry, String sourceBillType) {
        String payertype = String.valueOf(returnRec.get("e_payertype"));
        Object e_payer = returnRec.get("e_payer");
        if (("bei_transdetail_cas".equals(sourceBillType) || "bei_transdetail".equals(sourceBillType) || "bei_intelrec".equals(sourceBillType)) && EmptyUtil.isEmpty((Object)e_payer)) {
            logger.info("ReceivingIntelRecValidator.setRecValueByRule.validAndSetMatchInfo");
            return ValidAndSetMatchInfoHelper.validAndSetMatchInfo((DynamicObject)recBill, (String)payertype, (String)"rec", (boolean)false);
        }
        return "";
    }

    private String RecBillSaveImpl_validate(DynamicObject info) {
        String sourceBillType = info.getString("sourcebilltype");
        long sourceBillId = info.getLong("sourcebillid");
        String sourceBillNumbers = info.getString("sourcebillnumber");
        String[] split = sourceBillNumbers.split(",");
        if (!CasHelper.isEmpty((Object)sourceBillType) && !CasHelper.isEmpty((Object)sourceBillId) && "bei_intelrec".equals(sourceBillType)) {
            DynamicObject intelrecObj = null;
            try {
                intelrecObj = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)sourceBillType);
            }
            catch (RuntimeException e) {
                return ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e3a\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u751f\u6210\u7684\u6536\u6b3e\u5355\uff0c\u4f46\u5bf9\u5e94\u7684\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"RecBillSaveImpl_3", (String)"fi-cas-business", (Object[])new Object[0]);
            }
            if (intelrecObj != null) {
                BigDecimal creditamount = intelrecObj.getBigDecimal("creditamount");
                BigDecimal actrecamt = info.getBigDecimal("actrecamt");
                DynamicObject currency = info.getDynamicObject("currency");
                String sign = "\uffe5";
                if (currency != null) {
                    sign = currency.getString("sign");
                }
                if (split.length <= 1 && creditamount.compareTo(actrecamt) != 0) {
                    return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e3a\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u751f\u6210\u7684\u6536\u6b3e\u5355\uff0c\u5b9e\u6536\u91d1\u989d\u5fc5\u987b\u7b49\u4e8e\u4ea4\u6613\u660e\u7ec6\u7684\u6536\u6b3e\u91d1\u989d\uff08%1$s %2$s\uff09\u3002", (String)"RecBillSaveImpl_4", (String)"fi-cas-business", (Object[])new Object[0]), sign, creditamount);
                }
            }
        } else if (!CasHelper.isEmpty((Object)sourceBillType) && !CasHelper.isEmpty((Object)sourceBillId) && "cas_claimcenterbill".equals(sourceBillType)) {
            DynamicObject intelrecObj = null;
            try {
                intelrecObj = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)sourceBillType);
            }
            catch (RuntimeException e) {
                return ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e3a\u8ba4\u9886\u901a\u77e5\u5355\u751f\u6210\u7684\u6536\u6b3e\u5355\uff0c\u4f46\u5bf9\u5e94\u7684\u8ba4\u9886\u901a\u77e5\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"RecBillSaveImpl_5", (String)"fi-cas-business", (Object[])new Object[0]);
            }
            if (intelrecObj != null) {
                BigDecimal creditamount = intelrecObj.getBigDecimal("reamount");
                BigDecimal actrecamt = info.getBigDecimal("actrecamt");
                DynamicObject currency = info.getDynamicObject("currency");
                String sign = "\uffe5";
                if (currency != null) {
                    sign = currency.getString("sign");
                }
                if (split.length > 1 || creditamount.compareTo(actrecamt) != 0) {
                    // empty if block
                }
            }
        }
        return "";
    }
}

