/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.receivingbill;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.util.EmptyUtil;

public class ReceivingTypeValidator
extends AbstractValidator {
    public void validate() {
        List orgIds = Arrays.stream(this.dataEntities).map(s -> s.getDataEntity().getDynamicObject("org").getLong("id")).collect(Collectors.toList());
        Map params = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)new AppParam("d2bb1733000000ac", "08", null, Long.valueOf(0L)), orgIds);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            boolean cs118;
            DynamicObject e_receivingtype;
            DynamicObject info = dataEntity.getDataEntity();
            String sourceType = info.getString("sourcebilltype");
            Long orgId = info.getDynamicObject("org").getLong("id");
            boolean multipaymenttype = info.getBoolean("multireceivingtype");
            String payertype = info.getString("payertype");
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
            if (ReceivingTypeValidator.isApAr(sourceType) && EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
                for (Object entry : entrys) {
                    boolean ispartreceivable;
                    e_receivingtype = entry.getDynamicObject("e_receivingtype");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)e_receivingtype) || (ispartreceivable = e_receivingtype.getBoolean("ispartreceivable"))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0a\u6e38\u6709\u8d22\u52a1\u5e94\u4ed8\u5355\u3001\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u6536\u6b3e\u7c7b\u578b\u5fc5\u987b\u662f\u53c2\u4e0e\u5e94\u6536\u7ed3\u7b97\u3002", (String)"ReceivingTypeValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    break;
                }
            }
            if ("sm_salorder".equals(sourceType) && EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
                for (Object entry : entrys) {
                    e_receivingtype = entry.getDynamicObject("e_receivingtype");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)e_receivingtype)) continue;
                    boolean ispartpayment = e_receivingtype.getBoolean("ispartreceivable");
                    String biztype = e_receivingtype.getString("biztype");
                    if (ispartpayment && "101".equals(biztype)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0a\u6e38\u662f\u9500\u552e\u8ba2\u5355\uff0c\u6536\u6b3e\u7c7b\u578b\u5fc5\u987b\u662f\u53c2\u4e0e\u7ed3\u7b97\u4e14\u4e1a\u52a1\u7c7b\u578b\u4e3a\u9884\u6536\u6b3e\u3002", (String)"ReceivingTypeValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    break;
                }
            }
            boolean selectallPayertype = (Boolean)((Map)params.get(String.valueOf(orgId))).get("selectallpayertype");
            if (multipaymenttype && !selectallPayertype && EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
                Object entry;
                entry = entrys.iterator();
                while (entry.hasNext()) {
                    boolean ispartreceivable;
                    DynamicObject entry2 = (DynamicObject)entry.next();
                    DynamicObject e_receivingtype2 = entry2.getDynamicObject("e_receivingtype");
                    if (e_receivingtype2 == null || !(ispartreceivable = e_receivingtype2.getBoolean("ispartreceivable")) || !AsstActTypeEnum.OTHER.getValue().equals(payertype) && !AsstActTypeEnum.COMPANY.getValue().equals(payertype)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u660e\u7ec6\u4e2d\u5b58\u5728\u53c2\u4e0e\u7ed3\u7b97\u7684\u6536\u6b3e\u7c7b\u578b\uff0c\u5339\u914d\u7684\u4ed8\u6b3e\u4eba\u7c7b\u578b\u662f\u3010\u4f9b\u5e94\u5546/\u5ba2\u6237/\u804c\u5458\u3011\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"ReceivingTypeValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    break;
                }
            }
            if (!(cs118 = ((Boolean)((Map)params.get(String.valueOf(orgId))).get("cs118")).booleanValue()) || !EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) continue;
            int i = 1;
            for (DynamicObject entry : entrys) {
                DynamicObject settleOrg = entry.getDynamicObject("e_settleorg");
                DynamicObject receivingType = entry.getDynamicObject("e_receivingtype");
                if (EmptyUtil.isNoEmpty((DynamicObject)receivingType) && receivingType.getBoolean("ispartreceivable") && EmptyUtil.isNoEmpty((DynamicObject)settleOrg) && !orgId.equals(settleOrg.getLong("id"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u672c\u5355\u6d89\u53ca\u4ee3\u7406\u6536\u6b3e\uff0c\u4e14\u5f00\u542f\u4e86\u4ee3\u7406\u6536\u6b3e\u5173\u8054\u751f\u6210\u7ed3\u7b97\u7ec4\u7ec7\u865a\u62df\u6536\u6b3e\u5355\u53c2\u6570\uff0c\u8bf7\u5c06\u4ee3\u7406\u6536\u6b3e\u884c\u6536\u6b3e\u7c7b\u578b\u5207\u6362\u4e3a\u4e0d\u53c2\u4e0e\u7ed3\u7b97\uff0c\u9632\u6b62\u4ea7\u751f\u91cd\u590d\u53ef\u7ed3\u7b97\u6570\u636e\u548c\u91cd\u590d\u5e94\u6536\u6d41\u6c34\u3002", (String)"ReceivingTypeValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[]{i}));
                }
                ++i;
            }
        }
    }

    private static boolean isApAr(String sourceType) {
        return "ar_finarbill".equals(sourceType) || "ap_finapbill".equals(sourceType);
    }
}

