/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.recinit;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class RecInitFinishInitValidator
extends AbstractValidator {
    public void validate() {
        Set orgIdList = Arrays.stream(this.dataEntities).filter(c -> c.getDataEntity().getDynamicObject("org") != null).map(c -> c.getDataEntity().getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(orgIdList)) {
            return;
        }
        Map orgInitMap = SystemStatusCtrolHelper.getSystemStatusCtrol(orgIdList);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject casRecInit;
            DynamicObject recInit = dataEntity.getDataEntity();
            DynamicObject org = recInit.getDynamicObject("org");
            boolean isfinishinit = recInit.getBoolean("isfinishinit");
            DynamicObjectCollection entryBankList = recInit.getDynamicObjectCollection("entrybank");
            Long id = recInit.getLong("id");
            if (id != null && EmptyUtil.isNoEmpty((DynamicObject)(casRecInit = BusinessDataServiceHelper.loadSingle((String)"cas_rec_init", (String)"id, isfinishinit", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)})))) {
                isfinishinit = casRecInit.getBoolean("isfinishinit");
            }
            if (isfinishinit) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u5bf9\u8d26\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u64cd\u4f5c\u3002", (String)"RecInitFinishInitValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            DynamicObject orgInit = (DynamicObject)orgInitMap.get(org.getString("id"));
            DynamicObject currentPeriod = orgInit.getDynamicObject("currentperiod");
            if (orgInit == null || currentPeriod == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ec4\u7ec7\u672a\u7ed3\u675f\u51fa\u7eb3\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u7ed3\u675f\u5bf9\u8d26\u521d\u59cb\u5316\u3002", (String)"RecInitFinishInitValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            DynamicObject recInitPeriod = recInit.getDynamicObject("initperiod");
            if (currentPeriod != null && !currentPeriod.getPkValue().equals(recInitPeriod.getPkValue())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ec4\u7ec7\u5f53\u524d\u671f\u95f4\u5df2\u53d8\u5316\uff0c\u8bf7\u786e\u8ba4\u5bf9\u8d26\u521d\u59cb\u5316\u671f\u95f4\u662f\u5426\u6b63\u786e\uff0c\u5982\u9700\u7ee7\u7eed\u8bf7\u5148\u53cd\u7ed3\u8d26\u4f7f\u5f97\u5f53\u524d\u671f\u95f4\u4e0e\u5bf9\u8d26\u521d\u59cb\u5316\u671f\u95f4\u76f8\u540c\uff0c\u6216\u8005\u9488\u5bf9\u6700\u65b0\u5f53\u524d\u671f\u95f4\u8fdb\u884c\u5bf9\u8d26\u521d\u59cb\u5316\u3002", (String)"RecInitFinishInitValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            for (DynamicObject entryBank : entryBankList) {
                BigDecimal statementBalanceAdj;
                BigDecimal journalSumBalanceAdj = entryBank.getBigDecimal("bank_journalsumbalanceadj").setScale(10, 4);
                if (journalSumBalanceAdj.compareTo(statementBalanceAdj = entryBank.getBigDecimal("bank_statementbalanceadj").setScale(10, 4)) == 0) continue;
                String msg = StringUtils.formatMessage((String)ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u201c{0}{1}\u201d\u7684\u8c03\u6574\u540e\u65e5\u8bb0\u8d26\u603b\u4f59\u989d\u4e0e\u8c03\u6574\u540e\u5bf9\u8d26\u5355\u603b\u4f59\u989d\u4e0d\u5e73\u8861\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"RecInitFinishInitValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), (Object[])new Object[]{entryBank.getDynamicObject("bank_accountbank").getString("name"), entryBank.getDynamicObject("bank_currency").getString("name")});
                this.addErrorMessage(dataEntity, msg);
            }
        }
    }
}

