/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.recpayrule;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.CasHelper;

public class RecPayRuleSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection entryentity;
            DynamicObject recPayRule = dataEntity.getDataEntity();
            String biztype = recPayRule.getString("biztype");
            DynamicObjectCollection orgEntrys = recPayRule.getDynamicObjectCollection("org_entry");
            HashSet<DynamicObject> orgSet = new HashSet<DynamicObject>();
            for (DynamicObject orgEntry : orgEntrys) {
                if (orgEntry.getDynamicObject("u_org") == null) continue;
                orgSet.add(orgEntry.getDynamicObject("u_org"));
            }
            QFilter biztypeQf = new QFilter("biztype", "=", (Object)biztype);
            biztypeQf.and(new QFilter("enable", "=", (Object)"1"));
            QFilter idQf = new QFilter("id", "!=", recPayRule.getPkValue());
            DynamicObject[] recpayrules = BusinessDataServiceHelper.load((String)"cas_recpayrule", (String)"id,number,org_entry,org_entry.u_org", (QFilter[])new QFilter[]{idQf, biztypeQf});
            Boolean isExist = false;
            DynamicObject orgExits = null;
            HashMap<Object, HashSet<String>> orgToBillNo = new HashMap<Object, HashSet<String>>();
            if (orgSet.size() > 0) {
                Set orgCollect = Arrays.stream(recpayrules).map(rec -> rec.getDynamicObjectCollection("org_entry")).flatMap(Collection::stream).filter(o -> o.getDynamicObject("u_org") != null).map(o -> o.getDynamicObject("u_org").getPkValue()).collect(Collectors.toSet());
                for (DynamicObject recpayrule : recpayrules) {
                    DynamicObjectCollection dynamicObjectCollection = recpayrule.getDynamicObjectCollection("org_entry");
                    for (DynamicObject dynamicObject : dynamicObjectCollection) {
                        DynamicObject u_org = dynamicObject.getDynamicObject("u_org");
                        if (u_org == null) continue;
                        HashSet<String> setBillNo = (HashSet<String>)orgToBillNo.get(u_org.getPkValue());
                        if (setBillNo == null) {
                            setBillNo = new HashSet<String>();
                        }
                        setBillNo.add(recpayrule.getString("number"));
                        orgToBillNo.put(u_org.getPkValue(), setBillNo);
                    }
                }
                for (DynamicObject org : orgSet) {
                    if (!orgCollect.contains(org.getPkValue())) continue;
                    isExist = true;
                    orgExits = org;
                    break;
                }
            } else {
                for (DynamicObject recpayrule : recpayrules) {
                    DynamicObjectCollection dynamicObjectCollection = recpayrule.getDynamicObjectCollection("org_entry");
                    if (dynamicObjectCollection.size() != 0) continue;
                    isExist = true;
                    break;
                }
            }
            if (isExist.booleanValue()) {
                String bizTypeStr = "";
                bizTypeStr = biztype.equals("rec") ? ResManager.loadKDString((String)"\u6536\u6b3e", (String)"RecPayRuleEnableValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e", (String)"RecPayRuleEnableValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                if (orgSet.size() > 0 && orgExits != null) {
                    Set billnos = (Set)orgToBillNo.get(orgExits.getPkValue());
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String billno : billnos) {
                        stringBuilder.append(billno).append(',');
                    }
                    String substring = stringBuilder.toString().substring(0, stringBuilder.toString().length() - 1);
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u5728\u4e1a\u52a1\u7c7b\u578b\u4e3a\u201c%2$s\u201d\u5df2\u7ecf\u5b58\u5728\u201c\u53ef\u7528\u201d\u72b6\u6001\u7684\u201c\u751f\u5355/\u901a\u77e5\u89c4\u5219\u201d\uff08\u5355\u636e\u7f16\u53f7\u201c%3$s\u201d\uff09\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RecPayRuleSaveValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), orgExits.getString("name"), bizTypeStr, substring), ErrorLevel.Error);
                } else {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5728\u4e1a\u52a1\u7c7b\u578b\u4e3a\u201d%s\u201c\u65f6\u5df2\u7ecf\u5b58\u5728\u201c\u9002\u7528\u5168\u7ec4\u7ec7\u201d\u7684\u6536\u4ed8\u5165\u8d26\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RecPayRuleSaveValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), bizTypeStr), ErrorLevel.Error);
                }
            }
            if ((entryentity = recPayRule.getDynamicObjectCollection("entryentity")) == null || entryentity.size() == 0) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5165\u8d26\u89c4\u5219\u3002", (String)"RecPayRuleSaveValidator_70", (String)"fi-cas-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                return;
            }
            for (int i = 0; i < entryentity.size(); ++i) {
                boolean flag;
                String handleBill;
                DynamicObject entry = (DynamicObject)entryentity.get(i);
                String filterStr = entry.getString("e_datafilter_TAG");
                String handlescheme = entry.getString("e_handlescheme");
                if (CasHelper.isNotEmpty((Object)filterStr) && !"".equals(filterStr)) {
                    String payer = entry.getString("e_payer");
                    boolean isCustomer = filterStr.contains("IsCustomer");
                    boolean isSupplier = filterStr.contains("IsSupplier");
                    boolean isInnerSC = filterStr.contains("IsInnerSC");
                    if (isCustomer && isSupplier) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5165\u8d26\u89c4\u5219\u7b2c%s\u884c\uff1a\u9002\u7528\u6761\u4ef6\u540c\u65f6\u4f7f\u7528\u4e86\u201c\u4ea4\u6613\u5bf9\u65b9\u662f\u5426\u5ba2\u6237\u201d,\u201c\u4ea4\u6613\u5bf9\u65b9\u662f\u5426\u4f9b\u5e94\u5546\u201d\u591a\u4e2a\u51fd\u6570\uff0c\u5b58\u5728\u51b2\u7a81\u3002\u8bf7\u6839\u636e\u5b9e\u9645\u60c5\u51b5\uff0c\u4f7f\u7528\u5176\u4e2d\u4e00\u4e2a\u51fd\u6570\u3002", (String)"RecPayRuleSaveValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
                        return;
                    }
                    if (isCustomer && isInnerSC) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5165\u8d26\u89c4\u5219\u7b2c%s\u884c\uff1a\u9002\u7528\u6761\u4ef6\u540c\u65f6\u4f7f\u7528\u4e86\u201c\u4ea4\u6613\u5bf9\u65b9\u662f\u5426\u5ba2\u6237\u201d,\u201c\u662f\u5426\u5185\u90e8\u5ba2\u5546\u201d\u591a\u4e2a\u51fd\u6570\uff0c\u5b58\u5728\u51b2\u7a81\u3002\u8bf7\u6839\u636e\u5b9e\u9645\u60c5\u51b5\uff0c\u4f7f\u7528\u5176\u4e2d\u4e00\u4e2a\u51fd\u6570\u3002", (String)"RecPayRuleSaveValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
                        return;
                    }
                    if (isSupplier && isInnerSC) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5165\u8d26\u89c4\u5219\u7b2c%s\u884c\uff1a\u9002\u7528\u6761\u4ef6\u540c\u65f6\u4f7f\u7528\u4e86\u201c\u4ea4\u6613\u5bf9\u65b9\u662f\u5426\u4f9b\u5e94\u5546\u201d,\u201c\u662f\u5426\u5185\u90e8\u5ba2\u5546\u201d\u591a\u4e2a\u51fd\u6570\uff0c\u5b58\u5728\u51b2\u7a81\u3002\u8bf7\u6839\u636e\u5b9e\u9645\u60c5\u51b5\uff0c\u4f7f\u7528\u5176\u4e2d\u4e00\u4e2a\u51fd\u6570\u3002", (String)"RecPayRuleSaveValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
                        return;
                    }
                    if (CasHelper.isNotEmpty((Object)payer) && isCustomer) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5165\u8d26\u89c4\u5219\u7b2c%s\u884c\uff1a\u9002\u7528\u6761\u4ef6\u4f7f\u7528\u4e86\u201c\u4ea4\u6613\u5bf9\u65b9\u662f\u5426\u5ba2\u6237\u201d\u51fd\u6570\uff0c\u53c8\u540c\u65f6\u6307\u5b9a\u201c\u4ed8\u6b3e\u4eba\u201d\uff0c\u5b58\u5728\u51b2\u7a81\u3002\u8bf7\u6839\u636e\u5b9e\u9645\u60c5\u51b5\uff0c\u4f7f\u7528\u51fd\u6570\u83b7\u53d6\u4ed8\u6b3e\u4eba\uff0c\u6216\u6307\u5b9a\u5177\u4f53\u7684\u4ed8\u6b3e\u4eba\u3002", (String)"RecPayRuleSaveValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
                        return;
                    }
                    if (CasHelper.isNotEmpty((Object)payer) && isSupplier) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5165\u8d26\u89c4\u5219\u7b2c%s\u884c\uff1a\u9002\u7528\u6761\u4ef6\u4f7f\u7528\u4e86\u201c\u4ea4\u6613\u5bf9\u65b9\u662f\u5426\u4f9b\u5e94\u5546\u201d\u51fd\u6570\uff0c\u53c8\u540c\u65f6\u6307\u5b9a\u201c\u4ed8\u6b3e\u4eba\u201d\uff0c\u5b58\u5728\u51b2\u7a81\u3002\u8bf7\u6839\u636e\u5b9e\u9645\u60c5\u51b5\uff0c\u4f7f\u7528\u51fd\u6570\u83b7\u53d6\u4ed8\u6b3e\u4eba\uff0c\u6216\u6307\u5b9a\u5177\u4f53\u7684\u4ed8\u6b3e\u4eba\u3002", (String)"RecPayRuleSaveValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
                        return;
                    }
                }
                if (CasHelper.isNotEmpty((Object)handlescheme) && ("rec".equals(biztype) || "recticket".equals(biztype) || "pay".equals(biztype)) && (handlescheme.equals("recv") || handlescheme.equals("ticket") || handlescheme.equals("pay"))) {
                    String savenotifiTag = entry.getString("e_savenotifi_TAG");
                    String savenotifi = entry.getString("e_notifische");
                    if (CasHelper.isEmpty((Object)savenotifi) || CasHelper.isEmpty((Object)savenotifiTag)) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5165\u8d26\u89c4\u5219\u7b2c%s\u884c\uff0c\u5f53\u5904\u7406\u65b9\u6848\u4e3a\u6536\u6b3e\u8ba4\u9886\u3001\u4ed8\u6b3e\u8ba4\u9886\u65f6\uff0c\u901a\u77e5\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RecPayRuleSaveValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
                    }
                }
                if ("rec".equals(biztype) || "recticket".equals(biztype)) {
                    handleBill = entry.getString("e_handlebill");
                    String e_receivingtypestr = entry.getString("e_receivingtypestr");
                    String e_payertypestr = entry.getString("e_payertypestr");
                    boolean bl = flag = "upbill".equals(handleBill) || "downbill".equals(handleBill);
                    if ("rule".equals(handlescheme) && !flag && (CasHelper.isEmpty((Object)e_receivingtypestr) || CasHelper.isEmpty((Object)e_payertypestr))) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5165\u8d26\u89c4\u5219\u7b2c%s\u884c\uff0c\u6536\u6b3e\u7c7b\u578b\u6216\u8005\u4ed8\u6b3e\u4eba\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RecPayRuleSaveValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
                    }
                }
                if (!"pay".equals(biztype)) continue;
                handleBill = entry.getString("e_handlebill");
                String e_paymenttypestr = entry.getString("e_paymenttypestr");
                String e_payeetypestr = entry.getString("e_payeetypestr");
                boolean bl = flag = "upbill".equals(handleBill) || "downbill".equals(handleBill);
                if ("pay".equals(handlescheme) || flag || !CasHelper.isEmpty((Object)e_paymenttypestr) && !CasHelper.isEmpty((Object)e_payeetypestr)) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5165\u8d26\u89c4\u5219\u7b2c%s\u884c\uff0c\u4ed8\u6b3e\u7c7b\u578b\u6216\u8005\u6536\u6b3e\u4eba\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RecPayRuleSaveValidator_9", (String)"fi-cas-opplugin", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
            }
        }
    }
}

