/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.smartmatch;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.MatchBizTypeEnum;
import kd.fi.cas.util.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class SmartMatchEnableValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject recPayRule = dataEntity.getDataEntity();
            String biztype = recPayRule.getString("biztype");
            String direction = recPayRule.getString("direction");
            String bizCondition = recPayRule.getString("bizcondition");
            String bizDateProp = recPayRule.getString("bizdateprop");
            String entryBizDateProp = recPayRule.getString("entrybizdateprop");
            Date enableDate = recPayRule.getDate("enabledate");
            DynamicObjectCollection orgEntrys = recPayRule.getDynamicObjectCollection("org_entry");
            HashSet<DynamicObject> orgSet = new HashSet<DynamicObject>();
            for (DynamicObject orgEntry : orgEntrys) {
                orgSet.add(orgEntry.getDynamicObject("u_org"));
            }
            QFilter biztypeQf = new QFilter("biztype", "=", (Object)biztype);
            biztypeQf.and(new QFilter("enable", "=", (Object)"1"));
            QFilter idQf = new QFilter("id", "!=", recPayRule.getPkValue());
            DynamicObject[] recpayrules = BusinessDataServiceHelper.load((String)"cas_smartmatch", (String)"id,number,direction,bizcondition,bizdateprop,entrybizdateprop,enabledate,org_entry,org_entry.u_org", (QFilter[])new QFilter[]{idQf, biztypeQf});
            Boolean isExist = false;
            HashMap<Object, HashSet<String>> orgToBillNo = new HashMap<Object, HashSet<String>>();
            if (orgSet.size() > 0) {
                Set orgCollect = Arrays.stream(recpayrules).map(rec -> rec.getDynamicObjectCollection("org_entry")).flatMap(Collection::stream).map(o -> o.getDynamicObject("u_org").getPkValue()).collect(Collectors.toSet());
                for (DynamicObject recpayrule : recpayrules) {
                    DynamicObjectCollection dynamicObjectCollection = recpayrule.getDynamicObjectCollection("org_entry");
                    for (DynamicObject dynamicObject : dynamicObjectCollection) {
                        DynamicObject u_org = dynamicObject.getDynamicObject("u_org");
                        if (u_org == null) continue;
                        HashSet<String> setBillNo = (HashSet<String>)orgToBillNo.get(u_org.getPkValue());
                        if (setBillNo == null) {
                            setBillNo = new HashSet<String>();
                        }
                        setBillNo.add(recpayrule.getString("number"));
                        orgToBillNo.put(u_org.getPkValue(), setBillNo);
                    }
                }
                for (DynamicObject org : orgSet) {
                    if (!orgCollect.contains(org.getPkValue())) continue;
                    isExist = true;
                    break;
                }
            } else {
                for (DynamicObject recpayrule : recpayrules) {
                    DynamicObjectCollection dynamicObjectCollection = recpayrule.getDynamicObjectCollection("org_entry");
                    if (dynamicObjectCollection.size() != 0) continue;
                    isExist = true;
                    break;
                }
            }
            if (!isExist.booleanValue()) continue;
            String billNo = "";
            boolean isNotSame = false;
            DynamicObject orgExits = null;
            for (DynamicObject recpayrule : recpayrules) {
                boolean isExsitOrg = false;
                DynamicObjectCollection dynamicObjectCollection = recpayrule.getDynamicObjectCollection("org_entry");
                if (orgSet.size() > 0) {
                    Set orgCollect = dynamicObjectCollection.stream().map(o -> o.getDynamicObject("u_org").getPkValue()).collect(Collectors.toSet());
                    for (DynamicObject org : orgSet) {
                        if (org == null || !orgCollect.contains(org.getPkValue())) continue;
                        orgExits = org;
                        isExsitOrg = true;
                    }
                } else if (dynamicObjectCollection.size() == 0) {
                    isExsitOrg = true;
                }
                if (!isExsitOrg) continue;
                billNo = recpayrule.getString("number");
                String oldDirection = recpayrule.getString("direction");
                if (oldDirection.equals(direction)) {
                    String directionStr;
                    String bizTypeStr = null;
                    bizTypeStr = MatchBizTypeEnum.REC.getValue().equals(biztype) ? ResManager.loadKDString((String)"\u6536\u6b3e", (String)"SmartMatchSaveValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]) : (MatchBizTypeEnum.PAY.getValue().equals(biztype) ? ResManager.loadKDString((String)"\u4ed8\u6b3e", (String)"SmartMatchSaveValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]) : (MatchBizTypeEnum.AGENTPAY.getValue().equals(biztype) ? ResManager.loadKDString((String)"\u4ee3\u53d1", (String)"SmartMatchSaveValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]) : (MatchBizTypeEnum.TRANSUP.getValue().equals(biztype) ? ResManager.loadKDString((String)"\u4e0a\u5212", (String)"SmartMatchSaveValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]) : (MatchBizTypeEnum.TRANSDOWN.getValue().equals(biztype) ? ResManager.loadKDString((String)"\u4e0b\u62e8", (String)"SmartMatchSaveValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]) : MatchBizTypeEnum.getName((String)biztype)))));
                    String string = directionStr = MatchBizTypeEnum.REC.getValue().equals(direction) ? ResManager.loadKDString((String)"\u6536\u6b3e", (String)"SmartMatchSaveValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e", (String)"SmartMatchSaveValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    if (orgExits != null) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u5df2\u7ecf\u5b58\u5728\u6d41\u6c34\u65b9\u5411\u4e3a\u201c%2$s\u201d\u3001\u4e1a\u52a1\u7c7b\u578b\u4e3a\u201c%3$s\u201d\u7684\u201c\u53ef\u7528\u201d\u5339\u914d\u89c4\u5219\uff08\u5355\u636e\u7f16\u53f7\u201c%4$s\u201d\uff09\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SmartMatchSaveValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), orgExits.getString("name"), directionStr, bizTypeStr, billNo), ErrorLevel.Error);
                    } else {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u6d41\u6c34\u65b9\u5411\u4e3a\u201c%1$s\u201d\u3001\u4e1a\u52a1\u7c7b\u578b\u4e3a\u201c%2$s\u201d\u7684\u201c\u9002\u7528\u5168\u7ec4\u7ec7\u201d\u7684\u5339\u914d\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SmartMatchSaveValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), directionStr, bizTypeStr), ErrorLevel.Error);
                    }
                    return;
                }
                String oldBizCondition = recpayrule.getString("bizcondition");
                String oldBizDateProp = recpayrule.getString("bizdateprop");
                String oldEntryBizDateProp = recpayrule.getString("entrybizdateprop");
                Date oldEnableDate = recpayrule.getDate("enabledate");
                if (!StringUtils.equals((CharSequence)(null != oldBizCondition ? oldBizCondition.trim() : ""), (CharSequence)(null != bizCondition ? bizCondition.trim() : ""))) {
                    isNotSame = true;
                    break;
                }
                if (!StringUtils.equals((CharSequence)(null != oldBizDateProp ? oldBizDateProp.trim() : ""), (CharSequence)(null != bizDateProp ? bizDateProp.trim() : ""))) {
                    isNotSame = true;
                    break;
                }
                if (!StringUtils.equals((CharSequence)(null != oldEntryBizDateProp ? oldEntryBizDateProp.trim() : ""), (CharSequence)(null != entryBizDateProp ? entryBizDateProp.trim() : ""))) {
                    isNotSame = true;
                    break;
                }
                if (null == oldEnableDate && null == enableDate || DateUtils.isSameDay((Date)oldEnableDate, (Date)enableDate)) continue;
                isNotSame = true;
                break;
            }
            if (!isNotSame) continue;
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5f53\u524d\u5339\u914d\u8303\u56f4\u8bbe\u7f6e\u4e0e\u201c%s\u201d\u5339\u914d\u89c4\u5219\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fdd\u8bc1\u540c\u4e00\u7ec4\u7ec7\u540c\u4e00\u5339\u914d\u4e1a\u52a1\u5355\u636e\uff0c\u5339\u914d\u8303\u56f4\u5b8c\u5168\u4e00\u81f4\u3002", (String)"SmartMatchEnableValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), billNo));
        }
    }
}

