/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.transferapply;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.enums.BankAcctStatusEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.util.EmptyUtil;

public class TransferApplyAuditValidator
extends AbstractValidator {
    private static final String SYSTEM_TYPE = "fi-cas-opplugin";

    public Set<String> preparePropertys() {
        Set selectors = super.preparePropertys();
        selectors.add("cas_transferapply_entry.e_payeraccbank");
        selectors.add("cas_transferapply_entry.e_payeeaccbank");
        selectors.add("cas_transferapply_entry.e_paymentchannel");
        selectors.add("cas_transferapply_entry.e_settlementtype");
        return selectors;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObjectCollection payEntries = dynamicObject.getDynamicObjectCollection("cas_transferapply_entry");
            for (DynamicObject payEntry : payEntries) {
                DynamicObject payerAcc = payEntry.getDynamicObject("e_payeraccbank");
                DynamicObject payeeAcc = payEntry.getDynamicObject("e_payeeaccbank");
                String paymentChannel = payEntry.getString("e_paymentchannel");
                DynamicObject settlementType = payEntry.getDynamicObject("e_settlementtype");
                this.validateAccountStatus(dataEntity, payerAcc, payeeAcc);
                this.validatePaymentChannel(dataEntity, payerAcc, settlementType, paymentChannel);
            }
        }
    }

    private void validateAccountStatus(ExtendedDataEntity dataEntity, DynamicObject payerAcc, DynamicObject payeeAcc) {
        if (!EmptyUtil.isEmpty((DynamicObject)payerAcc)) {
            String payerAcctStatus = payerAcc.getString("acctstatus");
            String payerAccountNumber = payerAcc.getString("bankaccountnumber");
            if (BankAcctStatusEnum.CLOSED.getValue().equals(payerAcctStatus)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AccountBankValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), payerAccountNumber));
            } else if (BankAcctStatusEnum.FREEZE.getValue().equals(payerAcctStatus)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u51bb\u7ed3\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AccountBankValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), payerAccountNumber));
            }
        }
        if (!EmptyUtil.isEmpty((DynamicObject)payeeAcc)) {
            String payeeAcctStatus = payeeAcc.getString("acctstatus");
            String payeeAccountNumber = payeeAcc.getString("bankaccountnumber");
            if (BankAcctStatusEnum.CLOSED.getValue().equals(payeeAcctStatus)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AccountBankValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), payeeAccountNumber));
            }
        } else {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountBankValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    public void validatePaymentChannel(ExtendedDataEntity dataEntity, DynamicObject payerAccBank, DynamicObject settlementType, String paymentChannel) {
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)paymentChannel) && payerAccBank != null) {
            Set paymentChannels;
            String paymentChannelRange;
            if (PaymentChannelEnum.ONLINEBANK.getValue().equals(paymentChannel) && !payerAccBank.getBoolean("isopenbank")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u7f51\u4e0a\u94f6\u884c\u3002", (String)"AccountBankValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            if (PaymentChannelEnum.BEI.getValue().equals(paymentChannel) && !payerAccBank.getBoolean("issetbankinterface")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u94f6\u4f01\u63a5\u53e3\u3002", (String)"AccountBankValidator_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            if (settlementType != null && StringUtils.isNotEmpty((CharSequence)(paymentChannelRange = settlementType.getString("paymentchannel"))) && !(paymentChannels = Arrays.stream(paymentChannelRange.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toSet())).contains(paymentChannel)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053\u5fc5\u987b\u662f\u7ed3\u7b97\u65b9\u5f0f\u9650\u5b9a\u8303\u56f4\u5185\u3002", (String)"TransferApplyEntryValidator_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        }
    }
}

