/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.transferapply;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.enums.BankAcctStatusEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.util.EmptyUtil;

public class TransferApplyEntryValidator
extends AbstractValidator {
    private static final String SYSTEM_TYPE = "fi-cas-opplugin";

    public Set<String> preparePropertys() {
        Set selectors = super.preparePropertys();
        selectors.add("cas_transferapply_entry.e_payeraccbank");
        selectors.add("cas_transferapply_entry.e_paymentchannel");
        selectors.add("cas_transferapply_entry.e_payeeaccbankid");
        selectors.add("cas_transferapply_entry.e_payeeaccbank");
        selectors.add("cas_transferapply_entry.e_payorg");
        selectors.add("cas_transferapply_entry.e_payee");
        selectors.add("cas_transferapply_entry.e_usage");
        selectors.add("cas_transferapply_entry.e_paymentchannel");
        selectors.add("cas_transferapply_entry.e_settlementtype");
        return selectors;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObjectCollection payEntries = dynamicObject.getDynamicObjectCollection("cas_transferapply_entry");
            if (payEntries.isEmpty()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8c03\u62e8\u660e\u7ec6\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransferApplyEntryValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            boolean isCrossPay = dynamicObject.getBoolean("iscrosspay");
            for (DynamicObject payEntry : payEntries) {
                Set paymentChannels;
                String paymentChannelRange;
                DynamicObject settlementType;
                String paymentChannel;
                DynamicObject payerAcc = payEntry.getDynamicObject("e_payeraccbank");
                DynamicObject payeeAcc = (DynamicObject)payEntry.get("e_payeeaccbank");
                if (isCrossPay && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)payEntry.getString("e_payeebankname"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransferApplyEntryValidator_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if (payerAcc == null && payeeAcc == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7\u548c\u6536\u6b3e\u8d26\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"TransferApplyEntryValidator_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    continue;
                }
                if (payerAcc == null) continue;
                this.validateAccountStatus(dataEntity, payerAcc, payeeAcc);
                Long payAccId = payerAcc.getLong("id");
                if (payeeAcc != null && Objects.equals(payeeAcc.getString("number"), payerAcc.getString("number"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u540d\u8f6c\u8d26\u4e0d\u652f\u6301\u540c\u4e00\u94f6\u884c\u8d26\u53f7\u4e4b\u95f4\u7684\u8f6c\u8d26\u3002", (String)"TransferApplyEntryValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                Long payOrg = null;
                String payOrgName = "";
                if (payEntry.get("e_payorg") != null) {
                    payOrg = ((DynamicObject)payEntry.get("e_payorg")).getLong("id");
                    payOrgName = ((DynamicObject)payEntry.get("e_payorg")).getString("name");
                }
                if (payOrg != null && payAccId != null && !AccountBankHelper.canUseAccount((long)payOrg, (long)payAccId)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7ec4\u7ec7\u201c%s\u201d\u65e0\u5bf9\u5e94\u4ed8\u6b3e\u8d26\u6237\u4f7f\u7528\u6743\u9650\u3002", (String)"TransferApplyEntryValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), payOrgName));
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(paymentChannel = (String)payEntry.get("e_paymentchannel")))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountBankValidator_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    continue;
                }
                if ("bei".equals(paymentChannel) && EmptyUtil.isEmpty((Object)payEntry.get("e_usage"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\u65f6\uff0c\u8f6c\u8d26\u9644\u8a00\u5fc5\u5f55\u3002", (String)"TransferApplyEntryValidator_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if (PaymentChannelEnum.ONLINEBANK.getValue().equals(paymentChannel) && !payerAcc.getBoolean("isopenbank")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u7f51\u4e0a\u94f6\u884c\u3002", (String)"TransferApplyEntryValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if (PaymentChannelEnum.BEI.getValue().equals(paymentChannel) && !payerAcc.getBoolean("issetbankinterface")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u94f6\u4f01\u63a5\u53e3\u3002", (String)"TransferApplyEntryValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if ((settlementType = payEntry.getDynamicObject("e_settlementtype")) == null || !StringUtils.isNotEmpty((CharSequence)(paymentChannelRange = settlementType.getString("paymentchannel"))) || (paymentChannels = Arrays.stream(paymentChannelRange.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toSet())).contains(paymentChannel)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053\u5fc5\u987b\u662f\u7ed3\u7b97\u65b9\u5f0f\u9650\u5b9a\u8303\u56f4\u5185\u3002", (String)"TransferApplyEntryValidator_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        }
    }

    private void validateAccountStatus(ExtendedDataEntity dataEntity, DynamicObject payerAcc, DynamicObject payeeAcc) {
        if (!EmptyUtil.isEmpty((DynamicObject)payerAcc)) {
            String payerAcctStatus = payerAcc.getString("acctstatus");
            String payerAccountNumber = payerAcc.getString("bankaccountnumber");
            if (BankAcctStatusEnum.CLOSED.getValue().equals(payerAcctStatus)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AccountBankValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), payerAccountNumber));
            } else if (BankAcctStatusEnum.FREEZE.getValue().equals(payerAcctStatus)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u51bb\u7ed3\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AccountBankValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), payerAccountNumber));
            }
        }
        if (!EmptyUtil.isEmpty((DynamicObject)payeeAcc)) {
            String payeeAcctStatus = payeeAcc.getString("acctstatus");
            String payeeAccountNumber = payeeAcc.getString("bankaccountnumber");
            if (BankAcctStatusEnum.CLOSED.getValue().equals(payeeAcctStatus)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AccountBankValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), payeeAccountNumber));
            }
        }
    }
}

