/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.mservice.digit;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.fi.cas.mservice.digit.IDigitEmployeeSkillHandler;
import kd.fi.cas.mservice.digit.handler.bankstatement.AccumulateDealBankStatementHandler;
import kd.fi.cas.mservice.digit.handler.matchorders.AccumulateDealMatchOrdersHandler;
import kd.fi.cas.mservice.digit.handler.payrecv.AccumulateDealRecPayEntryHandler;
import kd.fi.cas.mservice.digit.handler.suborders.AccumulateDealSubOrdersHandler;

public class DigitEmployeeInstanceFactory {
    private static final Map<String, IDigitEmployeeSkillHandler> SKILL_HANDLER_MAP;

    public static IDigitEmployeeSkillHandler getInstance(String skillNumber) {
        return SKILL_HANDLER_MAP.get(skillNumber);
    }

    static {
        HashMap<String, IDigitEmployeeSkillHandler> skillHandlerMap = new HashMap<String, IDigitEmployeeSkillHandler>(16);
        skillHandlerMap.put("znsf", new AccumulateDealRecPayEntryHandler());
        skillHandlerMap.put("znfd", new AccumulateDealSubOrdersHandler());
        skillHandlerMap.put("pdjqr", new AccumulateDealMatchOrdersHandler());
        skillHandlerMap.put("dzjqr", new AccumulateDealBankStatementHandler());
        SKILL_HANDLER_MAP = Collections.unmodifiableMap(skillHandlerMap);
    }
}

