/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.mservice.digit.handler.payrecv;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.mservice.digit.ICombineDataProcessHandler;
import kd.fi.cas.mservice.digit.helper.BankAcctHelper;

public class LastMonthReceiptEntryProcessHandler
implements ICombineDataProcessHandler {
    @Override
    public List<Map<String, String>> combineData() {
        Tuple<Date, Date> lastMonthDateRange = this.getLastMonthDateRange();
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>(3);
        QFilter qFilter = new QFilter("receredtype", "=", (Object)"3").and(new QFilter("creditamount", "!=", (Object)0)).and(new QFilter("bizdate", ">=", lastMonthDateRange.item1)).and(new QFilter("bizdate", "<", lastMonthDateRange.item2)).and(new QFilter("accountbank", "not in", BankAcctHelper.getVirtAcctIds()));
        DynamicObject[] interrecs1 = BusinessDataServiceHelper.load((String)"bei_intelrec", (String)"id", (QFilter[])new QFilter[]{qFilter});
        int lastRecEntryCount = interrecs1 != null ? interrecs1.length : 0;
        data.add(this.buildData(ResManager.loadKDString((String)"\u4e0a\u6708\u6536\u6b3e\u5165\u8d26\u4e2d\u5fc3\u6d41\u6c34\u603b\u6570", (String)"LastMonthReceiptEntryHandler_1", (String)"fi-cas-mservice", (Object[])new Object[0]), String.valueOf(lastRecEntryCount), "syskrzzxlszs", true));
        HashSet<String> receredWays = new HashSet<String>(3);
        receredWays.add("rule");
        receredWays.add("automatch");
        receredWays.add("beipay");
        qFilter.and(new QFilter("receredway", "in", receredWays));
        DynamicObject[] interrecs2 = BusinessDataServiceHelper.load((String)"bei_intelrec", (String)"id", (QFilter[])new QFilter[]{qFilter});
        int autoLastRecEntryCount = interrecs2 != null ? interrecs2.length : 0;
        data.add(this.buildData(ResManager.loadKDString((String)"\u4e0a\u6708\u667a\u80fd\u6536\u6b3e\u6d41\u6c34\u5165\u8d26\u603b\u6570", (String)"LastMonthReceiptEntryHandler_2", (String)"fi-cas-mservice", (Object[])new Object[0]), String.valueOf(autoLastRecEntryCount), "syznsklsrzzs", true));
        int percent = (int)Math.ceil((float)autoLastRecEntryCount * 1.0f / (float)lastRecEntryCount * 100.0f);
        data.add(this.buildData(ResManager.loadKDString((String)"\u4e0a\u6708\u667a\u80fd\u6536\u6b3e\u6d41\u6c34\u5165\u8d26\u5360\u6bd4", (String)"LastMonthReceiptEntryHandler_3", (String)"fi-cas-mservice", (Object[])new Object[0]), String.valueOf(percent), "syznsklsrzzb", false));
        return data;
    }
}

