/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.bill.consumer;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.dhc.enums.BillOperationEnum;
import kd.fi.dhc.enums.DataSynTypeEnum;
import kd.fi.dhc.executor.DataSynchronizationExecutor;
import kd.fi.dhc.service.SynDataExceptionService;

public class DataSynchronizationConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(DataSynchronizationConsumer.class);

    public void onMessage(Object msg, String msgId, boolean isResend, MessageAcker messageAcker) {
        log.debug("\u6210\u529f\u8fdb\u5165\u4eba\u4eba\u62a5\u8d26\u6570\u636e\u540c\u6b65\u6d88\u8d39\u8005\u5b9e\u73b0\u7c7b:" + this.getClass().getName() + "\uff0cmq\u4f20\u5165\u6d88\u606f: " + msg + ", msgId: " + msgId + ", is resend: " + isResend);
        if (StringUtils.isEmpty((String)msg.toString())) {
            log.debug("\u6d88\u606f\u961f\u5217\u4e2d message \u4e3a\u7a7a,\u4e0d\u7528\u6d88\u8d39");
            messageAcker.ack(msgId);
            return;
        }
        Map dataMap = (Map)msg;
        String operation = (String)dataMap.get("operation");
        String entityNumber = (String)dataMap.get("formMetaId");
        List ids = (List)dataMap.get("ids");
        if (BillOperationEnum.DELETE.getValue().equals(operation)) {
            try {
                this.deleteData(entityNumber, ids);
            }
            catch (Throwable th) {
                log.error("\u5220\u9664\u6211\u7684\u62a5\u8d26-" + entityNumber + "-\u5355\u636e\u7c7b\u578b\u6570\u636e\uff1a" + ids + "\u51fa\u73b0\u5f02\u5e38" + th.getMessage(), th);
                this.recordErrorException(entityNumber, ids, operation, th, msg);
            }
            messageAcker.ack(msgId);
        } else if (BillOperationEnum.UPDATE_STATUS.getValue().equals(operation)) {
            try {
                DataSynchronizationExecutor executor = new DataSynchronizationExecutor(entityNumber, new HashSet<Object>(ids), DataSynTypeEnum.SYN_STATUS);
                executor.execute();
            }
            catch (Throwable th) {
                log.error("\u5904\u7406\u5355\u636e\u6570\u636e[" + entityNumber + '-' + ids + '-' + operation + "]\u5b58\u5165\u6211\u7684\u62a5\u8d26\u5f02\u5e38\uff0c" + th.getMessage(), th);
                this.recordErrorException(entityNumber, ids, operation, th, msg);
            }
            messageAcker.ack(msgId);
        } else if (BillOperationEnum.SAVE_OR_UPDATE.getValue().equals(operation)) {
            try {
                DataSynchronizationExecutor executor = new DataSynchronizationExecutor(entityNumber, new HashSet<Object>(ids), DataSynTypeEnum.SYN_DATA);
                executor.execute();
            }
            catch (Throwable th) {
                log.error("\u5904\u7406\u5355\u636e\u6570\u636e[" + entityNumber + '-' + ids + '-' + operation + "]\u5b58\u5165\u6211\u7684\u62a5\u8d26\u5f02\u5e38\uff0c" + th.getMessage(), th);
                this.recordErrorException(entityNumber, ids, operation, th, msg);
            }
            messageAcker.ack(msgId);
        } else {
            messageAcker.discard(msgId);
        }
    }

    private void deleteData(String entityNumber, List<Object> ids) {
        QFilter billIdFilter = new QFilter("billid", "in", ids);
        QFilter formMetaIdFilter = new QFilter("billnew.id", "=", (Object)entityNumber);
        DeleteServiceHelper.delete((String)"dhc_mybilllist", (QFilter[])new QFilter[]{billIdFilter, formMetaIdFilter});
    }

    private void recordErrorException(String entityNumber, List<Object> ids, String operation, Throwable e, Object mqMsg) {
        List<Long> pkIds = ids.stream().map(i -> Long.parseLong(i.toString())).collect(Collectors.toList());
        String errorMsg = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u6d88\u8d39\u7c7b\u201c%s\u201d\u51fa\u73b0\u5f02\u5e38\u3002", (String)"DataSynchronizationConsumer_0", (String)"fi-dhc-common", (Object[])new Object[0]), operation);
        SynDataExceptionService exService = new SynDataExceptionService();
        exService.saveException(entityNumber, "DataSynchronizationConsumer", "onMessage", e, errorMsg, SerializationUtils.toJsonString((Object)mqMsg), true, pkIds);
    }
}

