/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.bill.consumer;

import java.util.Collections;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.image.dto.ImageStatusSynMessage;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.dhc.service.SynImageExceptionService;

public class ImageStatusSynchronizationConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(ImageStatusSynchronizationConsumer.class);
    private static final String IMAGE_UPLOADING = "1";
    private static final String IMAGE_ABANDON = "5";

    public void onMessage(Object msg, String msgId, boolean isResend, MessageAcker messageAcker) {
        log.info("\u6210\u529f\u8fdb\u5165\u5f71\u50cf\u72b6\u6001\u540c\u6b65\u6d88\u8d39\u8005\u5b9e\u73b0\u7c7b:" + this.getClass().getName() + "\uff0cmq\u4f20\u5165\u6d88\u606f: " + msg + ", msgId: " + msgId + ", is resend: " + isResend);
        if (msg == null || StringUtils.isEmpty((String)msg.toString())) {
            log.info("\u6d88\u606f\u961f\u5217\u4e2d message \u4e3a\u7a7a,\u4e0d\u7528\u6d88\u8d39");
            messageAcker.ack(msgId);
            return;
        }
        if (!(msg instanceof ImageStatusSynMessage)) {
            log.error("\u6d88\u606f\u961f\u5217\u4e2d message \u7c7b\u578b\u4e0d\u5339\u914d: " + ImageStatusSynMessage.class.getName() + " msgId: " + msgId);
            messageAcker.ack(msgId);
            return;
        }
        ImageStatusSynMessage message = (ImageStatusSynMessage)msg;
        String billId = message.getBillId();
        String imageStatus = message.getImageState();
        try {
            this.updateImageStatus(billId, imageStatus);
        }
        catch (Exception e) {
            log.error("\u4eba\u4eba\u62a5\u8d26\u5355\u636e\u5f71\u50cf\u72b6\u6001\u540c\u6b65\u51fa\u9519 msgId: " + msgId, (Throwable)e);
            String exceptionMsg = ResManager.loadKDString((String)"\u5f71\u50cf\u72b6\u6001\u6d88\u8d39\u7c7b\u540c\u6b65\u5f02\u5e38\u3002", (String)"ImageStatusSynchronizationConsumer_0", (String)"fi-dhc-common", (Object[])new Object[0]);
            SynImageExceptionService exService = new SynImageExceptionService();
            exService.saveException(message.getBillType(), "ImageStatusSynchronizationConsumer", "onMessage", e, exceptionMsg, SerializationUtils.toJsonString((Object)msg), true, Collections.singletonList(Long.valueOf(billId)));
        }
        messageAcker.ack(msgId);
    }

    public void updateImageStatus(String billId, String imageStatus) {
        if (StringUtils.isEmpty((String)billId) || StringUtils.isEmpty((String)imageStatus)) {
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("billid", "=", (Object)Long.valueOf(billId))};
        if (QueryServiceHelper.exists((String)"dhc_mybilllist", (QFilter[])qFilters)) {
            QFilter[] qFilters1 = new QFilter[]{new QFilter("billid", "=", (Object)billId)};
            DynamicObject imageStatusInfo = QueryServiceHelper.queryOne((String)"task_billimagemap", (String)"imagestate", (QFilter[])qFilters1);
            if (imageStatusInfo != null) {
                String state;
                Object imageState = imageStatusInfo.get("imagestate");
                if (imageState instanceof String && !IMAGE_UPLOADING.equals(state = (String)imageState) && !IMAGE_ABANDON.equals(state)) {
                    DynamicObject[] datas;
                    for (DynamicObject data : datas = BusinessDataServiceHelper.load((String)"dhc_mybilllist", (String)"imagestatus,imageupdatetime", (QFilter[])qFilters)) {
                        data.set("imagestatus", (Object)state);
                        data.set("imageupdatetime", (Object)new Date());
                    }
                    SaveServiceHelper.save((DynamicObject[])datas);
                    log.warn("\u6d88\u606f\u88ab\u6210\u529f\u6d88\u8d39\uff0c\u5f71\u50cf\u72b6\u6001\u5df2\u7ecf\u66f4\u65b0\u3002[\u5355\u636eid\uff0c\u5f71\u50cf\u72b6\u6001]\uff1a[" + billId + "," + state + "]");
                }
            } else {
                DynamicObject[] datas;
                log.info("\u5f71\u50cf\u6620\u5c04\u8868\u6570\u636e\u67e5\u8be2\u4e3a\u7a7a\uff0c\u66f4\u6539\u5f71\u50cf\u72b6\u6001\u4e3a: {}", (Object)imageStatus);
                for (DynamicObject data : datas = BusinessDataServiceHelper.load((String)"dhc_mybilllist", (String)"imagestatus,imageupdatetime", (QFilter[])qFilters)) {
                    data.set("imagestatus", (Object)imageStatus);
                    data.set("imageupdatetime", (Object)new Date());
                }
                SaveServiceHelper.save((DynamicObject[])datas);
                log.warn("\u6d88\u606f\u88ab\u6210\u529f\u6d88\u8d39\uff0c\u5f71\u50cf\u72b6\u6001\u5df2\u7ecf\u66f4\u65b0\u3002[\u5355\u636eid\uff0c\u5f71\u50cf\u72b6\u6001]\uff1a[" + billId + "," + imageStatus + "]");
            }
        }
    }
}

