/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.business.scheme.dao.PrintConditionDao;
import kd.bos.print.business.scheme.entity.ComplexSettingItem;
import kd.bos.print.core.service.IUserService;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.service.ITimeService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.bos.template.orgctrl.service.PrintTemplateServiceFactory;
import kd.bos.template.orgctrl.utils.ParamUtils;
import kd.bos.url.UrlService;
import kd.fi.dhc.mircoservice.pojo.dto.mybillprint.PrintSettingInfo;
import kd.fi.dhc.mircoservice.pojo.dto.mybillprint.PrintTplInfo;

public class BillPrintServiceHelper {
    public static final String F_TEMPLATE_ID = "templateid";
    public static final String F_TEMPLATE_NUMBER = "templatenumber";

    public static String printPreview(String pageId, String formId, String templateFormId, Object[] pks) {
        return PrintServiceHelper.createPdfUrl((String)pageId, (String)formId, (String)templateFormId, (Object[])pks);
    }

    public static void onlyOnePrint(DynamicObject[] dynamicObjects, IFormView view) {
        DynamicObject dy = dynamicObjects[0];
        String formId = dy.getString("billnew.id");
        PrintSettingInfo printSettingInfo = BillPrintServiceHelper.getTplSettingInfo(formId);
        ArrayList<String> noTplIds = new ArrayList<String>(8);
        long billId = dy.getLong("billid");
        String billNo = dy.getString("billno");
        List<PrintTplInfo> tpl = BillPrintServiceHelper.getTpl(view, formId, billId, new HashSet<Long>(Collections.singletonList(billId)), true);
        if (CollectionUtils.isEmpty(tpl)) {
            noTplIds.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u6253\u5370\u6a21\u677f\u4e0d\u5b58\u5728\u3002", (String)"MyBillPrintingProcess_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]), billNo));
            BillPrintServiceHelper.showPrintResult(noTplIds, view);
            return;
        }
        if (tpl.size() > 1) {
            BillPrintServiceHelper.showPrintSelect(formId, view, billId);
            return;
        }
        PrintTplInfo tplInfo = tpl.get(0);
        String pdfURL = BillPrintServiceHelper.getPrintPreviewURL(printSettingInfo, tplInfo, formId, Collections.singletonList(billId), view);
        if (StringUtils.isBlank((CharSequence)pdfURL)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6253\u5370\u9884\u89c8\u5931\u8d25\u3002", (String)"MyBillListPlugin_11", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        view.showSuccessNotification(ResManager.loadKDString((String)"\u6253\u5370\u9884\u89c8\u6210\u529f\u3002", (String)"MyBillListPlugin_12", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        BillPrintServiceHelper.openForm(view, pdfURL);
    }

    public static void showPrinting(Object[] ids, IFormView view) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("dhc_printing");
        param.setCustomParam("pkIds", (Object)SerializationUtils.toJsonString(Arrays.asList(ids)));
        view.showForm(param);
    }

    public static void showPrintSelect(String formId, IFormView view, long billId) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("dhc_selecttemplate");
        param.setCustomParam("formId", (Object)formId);
        param.setCustomParam("text", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5339\u914d\u591a\u4e2a\u6a21\u677f\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2a\u6a21\u677f\u6253\u5370\u3002", (String)"MyBillPrintingProcess_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        param.setCustomParam("billId", (Object)billId);
        view.showForm(param);
    }

    private static Map<String, Object> getPrintSetting(String formId) {
        String configKey = formId + "_printsetting";
        Map<String, Object> printSetting = new HashMap<String, Object>();
        long userId = RequestContext.get().getCurrUserId();
        String settingData = UserConfigServiceHelper.getSetting((long)userId, (String)configKey);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            printSetting = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        }
        return printSetting;
    }

    private static DynamicObject getEnableScheme(String formId) {
        Optional firstScheme;
        DynamicObject scheme = null;
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)formId), new QFilter("ispreference", "=", (Object)Boolean.TRUE), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        Map schemes = BusinessDataServiceHelper.loadFromCache((String)"bos_printingscheme", (QFilter[])filters);
        if (!schemes.isEmpty() && (firstScheme = schemes.values().stream().findFirst()).isPresent()) {
            scheme = (DynamicObject)firstScheme.get();
        }
        return scheme;
    }

    private static String getDefaulttplInManangeTool(String formId) {
        String tplId = "";
        QFilter[] qFilters = new QFilter[]{new QFilter("billformid", "=", (Object)formId), new QFilter("isdefault", "=", (Object)Boolean.TRUE), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DynamicObject defaultObj = QueryServiceHelper.queryOne((String)"bas_manageprinttpl", (String)"printtplid.id", (QFilter[])qFilters);
        if (defaultObj != null) {
            tplId = (String)defaultObj.get("printtplid.id");
        }
        return tplId;
    }

    private static BillEntityType getContainBillType(String billFormId) {
        return (BillEntityType)EntityMetadataCache.getDataEntityType((String)billFormId);
    }

    private static boolean isContainBillType(String billFormId) {
        BillEntityType containBillType = BillPrintServiceHelper.getContainBillType(billFormId);
        if (Objects.isNull(containBillType)) {
            return false;
        }
        return StringUtils.isNotBlank((CharSequence)containBillType.getBillType());
    }

    public static List<PrintTplInfo> getTpl(IFormView view, String formId, long billId, Set<Long> billIds, boolean isOnePrint) {
        Map<String, Object> settingTpl;
        Object arr;
        HashSet strings;
        Map<String, Object> billSettingTpl;
        ArrayList<PrintTplInfo> printTplInfos = new ArrayList<PrintTplInfo>(8);
        String tplId = "";
        String billStr = String.valueOf(billId);
        Map<String, Object> conditionTpl = BillPrintServiceHelper.getConditionTpl(view, formId, billIds, isOnePrint);
        if (!CollectionUtils.isEmpty(conditionTpl)) {
            HashSet strings2 = new HashSet(8);
            Object arr2 = conditionTpl.get(billStr);
            if (Objects.nonNull(arr2)) {
                if (arr2 instanceof ArrayList) {
                    strings2 = new HashSet((ArrayList)arr2);
                } else if (arr2 instanceof HashSet) {
                    strings2 = (HashSet)arr2;
                }
            }
            if (!CollectionUtils.isEmpty(strings2)) {
                for (String tpl : strings2) {
                    String tplNumber;
                    if (StringUtils.isBlank((CharSequence)tpl) || "null".equalsIgnoreCase(tpl) || StringUtils.isBlank((CharSequence)(tplNumber = BillPrintServiceHelper.getTplNumById(tpl)))) continue;
                    Boolean newTpl = BosPrintServiceHelper.isNewTpl((String)tplNumber);
                    PrintTplInfo printTplInfo = new PrintTplInfo(tpl, tplNumber, newTpl);
                    printTplInfo.setBillId(billId);
                    printTplInfos.add(printTplInfo);
                }
                return printTplInfos;
            }
        }
        if (StringUtils.isBlank((CharSequence)tplId) && !CollectionUtils.isEmpty(billSettingTpl = BillPrintServiceHelper.getBillSettingTpl(view, formId, billIds, isOnePrint))) {
            strings = new HashSet(8);
            arr = billSettingTpl.get(billStr);
            if (Objects.nonNull(arr)) {
                if (arr instanceof ArrayList) {
                    strings = new HashSet((ArrayList)arr);
                } else if (arr instanceof HashSet) {
                    strings = (HashSet)arr;
                }
            }
            if (!CollectionUtils.isEmpty(strings)) {
                for (String tpl : strings) {
                    String tplNumber;
                    if (StringUtils.isBlank((CharSequence)tpl) || "null".equalsIgnoreCase(tpl) || StringUtils.isBlank((CharSequence)(tplNumber = BillPrintServiceHelper.getTplNumById(tpl)))) continue;
                    Boolean newTpl = BosPrintServiceHelper.isNewTpl((String)tplNumber);
                    PrintTplInfo printTplInfo = new PrintTplInfo(tpl, tplNumber, newTpl);
                    printTplInfo.setBillId(billId);
                    printTplInfos.add(printTplInfo);
                }
                return printTplInfos;
            }
        }
        if (StringUtils.isBlank((CharSequence)tplId) && !CollectionUtils.isEmpty(settingTpl = BillPrintServiceHelper.getSettingTpl(view, formId, billIds, isOnePrint))) {
            strings = new HashSet(8);
            arr = settingTpl.get(billStr);
            if (Objects.nonNull(arr)) {
                if (arr instanceof ArrayList) {
                    strings = new HashSet((ArrayList)arr);
                } else if (arr instanceof HashSet) {
                    strings = (HashSet)arr;
                }
            }
            if (!CollectionUtils.isEmpty(strings)) {
                for (String tpl : strings) {
                    String tplNumber;
                    if (StringUtils.isBlank((CharSequence)tpl) || "null".equalsIgnoreCase(tpl) || StringUtils.isBlank((CharSequence)(tplNumber = BillPrintServiceHelper.getTplNumById(tpl)))) continue;
                    Boolean newTpl = BosPrintServiceHelper.isNewTpl((String)tplNumber);
                    PrintTplInfo printTplInfo = new PrintTplInfo(tpl, tplNumber, newTpl);
                    printTplInfo.setBillId(billId);
                    printTplInfos.add(printTplInfo);
                }
                return printTplInfos;
            }
        }
        if (StringUtils.isBlank((CharSequence)tplId)) {
            tplId = BillPrintServiceHelper.getDefaultTemplateId(view, formId, isOnePrint);
        }
        if (StringUtils.isBlank((CharSequence)tplId)) {
            tplId = BillPrintServiceHelper.getSchemeAndDefaulttpl(view, formId, isOnePrint);
        }
        if (StringUtils.isBlank((CharSequence)tplId)) {
            return printTplInfos;
        }
        String tplNumber = BillPrintServiceHelper.getTplNumById(tplId);
        if (StringUtils.isBlank((CharSequence)tplNumber)) {
            return printTplInfos;
        }
        Boolean newTpl = BosPrintServiceHelper.isNewTpl((String)tplNumber);
        PrintTplInfo printTplInfo = new PrintTplInfo(tplId, tplNumber, newTpl);
        printTplInfo.setBillId(billId);
        printTplInfos.add(printTplInfo);
        return printTplInfos;
    }

    private static String getSchemeAndDefaulttpl(IFormView view, String formId, boolean isOnePrint) {
        String cache = view.getPageCache().get("SCHEME_" + formId);
        if (!isOnePrint && StringUtils.isNotBlank((CharSequence)cache)) {
            return cache;
        }
        String dTemplateId = "";
        DynamicObject preferenceScheme = BillPrintServiceHelper.getEnableScheme(formId);
        if (preferenceScheme != null) {
            dTemplateId = preferenceScheme.get("defaulttemplate") + "";
        }
        if (StringUtils.isBlank((CharSequence)dTemplateId)) {
            dTemplateId = BillPrintServiceHelper.getDefaulttplInManangeTool(formId);
        }
        if (StringUtils.isBlank((CharSequence)dTemplateId)) {
            view.getPageCache().remove("SCHEME_" + formId);
        } else {
            view.getPageCache().put("SCHEME_" + formId, dTemplateId);
        }
        return dTemplateId;
    }

    private static String getDefaultTemplateId(IFormView view, String formId, boolean isOnePrint) {
        String cache = view.getPageCache().get("DEFAULT_" + formId);
        if (!isOnePrint && StringUtils.isNotBlank((CharSequence)cache)) {
            return cache;
        }
        String dTemplateId = "";
        Map<String, Object> printSetting = BillPrintServiceHelper.getPrintSetting(formId);
        if (!printSetting.isEmpty()) {
            String string = dTemplateId = Objects.isNull(printSetting.get(F_TEMPLATE_ID)) ? "" : printSetting.get(F_TEMPLATE_ID).toString();
        }
        if (StringUtils.isBlank((CharSequence)dTemplateId)) {
            view.getPageCache().remove("DEFAULT_" + formId);
        } else {
            view.getPageCache().put("DEFAULT_" + formId, dTemplateId);
        }
        return dTemplateId;
    }

    private static Map<String, Object> getBillSettingTpl(IFormView view, String formId, Set<Long> billIds, boolean isOnePrint) {
        HashMap<String, Object> map = new HashMap(16);
        String cache = view.getPageCache().get("BILLSETTING_" + formId);
        if (!isOnePrint && StringUtils.isNotBlank((CharSequence)cache)) {
            map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
            return map;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("billno", "=", (Object)formId);
        qFilter.and("creator", "=", (Object)currUserId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"dhc_mybillpsmapping", (QFilter[])qFilter.toArray());
        if (Objects.isNull(dynamicObject)) {
            view.getPageCache().remove("BILLSETTING_" + formId);
            return map;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        String defaultTpl = dynamicObject.getString("defaulttemplate");
        DynamicObjectCollection userSetting = dynamicObject.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)userSetting)) {
            boolean isContainBill = BillPrintServiceHelper.isContainBillType(formId);
            String billTypeFieldKey = "";
            if (isContainBill) {
                BillEntityType containBillType = BillPrintServiceHelper.getContainBillType(formId);
                billTypeFieldKey = containBillType.getBillType();
            }
            for (DynamicObject dy : userSetting) {
                boolean aBoolean = dy.getBoolean("enable");
                if (!aBoolean) continue;
                String tplId = dy.getString("filtertemplateid");
                DynamicObject selectBillType = dy.getDynamicObject("billtype");
                String filterConditionStr = dy.getString("filtercondition");
                if (StringUtils.isBlank((CharSequence)filterConditionStr)) continue;
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionStr, FilterCondition.class);
                FilterBuilder filterBuilder = new FilterBuilder(dt, filterCondition, true);
                filterBuilder.setTimeService((ITimeService)view.getService(ITimeService.class));
                filterBuilder.setUserService((kd.bos.service.IUserService)view.getService(IUserService.class));
                filterBuilder.buildFilter(true);
                String pkName = dt.getPrimaryKey().getName();
                QFilter[] filters = new QFilter[]{filterBuilder.getQFilter(), new QFilter(pkName, "in", billIds)};
                Map filterObjs = BusinessDataServiceHelper.loadFromCache((String)formId, (QFilter[])filters);
                for (Map.Entry it : filterObjs.entrySet()) {
                    Object key = it.getKey();
                    long billL = (Long)key;
                    String billStr = String.valueOf(billL);
                    DynamicObject billDy = (DynamicObject)it.getValue();
                    HashSet tplIds = new HashSet(8);
                    if (!Objects.isNull(selectBillType) && StringUtils.isNotBlank((CharSequence)billTypeFieldKey)) {
                        Long pkValue;
                        DynamicObject billType = billDy.getDynamicObject(billTypeFieldKey);
                        if (billType == null || (pkValue = (Long)billType.getPkValue()).longValue() != selectBillType.getLong("id")) continue;
                        Object strings = map.get(billStr);
                        if (Objects.nonNull(strings)) {
                            tplIds = (HashSet)strings;
                        }
                        if (StringUtils.isNotBlank((CharSequence)tplId) && !"null".equalsIgnoreCase(tplId)) {
                            tplIds.add(tplId);
                        }
                        map.put(billStr, tplIds);
                        continue;
                    }
                    Object strings = map.get(billStr);
                    if (Objects.nonNull(strings)) {
                        tplIds = (HashSet)strings;
                    }
                    if (StringUtils.isNotBlank((CharSequence)tplId) && !"null".equalsIgnoreCase(tplId)) {
                        tplIds.add(tplId);
                    }
                    map.put(billStr, tplIds);
                }
            }
        }
        if (CollectionUtils.isEmpty(map) && StringUtils.isNotBlank((CharSequence)defaultTpl)) {
            HashSet tplIds = new HashSet(8);
            for (Long bill : billIds) {
                String billStr = String.valueOf(bill);
                Object strings = map.get(billStr);
                if (Objects.nonNull(strings)) {
                    tplIds = (HashSet)strings;
                }
                tplIds.add(defaultTpl);
                map.put(billStr, tplIds);
            }
            return map;
        }
        if (!isOnePrint) {
            if (!CollectionUtils.isEmpty(map)) {
                view.getPageCache().put("BILLSETTING_" + formId, SerializationUtils.toJsonString(map));
            } else {
                view.getPageCache().remove("BILLSETTING_" + formId);
            }
        }
        return map;
    }

    private static Map<String, Object> getSettingTpl(IFormView view, String formId, Set<Long> billIds, boolean isOnePrint) {
        HashMap<String, Object> map = new HashMap(16);
        String cache = view.getPageCache().get("SETTING_" + formId);
        if (!isOnePrint && StringUtils.isNotBlank((CharSequence)cache)) {
            map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
            return map;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        Map<String, Object> printSetting = BillPrintServiceHelper.getPrintSetting(formId);
        Object complexSettingJson = printSetting.get("complexsetting");
        Object baseSetting = printSetting.get("basesetting");
        boolean hasEnableComplexSetting = false;
        List objs = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)complexSettingJson)) {
            objs = complexSettingJson instanceof String ? SerializationUtils.fromJsonStringToList((String)complexSettingJson.toString(), ComplexSettingItem.class) : SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString((Object)complexSettingJson), ComplexSettingItem.class);
            hasEnableComplexSetting = objs.stream().anyMatch(ComplexSettingItem::isEnable);
        }
        HashSet<Long> haveBillIds = new HashSet<Long>(8);
        if (hasEnableComplexSetting) {
            List availableFilterSetting = objs.stream().filter(p -> p.isEnable() && StringUtils.isNotBlank((CharSequence)p.getFiltertemplateid())).collect(Collectors.toList());
            if (!availableFilterSetting.isEmpty()) {
                for (ComplexSettingItem item : availableFilterSetting) {
                    FilterCondition filterCondition = null;
                    filterCondition = item.getFiltercondition() instanceof String ? (FilterCondition)SerializationUtils.fromJsonString((String)item.getFiltercondition().toString(), FilterCondition.class) : (FilterCondition)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)item.getFiltercondition()), FilterCondition.class);
                    FilterBuilder filterBuilder = new FilterBuilder(dt, filterCondition, true);
                    filterBuilder.setTimeService((ITimeService)view.getService(ITimeService.class));
                    filterBuilder.setUserService((kd.bos.service.IUserService)view.getService(IUserService.class));
                    filterBuilder.buildFilter(true);
                    String pkName = dt.getPrimaryKey().getName();
                    QFilter[] filters = new QFilter[]{filterBuilder.getQFilter(), new QFilter(pkName, "in", billIds)};
                    Map filterObjs = BusinessDataServiceHelper.loadFromCache((String)formId, (QFilter[])filters);
                    if (filterObjs.size() <= 0) continue;
                    HashSet tplIds = new HashSet(8);
                    ArrayList billIdList = new ArrayList(filterObjs.keySet());
                    for (Object bill : billIdList) {
                        long billL = (Long)bill;
                        String billStr = String.valueOf(billL);
                        Object strings = map.get(billStr);
                        if (Objects.nonNull(strings)) {
                            tplIds = (HashSet)strings;
                        }
                        tplIds.add(item.getFiltertemplateid());
                        map.put(billStr, tplIds);
                        haveBillIds.add(billL);
                    }
                }
            }
            HashMap billtypeAndTpl = new HashMap(16);
            boolean isContainBillType = BillPrintServiceHelper.isContainBillType(formId);
            if (isContainBillType && haveBillIds.size() < billIds.size() && !ObjectUtils.isEmpty((Object)baseSetting)) {
                billIds.removeAll(haveBillIds);
                List baseEntity = (List)baseSetting;
                if (baseEntity != null && !baseEntity.isEmpty()) {
                    Iterator var8 = baseEntity.iterator();
                    Set<String> tplIds = new HashSet<String>(8);
                    while (var8.hasNext()) {
                        Map map0 = (Map)var8.next();
                        String billtypeid = (String)map0.get("billtypeid");
                        String templateid = (String)map0.get(F_TEMPLATE_ID);
                        Set strings = (Set)billtypeAndTpl.get(billtypeid);
                        if (!CollectionUtils.isEmpty((Collection)strings)) {
                            tplIds = strings;
                        }
                        tplIds.add(templateid);
                        billtypeAndTpl.put(billtypeid, tplIds);
                    }
                }
                if (!CollectionUtils.isEmpty(billtypeAndTpl)) {
                    BillEntityType billDT = (BillEntityType)EntityMetadataCache.getDataEntityType((String)formId);
                    String billTypeFieldKey = billDT.getBillType();
                    String billStatusFieldKey = billDT.getBillStatus();
                    QFilter[] filters = new QFilter[]{new QFilter(dt.getPrimaryKey().getName(), "in", billIds)};
                    Map filterObjs = BusinessDataServiceHelper.loadFromCache((String)formId, (QFilter[])filters);
                    List collect = filterObjs.values().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                    for (Map.Entry it : filterObjs.entrySet()) {
                        DynamicObject billType;
                        Object key = it.getKey();
                        DynamicObject dynamicObject = (DynamicObject)it.getValue();
                        if (!StringUtils.isNotBlank((CharSequence)billTypeFieldKey) || (billType = dynamicObject.getDynamicObject(billTypeFieldKey)) == null) continue;
                        String billTypeId = billType.getPkValue() + "";
                        long keyId = (Long)key;
                        map.put(String.valueOf(keyId), billtypeAndTpl.get(billTypeId));
                    }
                }
            }
            if (!isOnePrint) {
                if (!CollectionUtils.isEmpty(map)) {
                    view.getPageCache().put("SETTING_" + formId, SerializationUtils.toJsonString(map));
                } else {
                    view.getPageCache().remove("SETTING_" + formId);
                }
            }
        }
        return map;
    }

    private static Map<String, Object> getConditionTpl(IFormView view, String formId, Set<Long> billIds, boolean isOnePrint) {
        Map<String, Object> map = new HashMap<String, Object>(16);
        String cache = view.getPageCache().get("CONDITION_" + formId);
        if (!isOnePrint && StringUtils.isNotBlank((CharSequence)cache)) {
            map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
            return map;
        }
        Map conditionMap = PrintConditionDao.getPrintConditionByBillNumber((String)formId);
        if (!conditionMap.isEmpty() && conditionMap.get("condition") != null) {
            Object conditionObj = conditionMap.get("condition");
            if (StringUtils.isBlank(conditionObj)) {
                view.getPageCache().put("CONDITION_" + formId, null);
                return map;
            }
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
            List objs = SerializationUtils.fromJsonStringToList((String)conditionObj.toString(), ComplexSettingItem.class);
            List availableFilterSetting = objs.stream().filter(p -> p.isEnable() && StringUtils.isNotBlank((CharSequence)p.getFiltertemplateid())).collect(Collectors.toList());
            for (ComplexSettingItem cps : availableFilterSetting) {
                String filtertemplateid = cps.getFiltertemplateid();
                Object filtercondition = cps.getFiltercondition();
                int filtertype = cps.getFiltertype();
                if (!StringUtils.isNotBlank((Object)filtercondition) || filtertype != 1) continue;
                FilterCondition filterCondition = filtercondition instanceof String ? (FilterCondition)SerializationUtils.fromJsonString((String)filtercondition.toString(), FilterCondition.class) : (FilterCondition)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)filtercondition), FilterCondition.class);
                FilterBuilder filterBuilder = new FilterBuilder(dt, filterCondition, true);
                filterBuilder.setTimeService((ITimeService)new TimeService());
                filterBuilder.setUserService((kd.bos.service.IUserService)new UserService());
                filterBuilder.buildFilter(true);
                String pkName = dt.getPrimaryKey().getName();
                QFilter[] filters = new QFilter[]{filterBuilder.getQFilter(), new QFilter(pkName, "in", billIds)};
                Map filterObjs = BusinessDataServiceHelper.loadFromCache((String)formId, (QFilter[])filters);
                if (filterObjs.size() <= 0) continue;
                ArrayList billIdList = new ArrayList(filterObjs.keySet());
                HashSet tplIds = new HashSet(8);
                for (Object bill : billIdList) {
                    long billL = (Long)bill;
                    String billStr = String.valueOf(billL);
                    Object strings = map.get(billStr);
                    if (Objects.nonNull(strings)) {
                        tplIds = (HashSet)strings;
                    }
                    tplIds.add(filtertemplateid);
                    map.put(billStr, tplIds);
                }
            }
            if (!isOnePrint) {
                if (!CollectionUtils.isEmpty(map)) {
                    view.getPageCache().put("CONDITION_" + formId, SerializationUtils.toJsonString(map));
                } else {
                    view.getPageCache().remove("CONDITION_" + formId);
                }
            }
        }
        return map;
    }

    public static PrintSettingInfo getTplSettingInfo(String formId) {
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("billno", "=", (Object)formId);
        qFilter.and("creator", "=", (Object)currUserId);
        PrintSettingInfo printSettingInfo = new PrintSettingInfo();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"dhc_mybillpsmapping", (QFilter[])qFilter.toArray());
        if (!Objects.isNull(dynamicObject)) {
            printSettingInfo.setPrintLang(dynamicObject.getString("printlang"));
            printSettingInfo.setPageNumType(dynamicObject.getString("pagenumtype"));
            printSettingInfo.setPageSeparation(dynamicObject.getBoolean("pageseparation"));
            printSettingInfo.setHorEconomizePaper(dynamicObject.getBoolean("hsavepage"));
            printSettingInfo.setVerEconomizePaper(dynamicObject.getBoolean("vsavepage"));
            return printSettingInfo;
        }
        BillPrintServiceHelper.getUserSetting(formId, currUserId, printSettingInfo);
        return printSettingInfo;
    }

    private static void getUserSetting(String formId, long currUserId, PrintSettingInfo printSettingInfo) {
        String key = formId + "_printsetting";
        String settingData = UserConfigServiceHelper.getSetting((long)currUserId, (String)key);
        if (StringUtils.isBlank((CharSequence)settingData)) {
            return;
        }
        Map jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        Object printLang = jsonData.get("printlang");
        if (StringUtils.isNotBlank(printLang)) {
            printSettingInfo.setPrintLang(printLang + "");
        } else {
            Lang lang = RequestContext.get().getLang();
            printSettingInfo.setPrintLang(lang.getLocale().toString());
        }
        Object hSavePage = jsonData.get("hsavepage");
        if (!Objects.isNull(hSavePage) && hSavePage instanceof Boolean) {
            printSettingInfo.setHorEconomizePaper((Boolean)hSavePage);
        } else {
            printSettingInfo.setHorEconomizePaper(Boolean.FALSE);
        }
        Object vSavePage = jsonData.get("vsavepage");
        if (!Objects.isNull(vSavePage) && vSavePage instanceof Boolean) {
            printSettingInfo.setVerEconomizePaper((Boolean)vSavePage);
        } else {
            printSettingInfo.setVerEconomizePaper(Boolean.FALSE);
        }
        Object pageNumType = jsonData.get("pagenumtype");
        printSettingInfo.setPageNumType(pageNumType + "");
        Object pageSeparation = jsonData.get("pageseparation");
        if (!Objects.isNull(pageSeparation) && pageSeparation instanceof Boolean) {
            printSettingInfo.setPageSeparation((Boolean)pageSeparation);
        } else {
            printSettingInfo.setPageSeparation(false);
        }
    }

    public static void showPrintResult(List<String> errorMsg, IFormView view) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("dhc_printresult");
        param.setCustomParam("title", (Object)ResManager.loadKDString((String)"\u6253\u5370\u5931\u8d25", (String)"MyBillPrintingPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        param.setCustomParam("describe", (Object)ResManager.loadKDString((String)"\u4e0b\u5217\u5355\u636e\u6253\u5370\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u786e\u5b9a\u8df3\u8f6c\u81f3\u6253\u5370\u8bbe\u7f6e\u9875\u9762\uff1f", (String)"MyBillPrintingPlugin_2", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        param.setCustomParam("errorMsg", errorMsg);
        view.showForm(param);
    }

    public static void showPrintResult(List<String> errorMsg, IFormView view, IFormView parentView) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("dhc_printresult");
        param.setCustomParam("title", (Object)ResManager.loadKDString((String)"\u6253\u5370\u5931\u8d25", (String)"MyBillPrintingPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        param.setCustomParam("describe", (Object)ResManager.loadKDString((String)"\u4e0b\u5217\u5355\u636e\u6253\u5370\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u786e\u5b9a\u8df3\u8f6c\u81f3\u6253\u5370\u8bbe\u7f6e\u9875\u9762\uff1f", (String)"MyBillPrintingPlugin_2", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        param.setCustomParam("errorMsg", errorMsg);
        parentView.showForm(param);
        view.sendFormAction(parentView);
    }

    public static String getPrintPreviewURL(PrintSettingInfo printSettingInfo, PrintTplInfo tplInfo, String formId, List<Object> billIds, IFormView view) {
        String pdfURL = "";
        if (Objects.isNull(tplInfo)) {
            return pdfURL;
        }
        if (tplInfo.getNewTpl().booleanValue()) {
            PrintWork printWork = new PrintWork();
            if (!Objects.isNull(printSettingInfo)) {
                printWork.setPrintLang(printSettingInfo.getPrintLang());
                printWork.setHorEconomizePaper(printSettingInfo.getHorEconomizePaper().booleanValue());
                printWork.setVerEconomizePaper(printSettingInfo.getVerEconomizePaper().booleanValue());
                printWork.setPageSeparation(printSettingInfo.isPageSeparation());
            }
            PrintTask task = new PrintTask();
            task.setTplId(tplInfo.getTplId());
            task.setPkIds(billIds);
            task.setFormId(formId);
            task.setPrintType("billForm");
            printWork.setTaskList(Stream.of(task).collect(Collectors.toList()));
            PrtAttach prtAttach = BosPrintServiceHelper.execPrint((PrintWork)printWork);
            pdfURL = UrlService.getDomainContextUrl() + String.format("/api/print/download.do?taskId=%s&attachId=%s", prtAttach.getTaskId(), ((PrtAttach.AttachDetail)prtAttach.getAttachDetail().get(0)).getAttachId());
        } else {
            pdfURL = BillPrintServiceHelper.printPreview(view.getPageId(), formId, tplInfo.getTplNumber(), billIds.toArray());
        }
        return pdfURL;
    }

    public static void openForm(IFormView view, IFormView parentView, String pdfUrl) {
        IFormView mainView = view.getMainView();
        if (mainView == null) {
            view.openUrl(pdfUrl);
        } else {
            FormShowParameter param = BillPrintServiceHelper.buildParameter(pdfUrl);
            param.setCaption(ResManager.loadKDString((String)"\u6253\u5370\u9884\u89c8", (String)"MyBillListPlugin_2", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            parentView.showForm(param);
            view.sendFormAction(parentView);
        }
    }

    public static void openForm(IFormView view, String pdfUrl) {
        IFormView mainView = view.getMainView();
        if (mainView == null) {
            view.openUrl(pdfUrl);
        } else {
            FormShowParameter param = BillPrintServiceHelper.buildParameter(pdfUrl);
            param.setCaption(ResManager.loadKDString((String)"\u6253\u5370\u9884\u89c8", (String)"MyBillListPlugin_2", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            view.showForm(param);
        }
    }

    private static FormShowParameter buildParameter(String pdfUrl) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bos_printpreview");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.setCustomParam("src", (Object)pdfUrl);
        return para;
    }

    public static Map<String, PrintSettingInfo> getAllTplSettingInfo(Set<String> formIds) {
        HashMap<String, PrintSettingInfo> printSettingInfoMap = new HashMap<String, PrintSettingInfo>(8);
        for (String formId : formIds) {
            PrintSettingInfo tplSettingInfo = BillPrintServiceHelper.getTplSettingInfo(formId);
            printSettingInfoMap.put(formId, tplSettingInfo);
        }
        return printSettingInfoMap;
    }

    public static String getTplNumById(String tplId) {
        String sql = "select fnumber from t_svc_printmeta where fid=?";
        Object[] sqlParams = new SqlParameter[]{new SqlParameter("fid", 12, (Object)tplId)};
        String tplNum = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])sqlParams, dSet -> dSet.next() ? dSet.getString("fnumber") : "");
        return tplNum;
    }

    public static void initDefaultCombo(IFormView view, String controlKey, Map<String, String> templatesMap) {
        ComboEdit defaultCombo = (ComboEdit)view.getControl(controlKey);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        for (Map.Entry<String, String> entry : templatesMap.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(new LocaleString(entry.getValue()));
            comboItems.add(item);
        }
        defaultCombo.setComboItems(comboItems);
    }

    public static Map<String, String> getCacheTemplates(IFormView view, String cacheKey, String formId) {
        String appId = view.getFormShowParameter().getAppId();
        String cacheJson = view.getPageCache().get(cacheKey + formId);
        if (StringUtils.isNotBlank((CharSequence)cacheJson)) {
            Map templates = (Map)SerializationUtils.fromJsonString((String)cacheJson, Map.class);
            return templates;
        }
        Map templates = ParamUtils.isTemplateOrgIsolated() ? PrintTemplateServiceFactory.getService().getUserPermPrintTemplateMap(formId, appId) : BillPrintServiceHelper.getNewTemplates(formId, true);
        view.getPageCache().put(cacheKey + formId, SerializationUtils.toJsonString((Object)templates));
        return templates;
    }

    public static Map<String, String> getNewTemplates(String formId, boolean includeNew) {
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        FormMetadata fm = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        String oriFormId = MetadataDao.getNumberById((String)fm.getEntityId());
        LinkedHashMap<String, String> templateMap = new LinkedHashMap<String, String>(3);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_manageprinttpl", (String)"number, name, enable,type,printtplid", (QFilter[])new QFilter[]{new QFilter("billformid", "=", (Object)oriFormId)});
        ArrayList<Object> list = new ArrayList<Object>();
        for (DynamicObject obj : dynamicObjects) {
            ILocaleString localeString;
            DynamicObject printtpObj = obj.getDynamicObject("printtplid");
            Object tplId = obj.get("printtplid_id");
            String enable = obj.getString("enable");
            if ("0".equals(enable)) continue;
            if (printtpObj == null) {
                list.add(tplId);
                continue;
            }
            if (!"B".equals(printtpObj.get("type"))) {
                localeString = printtpObj.getLocaleString("name");
                if (localeString != null) {
                    templateMap.put(tplId.toString(), localeString.getLocaleValue());
                    continue;
                }
                list.add(tplId);
                continue;
            }
            localeString = printtpObj.getLocaleString("name");
            String name = localeString.getLocaleValue();
            if (StringUtils.isBlank((CharSequence)name) && StringUtils.isBlank((CharSequence)(name = (String)localeString.get((Object)"GLang")))) {
                name = localeString.getLocaleValue_zh_CN();
            }
            if (!includeNew) continue;
            templateMap.put(tplId.toString(), name);
        }
        if (list.isEmpty()) {
            return templateMap;
        }
        QFilter qFilter = new QFilter("id", "in", list);
        Map formMetaMap = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,number,bizappid,basedatafield,modifierid", (QFilter[])new QFilter[]{qFilter});
        for (Map.Entry entry : formMetaMap.entrySet()) {
            templateMap.put(entry.getKey().toString(), ((DynamicObject)entry.getValue()).getLocaleString("name").getLocaleValue());
        }
        return templateMap;
    }
}

