/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.helper;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.AppParam;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;

public class SscImageServiceHelper {
    private static final Log log = LogFactory.getLog(SscImageServiceHelper.class);
    private static final String NO_IMAGE_VALUE = "0";
    private static final char COMMA = ',';

    public static void viewphoto(String imageNumber, String billId, String billType, IFormView view) {
        Map sourceBills;
        String userID = String.valueOf(RequestContext.get().getUserId());
        String userName = String.valueOf(RequestContext.get().getUserName());
        String message = ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5f71\u50cf\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"SscImageServiceHelper_1", (String)"fi-dhc-common", (Object[])new Object[0]);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"A");
        DynamicObject imageConfig = BusinessDataServiceHelper.loadSingle((String)"bas_imageconfig", (String)"number", (QFilter[])new QFilter[]{enableFilter});
        if (imageConfig == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u5f71\u50cf\u7cfb\u7edf\u3002", (String)"SscImageServiceHelper_0", (String)"fi-dhc-common", (Object[])new Object[0]));
            return;
        }
        String imageSys = imageConfig.getString("number");
        AppParam param = new AppParam("18XSXYEL8//U", Long.valueOf(RequestContext.get().getOrgId()));
        Object isrelatedview = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"isrelatedview");
        log.info("\u5f71\u50cf\u7cfb\u7edf\uff1a" + imageSys);
        if (isrelatedview != null && ((Boolean)isrelatedview).booleanValue() && "FPY".equals(imageSys) && (sourceBills = BFTrackerServiceHelper.findSourceBills((String)billType, (Long[])new Long[]{Long.valueOf(billId)})) != null && sourceBills.size() > 0) {
            Collection values = sourceBills.values();
            HashSet<Long> billids = new HashSet<Long>(16);
            for (HashSet hashSet : values) {
                if (hashSet == null) continue;
                billids.addAll(hashSet);
            }
            if (billids.size() > 0) {
                billids.add(Long.valueOf(billId));
                log.info("\u9700\u8981\u8054\u67e5\u7684\u5355\u636e\uff1a" + billids);
                QFilter billidsFilter = new QFilter("billid", "in", billids.stream().map(Objects::toString).collect(Collectors.toSet()));
                DynamicObject[] billimagemaps = BusinessDataServiceHelper.load((String)"task_billimagemap", (String)"id,billid,billtype,imagenumber,imagestate", (QFilter[])new QFilter[]{billidsFilter});
                if (billimagemaps == null || billimagemaps.length == 0) {
                    view.showTipNotification(message);
                    return;
                }
                StringBuilder imageString = new StringBuilder();
                for (DynamicObject billimagemap : billimagemaps) {
                    if (NO_IMAGE_VALUE.equals(billimagemap.getString("imagestate"))) continue;
                    imageString.append(billimagemap.getString("imagenumber")).append(',');
                }
                if (imageString.length() == 0) {
                    view.showTipNotification(message);
                    return;
                }
                String url = ImageServiceHelper.viewPhoto((String)imageString.toString(), (String)userID, (String)userName);
                log.info("\u83b7\u53d6\u5230\u7684url:" + url);
                if (StringUtils.isEmpty((String)url)) {
                    view.showTipNotification(message);
                    return;
                }
                view.openUrl(url);
                return;
            }
        }
        if (StringUtils.isEmpty((String)imageNumber)) {
            view.showTipNotification(message);
            return;
        }
        String url = ImageServiceHelper.viewPhoto((String)imageNumber, (String)userID, (String)userName);
        if (StringUtils.isEmpty((String)url)) {
            view.showTipNotification(message);
        } else {
            view.openUrl(url);
        }
    }
}

