/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.mircoservice.validator;

import com.alibaba.fastjson.JSONObject;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.dhc.mircoservice.exception.FIDHCBizException;
import kd.fi.dhc.mircoservice.pojo.dto.inquirybill.InquiryBillAddDTO;
import kd.fi.dhc.mircoservice.result.FIDHCErrorCode;
import kd.fi.dhc.mircoservice.validator.BaseValidator;
import org.apache.commons.lang3.StringUtils;

public class InquiryBillValidator
extends BaseValidator {
    private static final int QUESTION_DESC_LENGTH_LIMIT = 255;

    public static InquiryBillAddDTO validateAddAndTransferDTO(String params) {
        Long questionTypeId;
        InquiryBillValidator.validateNotNullOrBlank(params);
        InquiryBillAddDTO dto = null;
        try {
            dto = (InquiryBillAddDTO)JSONObject.parseObject((String)params, InquiryBillAddDTO.class);
        }
        catch (Exception e) {
            throw new FIDHCBizException(FIDHCErrorCode.PARAMS_FORMAT_IS_INCORRECT, new Object[0]);
        }
        Long userId = dto.getUserId();
        if (InquiryBillValidator.isNullOrZero(userId)) {
            long currentUserId = UserServiceHelper.getCurrentUserId();
            if (InquiryBillValidator.isNullOrZero(currentUserId)) {
                throw new FIDHCBizException(FIDHCErrorCode.INQUIRYBILL_ADD_USERID_ISNULLORZERO, new Object[0]);
            }
            dto.setUserId(currentUserId);
        }
        if (InquiryBillValidator.isNullOrZero(questionTypeId = dto.getQuestionTypeId())) {
            throw new FIDHCBizException(FIDHCErrorCode.INQUIRYBILL_ADD_QUESTIONTYPEID_ISNULLORZERO, new Object[0]);
        }
        Long questionSubTypeId = dto.getQuestionSubTypeId();
        if (InquiryBillValidator.isNullOrZero(questionSubTypeId)) {
            throw new FIDHCBizException(FIDHCErrorCode.INQUIRYBILL_ADD_QUESTIONSUBTYPEID_ISNULLORZERO, new Object[0]);
        }
        String questionDesc = dto.getQuestionDesc();
        if (StringUtils.isBlank((CharSequence)questionDesc)) {
            throw new FIDHCBizException(FIDHCErrorCode.INQUIRYBILL_ADD_QUESTIONDESC_ISBLANK, new Object[0]);
        }
        if (questionDesc.length() > 255) {
            throw new FIDHCBizException(FIDHCErrorCode.INQUIRYBILL_ADD_QUESTIONDESC_ISOVERLENGTH, 255);
        }
        return dto;
    }
}

