/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.AmountProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.dhc.config.meta.CustomizedField;
import kd.fi.dhc.constant.EntityField;
import kd.fi.dhc.enums.CusAttributeEnum;
import kd.fi.dhc.enums.FixedFieldNumberEnum;
import kd.fi.dhc.enums.IsFieldEnum;
import kd.fi.dhc.service.FieldMapService;

public class FieldMapServiceImpl
implements FieldMapService {
    private static final Log log = LogFactory.getLog(FieldMapServiceImpl.class);

    @Override
    public List<CustomizedField> getAllCustomizedField() {
        ArrayList<CustomizedField> customizedFieldList = new ArrayList<CustomizedField>(4);
        String selectField = EntityField.buildSelectField("name", "number");
        QFilter[] qFilters = new QFilter[]{new QFilter("cusattribute", "=", (Object)CusAttributeEnum.CUSTOM.getValue()), new QFilter("tag", "=", (Object)IsFieldEnum.Y.getValue())};
        DynamicObjectCollection allCustomFields = QueryServiceHelper.query((String)"dhc_billmapping", (String)selectField, (QFilter[])qFilters, (String)"number");
        for (DynamicObject dyo : allCustomFields) {
            String cusFieldName = dyo.getString("name");
            String cusFieldNumber = dyo.getString("number");
            if (!StringUtils.isNotBlank((CharSequence)cusFieldName) || !StringUtils.isNotBlank((CharSequence)cusFieldNumber)) continue;
            CustomizedField custField = new CustomizedField(cusFieldName, cusFieldNumber);
            customizedFieldList.add(custField);
        }
        return customizedFieldList;
    }

    @Override
    public List<CustomizedField> getAllCusAndMapField(String billTypeNumber) {
        ArrayList<CustomizedField> customizedFieldList = new ArrayList<CustomizedField>(4);
        String selectField = EntityField.buildSelectField("name", "number", "mappingnumber");
        QFilter[] qFilters = new QFilter[]{new QFilter("cusattribute", "=", (Object)CusAttributeEnum.CUSTOM.getValue()), new QFilter("billnumber", "=", (Object)billTypeNumber)};
        DynamicObjectCollection allCustomFields = QueryServiceHelper.query((String)"dhc_billmapping", (String)selectField, (QFilter[])qFilters, (String)"number");
        for (DynamicObject dyo : allCustomFields) {
            String cusFieldName = dyo.getString("name");
            String cusFieldNumber = dyo.getString("number");
            String mapFieldNumber = dyo.getString("mappingnumber");
            if (!StringUtils.isNotBlank((CharSequence)cusFieldName) || !StringUtils.isNotBlank((CharSequence)cusFieldNumber) || !StringUtils.isNotBlank((CharSequence)mapFieldNumber)) continue;
            CustomizedField custField = new CustomizedField(cusFieldName, cusFieldNumber, mapFieldNumber);
            customizedFieldList.add(custField);
        }
        return customizedFieldList;
    }

    @Override
    public List<String> getAllCusFieldByBillType(String billType, List<CustomizedField> customizedColumList) {
        String custFieldMapNo;
        if (StringUtils.isBlank((CharSequence)billType)) {
            return new ArrayList<String>();
        }
        ArrayList<String> custFieldIdList = new ArrayList<String>(2);
        for (CustomizedField field : customizedColumList) {
            String fieldId = field.getCustomizedFieldId();
            if (!StringUtils.isNotBlank((CharSequence)fieldId)) continue;
            custFieldIdList.add(fieldId);
        }
        int size = custFieldIdList.size();
        if (size == 0) {
            return new ArrayList<String>();
        }
        String selectField = EntityField.buildSelectField("number", "mappingnumber");
        QFilter[] qFilters = new QFilter[]{new QFilter("billnumber", "=", (Object)billType), new QFilter("number", "in", custFieldIdList)};
        DynamicObjectCollection customizedFieldInfo = QueryServiceHelper.query((String)"dhc_billmapping", (String)selectField, (QFilter[])qFilters);
        HashMap<String, String> fieldInfoMap = new HashMap<String, String>(size);
        for (DynamicObject dyo : customizedFieldInfo) {
            String custFieldId = dyo.getString("number");
            custFieldMapNo = dyo.getString("mappingnumber");
            if (!StringUtils.isNotBlank((CharSequence)custFieldId) || !StringUtils.isNotBlank((CharSequence)custFieldMapNo)) continue;
            fieldInfoMap.put(custFieldId, custFieldMapNo);
        }
        ArrayList<String> customizedMapFieldList = new ArrayList<String>(size);
        for (String custFieldId : custFieldIdList) {
            custFieldMapNo = (String)fieldInfoMap.get(custFieldId);
            if (StringUtils.isBlank((CharSequence)custFieldMapNo)) {
                custFieldMapNo = "";
            }
            customizedMapFieldList.add(custFieldMapNo);
        }
        return customizedMapFieldList;
    }

    @Override
    public String getBillStatusField(String billType) {
        return this.getMapFieldNumberWithFixedField(billType, FixedFieldNumberEnum.BILLSTATUS);
    }

    @Override
    public String getBillStatusName(String billType, String billStatusValue) {
        Map<String, String> statusNameMap = this.getStatusNameMap(billType);
        if (statusNameMap == null) {
            return null;
        }
        return statusNameMap.get(billStatusValue);
    }

    @Override
    public String getBillStatusName(Map<String, String> statusNameMap, String billStatusValue) {
        if (statusNameMap == null) {
            return null;
        }
        return statusNameMap.get(billStatusValue);
    }

    @Override
    public Map<String, String> getBillStatusName(String billType) {
        Map<String, String> statusNameMap = this.getStatusNameMap(billType);
        if (statusNameMap == null) {
            return null;
        }
        return statusNameMap;
    }

    @Override
    public Map<String, String> getStatusNameMap(String billType) {
        String jsonString = this.getStatusJson(billType);
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        List<Map<String, String>> statusMapList = this.anaStatus2Map(jsonString);
        Map<String, String> billStatusMap = statusMapList.get(1);
        return billStatusMap;
    }

    @Override
    public List<Map<String, String>> getStatusMapList(String billType) {
        String jsonString = this.getStatusJson(billType);
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        List<Map<String, String>> statusMapList = this.anaStatus2Map(jsonString);
        return statusMapList;
    }

    @Override
    public String getRemiStatus(String billType, String billStatusValue) {
        Map<String, String> statusMap = this.getStatusMap(billType);
        if (statusMap == null) {
            return null;
        }
        return statusMap.get(billStatusValue);
    }

    @Override
    public String getRemiStatus(Map<String, String> statusMap, String billStatusValue) {
        if (statusMap == null) {
            return null;
        }
        return statusMap.get(billStatusValue);
    }

    @Override
    public Map<String, String> getRemiStatus(String billType) {
        Map<String, String> statusMap = this.getStatusMap(billType);
        if (statusMap == null) {
            return null;
        }
        return statusMap;
    }

    @Override
    public Map<String, String> getStatusMap(String billType) {
        String jsonString = this.getStatusJson(billType);
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        List<Map<String, String>> statusMapList = this.anaStatus2Map(jsonString);
        return statusMapList.get(0);
    }

    @Override
    public String getBillNoField(String billType) {
        return this.getMapFieldNumberWithFixedField(billType, FixedFieldNumberEnum.BILLNO);
    }

    @Override
    public String getBillAmountField(String billType) {
        return this.getMapFieldNumberWithFixedField(billType, FixedFieldNumberEnum.BILLAMOUNT);
    }

    @Override
    public String getCurrentDealerField(String billType) {
        return this.getMapFieldNumberWithFixedField(billType, FixedFieldNumberEnum.CURRENTDEALER);
    }

    @Override
    public String getBillApplicantField(String billType) {
        return this.getMapFieldNumberWithFixedField(billType, FixedFieldNumberEnum.BILLAPPLICANT);
    }

    @Override
    public String getCreatetimeField(String billType) {
        return this.getMapFieldNumberWithFixedField(billType, FixedFieldNumberEnum.CREATETIME);
    }

    @Override
    public String getCompanyField(String billType) {
        return this.getMapFieldNumberWithFixedField(billType, FixedFieldNumberEnum.COMPANY);
    }

    @Override
    public String getBillSubjectPkId(String billType) {
        return this.getMapFieldNumberWithFixedField(billType, FixedFieldNumberEnum.BILLSUBJECT);
    }

    @Override
    public String getCurrency(String billType) {
        AmountProp amountType;
        DynamicProperty amountTypeTmp;
        String currencyField = "";
        String amountField = this.getBillAmountField(billType);
        if (StringUtils.isBlank((CharSequence)amountField)) {
            return currencyField;
        }
        DynamicObjectType type = BusinessDataServiceHelper.newDynamicObject((String)billType).getDynamicObjectType();
        if (type != null && (amountTypeTmp = type.getProperty(amountField)) instanceof AmountProp && StringUtils.isNotBlank((CharSequence)(currencyField = (amountType = (AmountProp)amountTypeTmp).getControlPropName()))) {
            return currencyField;
        }
        return currencyField;
    }

    private String getMapFieldNumberWithFixedField(String billType, FixedFieldNumberEnum fixedFieldNumber) {
        String selectField = "mappingnumber";
        QFilter[] qFilters = new QFilter[]{new QFilter("billnumber", "=", (Object)billType), new QFilter("number", "=", (Object)fixedFieldNumber.getValue())};
        DynamicObjectCollection qryResult = QueryServiceHelper.query((String)"dhc_billmapping", (String)selectField, (QFilter[])qFilters);
        if (qryResult.isEmpty()) {
            return null;
        }
        return ((DynamicObject)qryResult.get(0)).getString("mappingnumber");
    }

    private String getStatusJson(String billType) {
        String selectField = "mappingnumber";
        QFilter[] qFilters = new QFilter[]{new QFilter("billnumber", "=", (Object)billType), new QFilter("number", "=", (Object)FixedFieldNumberEnum.REIMSTATUS.getValue())};
        DynamicObjectCollection qryResult = QueryServiceHelper.query((String)"dhc_billmapping", (String)selectField, (QFilter[])qFilters);
        if (qryResult.isEmpty()) {
            return null;
        }
        return ((DynamicObject)qryResult.get(0)).getString("mappingnumber");
    }

    private List<Map<String, String>> anaStatus2Map(String jsonString) {
        Map statusMap;
        ArrayList<Map<String, String>> statusMapList = new ArrayList<Map<String, String>>(2);
        HashMap<String, String> reimStatusMap = new HashMap<String, String>(4);
        HashMap<String, String> billStatusMap = new HashMap<String, String>(4);
        statusMapList.add(reimStatusMap);
        statusMapList.add(billStatusMap);
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return statusMapList;
        }
        try {
            statusMap = (Map)SerializationUtils.fromJsonString((String)jsonString, Map.class);
        }
        catch (Exception e) {
            log.error("FieldMapServiceImpl.anaStatus2Map jason \u89e3\u6790\u51fa\u9519:" + e.getMessage(), (Throwable)e);
            throw e;
        }
        for (Map.Entry entry : statusMap.entrySet()) {
            String[] billStatusArr;
            String reimStatus = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (StringUtils.isBlank((CharSequence)value)) continue;
            for (String str : billStatusArr = value.split(",")) {
                String billStatusName;
                String[] childValue;
                String billStatus;
                if (StringUtils.isBlank((CharSequence)str) || !StringUtils.isNotBlank((CharSequence)(billStatus = (childValue = str.split("_"))[0]))) continue;
                reimStatusMap.put(billStatus, reimStatus);
                if (childValue.length < 2 || !StringUtils.isNotBlank((CharSequence)(billStatusName = childValue[1]))) continue;
                billStatusMap.put(billStatus, billStatusName);
            }
        }
        return statusMapList;
    }
}

