/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.util;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.dhc.constant.EntityField;
import kd.fi.dhc.enums.DataSynTypeEnum;
import kd.fi.dhc.executor.DataSynchronizationExecutor;
import kd.fi.dhc.service.impl.FieldMapServiceImpl;
import kd.fi.dhc.util.BillClassificationUtil;
import kd.fi.dhc.util.BillSubjectUtil;
import kd.fi.dhc.util.DynamicObjectUtils;

public class DataSynchronizationUtil {
    private static final Log log = LogFactory.getLog(DataSynchronizationUtil.class);
    private static final String IMG_UPLOADING = "0";
    private static final String IMG_UPLOADED = "1";
    private static final String ENTITY_TASK_BILL_IMAGE_MAP = "task_billimagemap";
    public static final HashSet<String> MAPPING_FIELDS = new HashSet(6);
    private static final String ALGO_KEY = "fi.dhc.DataSynchronizationUtil";
    private static final String SELECT_FIELDS = "mappingnumber,number";
    private static final QFilter FIELD_FILTER;

    public static <T> T getFieldValueFromMap(Map<String, Object> data, String field, Class<T> fieldClass) {
        if (data == null || StringUtils.isBlank((CharSequence)field)) {
            return null;
        }
        Object fieldValue = data.get(field);
        if (!fieldClass.isInstance(fieldValue)) {
            return null;
        }
        return (T)fieldValue;
    }

    public static String getBillIdByBillMetaNumber(String billMetaNumber) {
        QFilter numberFilter = new QFilter("number", "=", (Object)billMetaNumber);
        DynamicObject accessedDym = BusinessDataServiceHelper.loadSingle((String)"dhc_billaccessed", (String)"accessedbill", (QFilter[])new QFilter[]{numberFilter});
        return accessedDym.getString("accessedbill_id");
    }

    public static Map<String, String> getFiledMappingMap(String entityNumber) {
        QFilter[] qFilters = new QFilter[]{new QFilter("billnumber", "=", (Object)entityNumber), FIELD_FILTER};
        DynamicObjectCollection results = QueryServiceHelper.query((String)"dhc_billmapping", (String)SELECT_FIELDS, (QFilter[])qFilters);
        if (results.isEmpty()) {
            return null;
        }
        Map<String, String> reMap = results.stream().collect(Collectors.toMap(re -> re.getString("number"), re -> re.getString("mappingnumber"), (re1, re2) -> re2));
        String currency = DataSynchronizationUtil.getCurrencyFieldOfAmountFiled(entityNumber, reMap.get("amount"));
        if (StringUtils.isNotBlank((CharSequence)currency)) {
            reMap.put("currency", currency);
        }
        if (reMap.get("company") != null) {
            reMap.put("company", StringUtils.substringBefore((String)reMap.get("company"), (String)"."));
        }
        if (reMap.get("applicant") != null) {
            reMap.put("applicant", StringUtils.substringBefore((String)reMap.get("applicant"), (String)"."));
        }
        reMap.put("creator", "creator");
        return reMap;
    }

    private static String getCurrencyFieldOfAmountFiled(String entityName, String amountFiledName) {
        if (StringUtils.isEmpty((CharSequence)entityName) || StringUtils.isEmpty((CharSequence)amountFiledName)) {
            return null;
        }
        DynamicObjectType type = BusinessDataServiceHelper.newDynamicObject((String)entityName).getDynamicObjectType();
        if (type == null) {
            return null;
        }
        DynamicProperty amountTypeTmp = type.getProperty(amountFiledName);
        if (amountTypeTmp instanceof AmountProp) {
            AmountProp amountType = (AmountProp)amountTypeTmp;
            return amountType.getControlPropName();
        }
        return null;
    }

    public static void synDataByMyBillListIds(Object[] myBillListIds) {
        QFilter filter = new QFilter("id", "in", (Object)myBillListIds);
        String selectFields = EntityField.buildSelectField("billid", "billnew.id");
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY, "dhc_mybilllist", selectFields, filter.toArray());){
            if (ds.hasNext()) {
                for (DataSet dataSet : ds.splitByGroup(new String[]{"billnew.id"})) {
                    HashSet<Object> billPkValues = new HashSet<Object>();
                    String entityName = "";
                    for (Row row : dataSet) {
                        entityName = row.getString("billnew.id");
                        billPkValues.add(row.get("billid"));
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)entityName)) continue;
                    DataSynchronizationExecutor executor = new DataSynchronizationExecutor(entityName, billPkValues, DataSynTypeEnum.SYN_DATA);
                    executor.execute();
                }
            }
        }
    }

    public static DynamicObject buildMyBillListDynamicObjectById(String entityNumber, long billId) {
        Set<String> subjectConfiguredFields;
        if (StringUtils.isEmpty((CharSequence)entityNumber) || billId == 0L) {
            return null;
        }
        HashSet<String> selectFields = new HashSet<String>(16);
        Map<String, String> filedMappingMap = DataSynchronizationUtil.getFiledMappingMap(entityNumber);
        if (filedMappingMap == null) {
            return null;
        }
        selectFields.addAll(filedMappingMap.values());
        if ("er_tripreqbill".equals(entityNumber)) {
            selectFields.add("isloan");
        }
        if ((subjectConfiguredFields = DataSynchronizationUtil.getSubjectConfiguredFields(entityNumber)) != null && !subjectConfiguredFields.isEmpty()) {
            selectFields.addAll(subjectConfiguredFields);
        }
        selectFields.removeIf(String::isEmpty);
        HashSet<String> notContainsFields = DynamicObjectUtils.entityNotContainsFields(entityNumber, selectFields);
        if (notContainsFields == null) {
            ErrorCode code = new ErrorCode("fi.dhc.synData", String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e%s\u4e0d\u5b58\u5728\u62a5\u8d26\u5355\u636e\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataSynchronizationUtil_1", (String)"fi-dhc-common", (Object[])new Object[0]), entityNumber));
            throw new KDException(code, new Object[0]);
        }
        if (notContainsFields.size() > 0) {
            ErrorCode code = new ErrorCode("fi.dhc.synData", String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e%1$s\u7684\u201c\u62a5\u8d26\u5355\u636e\u914d\u7f6e\u201d\u5305\u542b\u672a\u77e5\u5c5e\u6027\uff1a%2$s\u3002", (String)"DataSynchronizationUtil_2", (String)"fi-dhc-common", (Object[])new Object[0]), entityNumber, String.join((CharSequence)",", notContainsFields)));
            throw new KDException(code, new Object[0]);
        }
        DynamicObject billData = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityNumber, (String)String.join((CharSequence)",", selectFields));
        return DataSynchronizationUtil.transformDataToMyBillList(entityNumber, billData, filedMappingMap);
    }

    private static DynamicObject transformDataToMyBillList(String entityNumber, DynamicObject billData, Map<String, String> fieldMappingMap) {
        Object creator;
        DynamicObject billImageMap;
        FieldMapServiceImpl service = new FieldMapServiceImpl();
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
        QFilter idFilter = new QFilter("billid", "=", billData.getPkValue());
        QFilter metaNumberFilter = new QFilter("bill.id", "=", (Object)entityId);
        boolean exists = QueryServiceHelper.exists((String)"dhc_mybilllist", (QFilter[])new QFilter[]{idFilter, metaNumberFilter});
        DynamicObject myBillData = exists ? BusinessDataServiceHelper.loadSingleFromCache((String)"dhc_mybilllist", (QFilter[])new QFilter[]{idFilter, metaNumberFilter}) : BusinessDataServiceHelper.newDynamicObject((String)"dhc_mybilllist");
        String billNo = "";
        if (StringUtils.isNotEmpty((CharSequence)fieldMappingMap.get("billno"))) {
            billNo = billData.getString(fieldMappingMap.get("billno"));
            myBillData.set("billno", (Object)billNo);
        }
        myBillData.set("billid", billData.getPkValue());
        Long billKindId = BillClassificationUtil.getBillClassificationFromBillNumber(entityId);
        myBillData.set("billkind", (Object)billKindId);
        String srcEntityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
        myBillData.set("bill", (Object)srcEntityId);
        myBillData.set("billnew", (Object)entityNumber);
        String billStatusFiled = fieldMappingMap.get("billstatus");
        if (StringUtils.isNotEmpty((CharSequence)billStatusFiled)) {
            String billStatus = billData.getString(billStatusFiled);
            myBillData.set("billstatus", (Object)billStatus);
            BillStatusProp billStatusProp = (BillStatusProp)billData.getDataEntityType().getProperties().get((Object)billStatusFiled);
            String billStatusValue = billStatusProp.getStatusItem(billStatus).getStatusName().getLocaleValue();
            myBillData.set("billstatusext", (Object)billStatusValue);
            String metaNumber = entityNumber;
            if ("er_tripreqbill".equals(entityNumber) && billData.getBoolean("isloan")) {
                metaNumber = entityNumber.concat("_loan");
            }
            myBillData.set("reimbursestatus", (Object)service.getRemiStatus(metaNumber, billStatus));
        }
        try {
            String billSubject = BillSubjectUtil.getBillSubject(entityNumber, billData);
            if (billSubject.length() > 250) {
                billSubject = billSubject.substring(0, 250);
            }
            myBillData.set("billsubject", (Object)billSubject);
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u4e3b\u9898\u65f6\u53d1\u751f\u5f02\u5e38 ", (Throwable)e);
            ErrorCode code = new ErrorCode("fi.dhc.synData", String.format(ResManager.loadKDString((String)"%1$s\u7684\u5355\u636e%2$s\u8bbe\u7f6e\u4e3b\u9898\u65f6\u53d1\u751f\u9519\u8bef", (String)"DataSynchronizationUtil_0", (String)"fi-dhc-common", (Object[])new Object[0]), entityNumber, billNo));
            throw new KDException(code, new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)fieldMappingMap.get("amount"))) {
            myBillData.set("amount", billData.get(fieldMappingMap.get("amount")));
        }
        if (StringUtils.isNotEmpty((CharSequence)fieldMappingMap.get("currency"))) {
            myBillData.set("currency", billData.get(fieldMappingMap.get("currency")));
        }
        String imgStatus = IMG_UPLOADING;
        QFilter billIdFilter = new QFilter("billid", "=", (Object)String.valueOf(billData.getPkValue()));
        if (QueryServiceHelper.exists((String)ENTITY_TASK_BILL_IMAGE_MAP, (QFilter[])new QFilter[]{billIdFilter}) && IMG_UPLOADED.equals(imgStatus = (billImageMap = QueryServiceHelper.queryOne((String)ENTITY_TASK_BILL_IMAGE_MAP, (String)"imagestate", (QFilter[])new QFilter[]{billIdFilter})).getString("imagestate"))) {
            imgStatus = IMG_UPLOADING;
        }
        myBillData.set("imagestatus", (Object)imgStatus);
        if (StringUtils.isNotEmpty((CharSequence)fieldMappingMap.get("applicant"))) {
            myBillData.set("applicant", billData.get(fieldMappingMap.get("applicant") + ".id"));
        }
        if ((creator = billData.get("creator")) == null) {
            creator = billData.get("creator_id");
        }
        myBillData.set("creator", creator);
        if (StringUtils.isNotEmpty((CharSequence)fieldMappingMap.get("createtime"))) {
            myBillData.set("createtime", billData.get(fieldMappingMap.get("createtime")));
        }
        myBillData.set("imageupdatetime", (Object)new Date());
        if (StringUtils.isNotEmpty((CharSequence)fieldMappingMap.get("company"))) {
            myBillData.set("applicant", billData.get(fieldMappingMap.get("company") + ".id"));
        }
        return myBillData;
    }

    private static Set<String> getSubjectConfiguredFields(String entityNumber) {
        QFilter numberFilter = new QFilter("billnumber", "=", (Object)entityNumber);
        DynamicObject subDyn = BusinessDataServiceHelper.loadSingle((String)"dhc_billsubject", (String)"entryentity.mark", (QFilter[])new QFilter[]{numberFilter});
        if (subDyn != null) {
            HashSet<String> fields = new HashSet<String>();
            DynamicObjectCollection entry = subDyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject dyn : entry) {
                fields.add(dyn.getString("mark"));
            }
            return fields;
        }
        return null;
    }

    static {
        MAPPING_FIELDS.add("billno");
        MAPPING_FIELDS.add("amount");
        MAPPING_FIELDS.add("billstatus");
        MAPPING_FIELDS.add("createtime");
        MAPPING_FIELDS.add("company");
        MAPPING_FIELDS.add("applicant");
        FIELD_FILTER = new QFilter("number", "in", MAPPING_FIELDS);
    }
}

