/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.util;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil
extends DateUtils {
    public static final String DEFAULT_DATE = "yyyy-MM-dd";
    public static final String DEFAULT_TIME = "yyyy-MM-dd HH:mm:ss";

    public static String getDate() {
        return DateUtil.getDate(DEFAULT_DATE);
    }

    public static String getDate(String pattern) {
        return DateFormatUtils.format((Date)new Date(), (String)pattern);
    }

    public static String formatDate(Date date, Object ... pattern) {
        String formatDate = null;
        formatDate = pattern != null && pattern.length > 0 ? DateFormatUtils.format((Date)date, (String)pattern[0].toString()) : DateFormatUtils.format((Date)date, (String)DEFAULT_DATE);
        return formatDate;
    }

    public static String formatDateTime(Date date) {
        return DateUtil.formatDate(date, DEFAULT_TIME);
    }

    public static String getTime() {
        return DateUtil.formatDate(new Date(), "HH:mm:ss");
    }

    public static String getDateTime() {
        return DateUtil.formatDate(new Date(), DEFAULT_TIME);
    }

    public static String getYear() {
        return DateUtil.formatDate(new Date(), "yyyy");
    }

    public static String getMonth() {
        return DateUtil.formatDate(new Date(), "MM");
    }

    public static String getYearMonth(Date date) {
        return DateUtil.formatDate(date, "yyyy-MM");
    }

    public static String getDay() {
        return DateUtil.formatDate(new Date(), "dd");
    }

    public static String getWeek() {
        return DateUtil.formatDate(new Date(), "E");
    }

    public static long pastDays(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 86400000L;
    }

    public static long pastHour(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 3600000L;
    }

    public static long pastMinutes(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 60000L;
    }

    public static String formatDateTime(long timeMillis) {
        long day = timeMillis / 86400000L;
        long hour = timeMillis / 3600000L - day * 24L;
        long min = timeMillis / 60000L - day * 24L * 60L - hour * 60L;
        long s = timeMillis / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        long sss = timeMillis - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
        return (day > 0L ? day + "," : "") + hour + ":" + min + ":" + s + "." + sss;
    }

    public static long getDistanceOfTwoDate(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return (afterTime - beforeTime) / 86400000L;
    }

    public static String getLastMonthFristDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, 1);
        return DateUtil.formatDate(calendar.getTime(), DEFAULT_DATE);
    }

    public static String getLastMonthLastDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.add(5, -1);
        return DateUtil.formatDate(calendar.getTime(), DEFAULT_DATE);
    }

    public static String nextMonthFirstDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.add(2, 1);
        return DateUtil.formatDate(calendar.getTime(), DEFAULT_DATE);
    }

    public static enum Format {
        YYYYMMDD("yyyyMMdd"),
        YYYY_MM_DD("yyyy-MM-dd"),
        YYYY_MM_DD_HH_MM("yyyy-MM-dd HH:mm"),
        YYYY_MM_DD_HH_MM_SS("yyyy-MM-dd HH:mm:ss"),
        YYYYMMDDHHMMSS("yyyyMMddHHmmss"),
        DDMMYYYY("ddMMMyy");

        private final String value;

        private Format(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum Pattern {
        year,
        month,
        day,
        minutes,
        second,
        millisecond,
        hour;

    }
}

