/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.util;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.dhc.mircoservice.exception.FIDHCBizException;
import kd.fi.dhc.mircoservice.result.FIDHCErrorCode;
import org.apache.commons.lang3.ArrayUtils;

public class DynamicObjectUtils {
    public static final String BOS_ASSISTANTDATA_DETAIL = "bos_assistantdata_detail";
    private static final String BIZ_CLOUD = "bos_devportal_bizcloud";

    public static DynamicObject getAssistantDataById(Long id) {
        if (id == 0L) {
            return null;
        }
        DynamicObject assistantData = BusinessDataServiceHelper.loadSingle((String)BOS_ASSISTANTDATA_DETAIL, (String)"id", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        if (assistantData != null) {
            return BusinessDataServiceHelper.loadSingle((Object)assistantData.get("id"), (DynamicObjectType)assistantData.getDynamicObjectType());
        }
        return null;
    }

    public static DynamicObject[] queryAssistantDatas(String cloudId, String groupNumber) {
        String queryFields = "id,name,number";
        QFilter qFilter = new QFilter("group.number", "=", (Object)groupNumber);
        qFilter.and(new QFilter("group.fbizcloudid.id", "=", (Object)cloudId));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        return BusinessDataServiceHelper.load((String)BOS_ASSISTANTDATA_DETAIL, (String)queryFields, (QFilter[])new QFilter[]{qFilter});
    }

    public static boolean isAssistantDataExists(String cloudId, String groupNumber, Long id) {
        QFilter qFilter = new QFilter("group.number", "=", (Object)groupNumber);
        qFilter.and(new QFilter("group.fbizcloudid.id", "=", (Object)cloudId));
        qFilter.and(new QFilter("id", "=", (Object)id));
        return QueryServiceHelper.exists((String)BOS_ASSISTANTDATA_DETAIL, (QFilter[])new QFilter[]{qFilter});
    }

    public static String getBizCloudIdByNumber(String cloudNumber) {
        String queryFields = "id,number";
        QFilter qFilter = new QFilter("number", "=", (Object)cloudNumber);
        Object[] clouds = BusinessDataServiceHelper.load((String)BIZ_CLOUD, (String)queryFields, (QFilter[])new QFilter[]{qFilter});
        if (ArrayUtils.isEmpty((Object[])clouds)) {
            throw new FIDHCBizException(FIDHCErrorCode.ESC_BIZ_CLOUD_GET_FAILED, new Object[0]);
        }
        return clouds[0].getString("id");
    }

    public static boolean isNewCreate(DynamicObject data) {
        return !data.getDataEntityState().getFromDatabase();
    }

    public static String getNumberProperty(String entityNumber) {
        String numberProperty = null;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (dataEntityType instanceof BasedataEntityType) {
            BasedataEntityType bdType = (BasedataEntityType)dataEntityType;
            numberProperty = bdType.getNumberProperty();
        } else if (dataEntityType instanceof BillEntityType) {
            BillEntityType bdType = (BillEntityType)dataEntityType;
            numberProperty = bdType.getBillNo();
        }
        return numberProperty;
    }

    public static HashSet<String> entityNotContainsFields(String entityNumber, HashSet<String> fields) {
        if (StringUtils.isEmpty((String)entityNumber) || fields == null || fields.isEmpty()) {
            return null;
        }
        HashSet<String> notContainsFields = new HashSet<String>();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (String field : fields) {
            DynamicObjectType entryProperties;
            DynamicProperty property;
            String[] split = field.split("\\.");
            IDataEntityProperty p = (IDataEntityProperty)properties.get((Object)split[0]);
            if (p == null) {
                notContainsFields.add(field);
                continue;
            }
            if (!(p instanceof EntryProp) || (property = (entryProperties = ((EntryProp)p).getDynamicCollectionItemPropertyType()).getProperty(split[1])) != null && split.length <= 2) continue;
            notContainsFields.add(field);
        }
        return notContainsFields;
    }
}

