/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.util;

import java.util.Date;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.dhc.domain.RecordExceptionDO;

public class RecordExceptionUtil {
    private static final Log log = LogFactory.getLog(RecordExceptionUtil.class);
    private static final String FORM_EXCEPTION_DETAIL = "dhc_exceptiondetail";

    public static boolean saveRecordExcept(String excType, String excReason, String excReason_json, String canRetry) {
        try {
            DynamicObject recordExcept = BusinessDataServiceHelper.newDynamicObject((String)"dhc_exceptionrecord");
            recordExcept.set("exctype", (Object)excType);
            recordExcept.set("excreason", (Object)excReason);
            recordExcept.set("excreason_tag", (Object)excReason_json);
            recordExcept.set("canretry", (Object)canRetry);
            recordExcept.set("exccreatetime", (Object)new Date());
            recordExcept.set("state", (Object)"0");
            Object[] ret = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordExcept});
            if (ret != null && ret.length > 0) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("kd.fi.dhc.util.RecordExceptionUtil.saveRecordExcept \u2014- \u65b0\u589e\u5f02\u5e38\u8bb0\u5f55\u51fa\u9519", (Throwable)e);
        }
        return false;
    }

    public static boolean saveRecordExcept(RecordExceptionDO recordExceptionDO) {
        try {
            DynamicObject recordExcept = BusinessDataServiceHelper.newDynamicObject((String)"dhc_exceptionrecord");
            recordExcept.set("exctype", (Object)recordExceptionDO.getExcType());
            recordExcept.set("billtype", (Object)recordExceptionDO.getBillType());
            recordExcept.set("billid", (Object)recordExceptionDO.getBillId());
            recordExcept.set("billnumber", (Object)recordExceptionDO.getBillNumber());
            recordExcept.set("classname", (Object)recordExceptionDO.getClassname());
            recordExcept.set("methodname", (Object)recordExceptionDO.getMethodName());
            recordExcept.set("traceid", (Object)recordExceptionDO.getTraceId());
            recordExcept.set("excreason", (Object)recordExceptionDO.getExcReason());
            recordExcept.set("excreason_tag", (Object)recordExceptionDO.getExcReason_tag());
            recordExcept.set("excargument", (Object)recordExceptionDO.getExcArgument());
            recordExcept.set("excargument_tag", (Object)recordExceptionDO.getExcArgument_tag());
            recordExcept.set("exccreatetime", (Object)new Date());
            recordExcept.set("canretry", (Object)recordExceptionDO.getCanRetry());
            recordExcept.set("state", (Object)recordExceptionDO.getState());
            Object[] ret = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordExcept});
            if (ret != null && ret.length > 0) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("kd.fi.dhc.util.RecordExceptionUtil.saveRecordExcept \u2014- \u65b0\u589e\u5f02\u5e38\u8bb0\u5f55\u51fa\u9519", (Throwable)e);
        }
        return false;
    }

    public static boolean saveBatchRecordExcept(List<RecordExceptionDO> recordExceptionDOs) {
        DynamicObject[] recordExcepts = new DynamicObject[recordExceptionDOs.size()];
        for (int i = 0; i < recordExceptionDOs.size(); ++i) {
            RecordExceptionDO recordExceptionDO = recordExceptionDOs.get(i);
            DynamicObject recordExcept = BusinessDataServiceHelper.newDynamicObject((String)"dhc_exceptionrecord");
            recordExcept.set("exctype", (Object)recordExceptionDO.getExcType());
            recordExcept.set("billtype", (Object)recordExceptionDO.getBillType());
            recordExcept.set("billid", (Object)recordExceptionDO.getBillId());
            recordExcept.set("billnumber", (Object)recordExceptionDO.getBillNumber());
            recordExcept.set("classname", (Object)recordExceptionDO.getClassname());
            recordExcept.set("methodname", (Object)recordExceptionDO.getMethodName());
            recordExcept.set("traceid", (Object)recordExceptionDO.getTraceId());
            recordExcept.set("excreason", (Object)recordExceptionDO.getExcReason());
            recordExcept.set("excreason_tag", (Object)recordExceptionDO.getExcReason_tag());
            recordExcept.set("excargument", (Object)recordExceptionDO.getExcArgument());
            recordExcept.set("excargument_tag", (Object)recordExceptionDO.getExcArgument_tag());
            recordExcept.set("exccreatetime", (Object)new Date());
            recordExcept.set("canretry", (Object)recordExceptionDO.getCanRetry());
            recordExcept.set("state", (Object)recordExceptionDO.getState());
            recordExcepts[i] = recordExcept;
        }
        try {
            Object[] ret = SaveServiceHelper.save((DynamicObject[])recordExcepts);
            if (ret != null && ret.length != recordExcepts.length) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("kd.fi.dhc.util.RecordExceptionUtil.saveRecordExcept \u2014- \u65b0\u589e\u5f02\u5e38\u8bb0\u5f55\u51fa\u9519", (Throwable)e);
        }
        return false;
    }

    public static void openShowDetailDialog(IFormView view, String txtTip, String messageContent) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(FORM_EXCEPTION_DETAIL);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setCaption(txtTip);
        formShowParameter.setCustomParam("messagecontent", (Object)RecordExceptionUtil.getSubString(messageContent, 2000));
        view.showForm(formShowParameter);
    }

    public static void deleteAll(Date date) {
        QFilter qFilter = new QFilter("exccreatetime", "<", (Object)date);
        try {
            DeleteServiceHelper.delete((String)"dhc_exceptionrecord", (QFilter[])new QFilter[]{qFilter});
        }
        catch (Exception e) {
            log.error("kd.fi.dhc.util.RecordExceptionUtil.deleteAll -- \u6e05\u9664\u6570\u636e\u51fa\u9519", (Throwable)e);
            throw e;
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder("Exception:");
        if (throwable != null) {
            StackTraceElement[] elements;
            stringBuilder.append(throwable.getMessage()).append('\n');
            for (StackTraceElement e : elements = throwable.getStackTrace()) {
                stringBuilder.append('\t').append(e).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    private static String getSubString(String content, int length) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return "";
        }
        if (content.length() > length) {
            return StringUtils.substring((String)content, (int)0, (int)length);
        }
        return content;
    }
}

