/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.webapi.inquirybill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.ai.model.ResponseModel;
import kd.bos.ai.model.UrlModel;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.AICommand;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.fi.bd.mircoservice.result.ServiceResult;
import kd.fi.dhc.mircoservice.helper.InquiryBillServiceHelper;

public class InquiryBillAddApiPlugin
extends AbstractBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(InquiryBillAddApiPlugin.class);
    private static final String APP_ID = "dhc";
    private static final String BILL_FORM_ID = "dhc_inquirybill";

    public void doAICommand(AICommandEvent e) {
        AICommand aiCommand = e.getCommand();
        this.logInfo("InquiryBillAddApiPlugin doAICommand accept a request:" + JSON.toJSONString((Object)aiCommand));
        ApiResult apiResult = null;
        try {
            String jsonParams = this.extractJsonParams(aiCommand);
            ServiceResult<Long> serviceResult = this.invokeService(jsonParams);
            apiResult = serviceResult.toApiResultWithoutData();
            if (apiResult.getSuccess()) {
                this.setApiResultData(apiResult, serviceResult);
            }
        }
        catch (Exception ex) {
            apiResult = ApiResult.ex((Throwable)ex);
            this.logError("InquiryBillAddApiPlugin doAICommand occur exception:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
        }
        this.logInfo("InquiryBillAddApiPlugin doAICommand response result:" + JSON.toJSONString((Object)apiResult));
        apiResult.setSuccess(true);
        e.setResult(apiResult);
    }

    private ServiceResult<Long> invokeService(String jsonParams) {
        String jsonResult = InquiryBillServiceHelper.add((String)jsonParams);
        return (ServiceResult)JSON.parseObject((String)jsonResult, ServiceResult.class);
    }

    private void setApiResultData(ApiResult apiResult, ServiceResult<Long> serviceResult) {
        Long billId = (Long)serviceResult.getData();
        String url = this.buildShowBillUrl(billId);
        UrlModel urlModel = this.createUrlModel(url);
        ResponseModel responseModel = ResponseModel.createUrlResponse((UrlModel)urlModel);
        apiResult.setData((Object)responseModel);
    }

    private UrlModel createUrlModel(String url) {
        UrlModel urlModel = new UrlModel();
        urlModel.setTitle(ResManager.loadKDString((String)"\u5171\u4eab\u95ee\u8be2\u5de5\u5355", (String)"InquiryBillAddApiPlugin_0", (String)"fi-dhc-webapi", (Object[])new Object[0]));
        urlModel.setContent(ResManager.loadKDString((String)"\u5171\u4eab\u95ee\u8be2\u5de5\u5355", (String)"InquiryBillAddApiPlugin_1", (String)"fi-dhc-webapi", (Object[])new Object[0]));
        urlModel.setUrl(url);
        urlModel.setIframe(true);
        return urlModel;
    }

    private String buildShowBillUrl(Long billId) {
        JSONObject urlData = new JSONObject();
        urlData.put("appId", (Object)APP_ID);
        urlData.put("billFormId", (Object)BILL_FORM_ID);
        urlData.put("billPkId", (Object)billId);
        StringBuilder url = new StringBuilder("bizAction://ShowBillForm?");
        url.append(urlData.toJSONString());
        return url.toString();
    }

    private void logInfo(String infoLog) {
        if (logger.isInfoEnabled()) {
            logger.info(infoLog);
        }
    }

    private void logError(String errorLog) {
        if (logger.isErrorEnabled()) {
            logger.error(errorLog);
        }
    }

    private String extractJsonParams(AICommand aiCommand) {
        Map params = aiCommand.getParameter();
        if (params == null) {
            return null;
        }
        return JSON.toJSONString((Object)params);
    }
}

