/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Icon;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.fi.dhc.formplugin.util.AppMenuUtil;
import kd.fi.dhc.helper.AppMetaServiceHelperExt;

public class AppMenuPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String OPEN_TYPE_MAIN_NEW_TAB_PAGE = "MainNewTabPage";
    private static final String BOS_FORM_META = "bos_formmeta";
    private static final String DHC_FORM_LIST_F7 = "dhc_formlistf7";
    private static final String IDE_VECTOR_LIST = "ide_vectorlist";
    private static final String IDE_PICTURE_SELECTOR = "ide_pictureselector";
    private static final String HELP_CENTER_FLAG = "#hpce";
    private static final String CUSTOMIZED_MENU_FLAG = "#customized";
    private static final String PARAM_TYPE_VALUE = "ListShowParameter";
    private static final String FIELD_MENU_NAME = "menuname";
    private static final String FIELD_FORM_NAME = "formname";
    private static final String FIELD_FORM_ID = "formid";
    private static final String FIELD_VECTOR = "vectorap";
    private static final String FIELD_VECTOR_VALUE = "vectorvalue";
    private static final String FIELD_SHORT_CUT_ICON = "shortcuticon";
    private static final String FIELD_SHORT_CUT_ENTRANCE = "shortcutentrance";
    private static final String FIELD_PARENT_MENU_NAME = "parentmenuname";
    private static final String FIELD_PARENT_MENU_ID = "parentmenuid";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_MENU_SEQ = "menuseq";
    private static final String FIELD_VISIBLE = "visible";
    private static final String BTN_CONFIRM = "confirm";
    private static final String CALL_BACK_FORM = "formCallBack";
    private static final String CALL_BACK_VECTOR = "vectorapCallBack";
    private static final String CALL_BACK_SHORT_CUT_ICON = "shortcuticonCallBack";
    private static final String CACHE_NODE_ID = "nodeId";
    private static final String CACHE_PARENT_NODE_ID = "parentNodeId";
    private static final Log log = LogFactory.getLog(AppMenuPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{FIELD_FORM_NAME, FIELD_VECTOR, FIELD_SHORT_CUT_ICON, BTN_CONFIRM, FIELD_PARENT_MENU_NAME});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        Map map = param.getCustomParams();
        String nodeId = map.get(CACHE_NODE_ID).toString();
        String parentNodeId = map.get(CACHE_PARENT_NODE_ID).toString();
        String appId = map.get("appId").toString();
        this.getPageCache().put(CACHE_PARENT_NODE_ID, parentNodeId);
        this.getPageCache().put(CACHE_NODE_ID, nodeId);
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataById((String)appId, (boolean)false);
        if (param.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            this.addNew(appId, appMeta, nodeId);
        } else if (param.getStatus().equals((Object)OperationStatus.EDIT)) {
            this.edit(appId, appMeta, nodeId);
        }
    }

    public void afterBindData(EventObject e) {
        String id;
        super.afterBindData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        if (param.getStatus().equals((Object)OperationStatus.EDIT) && StringUtils.isNotBlank((CharSequence)(id = (String)this.getModel().getValue(FIELD_FORM_ID)))) {
            boolean exists = QueryServiceHelper.exists((String)BOS_FORM_META, (Object)id);
            if (exists) {
                DynamicObject form = BusinessDataServiceHelper.loadSingle((Object)id, (String)BOS_FORM_META, (String)"modeltype,name");
                this.getModel().setValue(FIELD_FORM_NAME, (Object)form.getLocaleString("name").getLocaleValue());
            } else {
                this.getModel().setValue(FIELD_FORM_NAME, null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u83dc\u5355\u9875\u9762\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"AppMenuPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_CONFIRM.equalsIgnoreCase(key)) {
            if (this.checkRepeat()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u7ea7\u76ee\u5f55\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u83dc\u5355\u3002", (String)"AppMenuTreePlugin_26", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            this.prepareDataBeforeSave();
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (FIELD_FORM_NAME.equalsIgnoreCase(key)) {
            AppMenuElement appMenuElement;
            String formId;
            String parentMenuId = this.getModel().getValue(FIELD_PARENT_MENU_ID).toString();
            String appId = (String)this.getView().getFormShowParameter().getCustomParam("appId");
            JSONArray appIds = AppMenuUtil.getAppIds(appId);
            if (StringUtils.isNotBlank((CharSequence)parentMenuId) && !appIds.contains((Object)parentMenuId) && StringUtils.isNotBlank((CharSequence)(formId = (appMenuElement = AppMetaServiceHelper.getMenuById((String)parentMenuId, (String)appId, (boolean)false)).getFormId()))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u89e3\u9664\u4e0a\u7ea7\u83dc\u5355\u4e2d\u7ed1\u5b9a\u7684\u9875\u9762\u3002", (String)"AppMenuPlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCaption(ResManager.loadKDString((String)"\u901a\u7528\u8868\u5355\u9009\u62e9", (String)"AppMenuPlugin_3", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            param.setFormId(DHC_FORM_LIST_F7);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_FORM));
            this.getView().showForm(param);
        } else if (FIELD_VECTOR.equalsIgnoreCase(key)) {
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId(IDE_VECTOR_LIST);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_VECTOR));
            this.getView().showForm(param);
        } else if (FIELD_SHORT_CUT_ICON.equalsIgnoreCase(key)) {
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId(IDE_PICTURE_SELECTOR);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_SHORT_CUT_ICON));
            this.getView().showForm(param);
        } else if (BTN_CONFIRM.contentEquals(key)) {
            String menuName = this.getModel().getValue(FIELD_MENU_NAME).toString();
            if (!this.isFirstLevel() && StringUtils.isBlank((CharSequence)menuName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ed1\u5b9a\u5355\u636e\u3002", (String)"AppMenuPlugin_4", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                return;
            }
            String parentMenuId = this.getModel().getValue(FIELD_PARENT_MENU_ID).toString();
            String menuId = this.getPageCache().get("menuId");
            HashMap<String, String> returnData = new HashMap<String, String>(4);
            returnData.put("menuName", menuName);
            returnData.put("menuId", menuId);
            returnData.put(FIELD_PARENT_MENU_ID, parentMenuId);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (FIELD_FORM_NAME.equals(propertyName)) {
            String formName = (String)this.getModel().getValue(FIELD_FORM_NAME);
            if (StringUtils.isBlank((CharSequence)formName)) {
                this.getModel().setValue(FIELD_FORM_ID, null);
            }
            if (StringUtils.isBlank((CharSequence)formName) && this.isFirstLevel()) {
                this.getView().setEnable(Boolean.TRUE, new String[]{FIELD_MENU_NAME});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (event.getReturnData() == null) {
            return;
        }
        String callBackId = event.getActionId();
        IDataModel model = this.getModel();
        if (CALL_BACK_FORM.equalsIgnoreCase(callBackId)) {
            Map rt = (Map)event.getReturnData();
            model.setValue(FIELD_MENU_NAME, rt.get("formName"));
            model.setValue(FIELD_FORM_NAME, rt.get("formName"));
            model.setValue(FIELD_FORM_ID, rt.get("formId"));
            if (this.isFirstLevel()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_MENU_NAME});
            }
        } else if (CALL_BACK_VECTOR.equalsIgnoreCase(callBackId)) {
            Map map = (Map)event.getReturnData();
            Vector vector = (Vector)this.getControl(FIELD_VECTOR);
            String value = (String)map.get("value");
            if (StringUtils.isNotBlank((CharSequence)value)) {
                vector.setFontClass(value);
                this.getModel().setValue(FIELD_VECTOR_VALUE, (Object)value);
            } else {
                vector.setFontClass("kdfont kdfont-tianjia");
                this.getModel().setValue(FIELD_VECTOR_VALUE, (Object)"");
            }
        } else if (CALL_BACK_SHORT_CUT_ICON.equalsIgnoreCase(callBackId)) {
            Map map = (Map)event.getReturnData();
            Icon icon = (Icon)this.getControl(FIELD_SHORT_CUT_ICON);
            String value = (String)map.get("value");
            if (StringUtils.isNotBlank((CharSequence)value)) {
                icon.setUrl(value);
                this.getModel().setValue(FIELD_SHORT_CUT_ENTRANCE, (Object)value);
            } else {
                icon.setUrl("");
                this.getModel().setValue(FIELD_SHORT_CUT_ENTRANCE, (Object)"");
            }
        }
    }

    private int getMaxSeq(String appId, String parentNodeId) {
        short seq = 0;
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
        JSONArray appIds = AppMenuUtil.getAppIds(appId);
        List appMenus = appMetadata.getAppMenus();
        for (AppMenuElement appMenu : appMenus) {
            short menuSeq;
            String menuParentId = appMenu.getParentId();
            String menuId = appMenu.getId();
            if (parentNodeId.equals(appId)) {
                if (!StringUtils.isBlank((CharSequence)menuParentId) && !appIds.contains((Object)menuParentId) || menuId.endsWith(HELP_CENTER_FLAG)) continue;
                menuSeq = appMenu.getSeq();
                seq = seq > menuSeq ? seq : menuSeq;
                continue;
            }
            if (!parentNodeId.equals(menuParentId)) continue;
            menuSeq = appMenu.getSeq();
            seq = seq > menuSeq ? seq : menuSeq;
        }
        return seq;
    }

    private void addNew(String appId, AppMetadata appMeta, String nodeId) {
        IDataModel model = this.getModel();
        if (appId.equals(nodeId)) {
            model.setValue(FIELD_PARENT_MENU_NAME, (Object)appMeta.getName().getLocaleValue());
            model.setValue(FIELD_PARENT_MENU_ID, (Object)appId);
            String seq = String.valueOf(this.getMaxSeq(appId, appId) + 1);
            model.setValue(FIELD_MENU_SEQ, (Object)seq);
        } else {
            AppMenuElement appMenuElement = AppMetaServiceHelper.getMenuById((String)nodeId, (String)appId, (boolean)false);
            if (appMenuElement == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u83dc\u5355\u5206\u7c7b\u5df2\u5728\u5176\u5b83\u5730\u65b9\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5e94\u7528\u3002", (String)"AppMenuPlugin_5", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                return;
            }
            model.setValue(FIELD_PARENT_MENU_NAME, (Object)appMenuElement.getName().getLocaleValue());
            model.setValue(FIELD_PARENT_MENU_ID, (Object)nodeId);
            String seq = String.valueOf(this.getMaxSeq(appId, nodeId) + 1);
            model.setValue(FIELD_MENU_SEQ, (Object)seq);
            this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_MENU_NAME});
        }
    }

    private void edit(String appId, AppMetadata appMeta, String nodeId) {
        IDataModel model = this.getModel();
        String menuNumber = this.getMenuNumber(appMeta, nodeId);
        if (nodeId.endsWith(HELP_CENTER_FLAG) || !menuNumber.endsWith(CUSTOMIZED_MENU_FLAG)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_MENU_NAME, FIELD_FORM_NAME, FIELD_DESCRIPTION, FIELD_VECTOR, FIELD_SHORT_CUT_ICON, FIELD_PARENT_MENU_NAME, FIELD_VISIBLE});
        }
        if (((Boolean)this.getView().getFormShowParameter().getCustomParam("isParent")).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_FORM_NAME});
        }
        for (int i = 0; i < appMeta.getAppMenus().size(); ++i) {
            boolean formExist;
            AppMenuElement menu = (AppMenuElement)appMeta.getAppMenus().get(i);
            if (!menu.getId().equals(nodeId)) continue;
            model.setValue(FIELD_MENU_SEQ, (Object)menu.getSeq());
            model.setValue(FIELD_MENU_NAME, (Object)menu.getName().getLocaleValue());
            model.setValue(FIELD_DESCRIPTION, (Object)menu.getDescription().getLocaleValue());
            model.setValue(FIELD_VISIBLE, (Object)menu.getVisible());
            String formId = menu.getFormId();
            String formName = "";
            if (StringUtils.isNotBlank((CharSequence)formId) && (formExist = QueryServiceHelper.exists((String)BOS_FORM_META, (Object)formId))) {
                AbstractMetadata formMeta = MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
                if (formMeta != null) {
                    FormMetadata fm = (FormMetadata)formMeta;
                    formName = fm.getName().getLocaleValue();
                }
                model.setValue(FIELD_FORM_ID, (Object)formId);
                model.setValue(FIELD_FORM_NAME, (Object)formName);
            }
            model.setValue(FIELD_VECTOR_VALUE, (Object)menu.getVectorImage());
            model.setValue(FIELD_SHORT_CUT_ENTRANCE, (Object)menu.getIconShortcut());
            String parentId = menu.getParentId();
            JSONArray appIds = AppMenuUtil.getAppIds(appId);
            if (StringUtils.isBlank((CharSequence)parentId) || appIds.contains((Object)parentId)) {
                model.setValue(FIELD_PARENT_MENU_ID, (Object)parentId);
                model.setValue(FIELD_PARENT_MENU_NAME, (Object)appMeta.getName().getLocaleValue());
                break;
            }
            AppMenuElement appMenuElement = AppMetaServiceHelper.getMenuById((String)parentId, (String)appId, (boolean)false);
            model.setValue(FIELD_PARENT_MENU_ID, (Object)parentId);
            model.setValue(FIELD_PARENT_MENU_NAME, (Object)appMenuElement.getName().getLocaleValue());
            this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_MENU_NAME});
            break;
        }
        Vector vector = (Vector)this.getControl(FIELD_VECTOR);
        String vectorValue = (String)this.getModel().getValue(FIELD_VECTOR_VALUE);
        if (StringUtils.isNotBlank((CharSequence)vectorValue)) {
            vector.setFontClass(vectorValue);
        }
        Icon icon = (Icon)this.getControl(FIELD_SHORT_CUT_ICON);
        String shortCutEntrance = (String)this.getModel().getValue(FIELD_SHORT_CUT_ENTRANCE);
        if (StringUtils.isNotBlank((CharSequence)shortCutEntrance)) {
            icon.setUrl(shortCutEntrance);
        }
    }

    private void prepareDataBeforeSave() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String appId = (String)param.getCustomParam("appId");
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
        this.setAppMenuElementValue(appId, metadata, param.getStatus());
        AppMetaServiceHelperExt.save((AppMetadata)metadata);
        log.debug("\u5df2\u4fdd\u5b58\u65b0\u7684\u83dc\u5355\u5143\u6570\u636e\uff0cappId: " + appId + ", name: " + metadata.getName() + ", number: " + metadata.getNumber() + ", id: " + metadata.getId());
    }

    private void setAppMenuElementValue(String appId, AppMetadata metadata, OperationStatus status) {
        IDataModel model = this.getModel();
        List appMenus = metadata.getAppMenus();
        String parentNodeId = (String)this.getModel().getValue(FIELD_PARENT_MENU_ID);
        String nodeId = this.getPageCache().get(CACHE_NODE_ID);
        AppMenuElement appMenuElement = null;
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            appMenuElement = AppMetaServiceHelper.CreateBlankAppMenuElement();
            String menuId = Uuid16.create().toString();
            this.getPageCache().put("menuId", menuId);
            appMenuElement.setId(menuId);
            String uuid = UUID.randomUUID().toString().replace("-", "");
            String menuNum = uuid.substring(0, 10) + CUSTOMIZED_MENU_FLAG;
            appMenuElement.setNumber(menuNum);
            if (StringUtils.isBlank((CharSequence)parentNodeId)) {
                appMenuElement.setParentId(appId);
            } else {
                appMenuElement.setParentId(parentNodeId);
            }
        } else {
            for (AppMenuElement appMenu : appMenus) {
                if (!nodeId.equals(appMenu.getId())) continue;
                appMenuElement = appMenu;
            }
        }
        DynamicObject appMenuObj = model.getDataEntity();
        if (appMenuElement != null) {
            appMenuElement.setName(LocaleString.fromMap((Map)appMenuObj.getLocaleString(FIELD_MENU_NAME)));
            appMenuElement.setFormName((String)model.getValue(FIELD_FORM_NAME));
            String formId = (String)model.getValue(FIELD_FORM_ID);
            appMenuElement.setFormId(formId);
            if (StringUtils.isNotBlank((CharSequence)formId)) {
                appMenuElement.setFormNumber(MetadataDao.getNumberById((String)formId));
            }
            appMenuElement.setDescription(LocaleString.fromMap((Map)appMenuObj.getLocaleString(FIELD_DESCRIPTION)));
            Integer seq = (Integer)model.getValue(FIELD_MENU_SEQ);
            appMenuElement.setSeq(seq.shortValue());
            appMenuElement.setVectorImage((String)model.getValue(FIELD_VECTOR_VALUE));
            appMenuElement.setIconShortcut((String)model.getValue(FIELD_SHORT_CUT_ENTRANCE));
            appMenuElement.setOpenType(OPEN_TYPE_MAIN_NEW_TAB_PAGE);
            appMenuElement.setPermission(null);
            appMenuElement.setVisible(model.getValue(FIELD_VISIBLE).toString());
            appMenuElement.setParameterType(PARAM_TYPE_VALUE);
        }
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            appMenus.add(appMenuElement);
        }
    }

    private String getMenuNumber(AppMetadata appMeta, String nodeId) {
        List appMenus = appMeta.getAppMenus();
        AppMenuElement menuElement = null;
        for (AppMenuElement menu : appMenus) {
            if (!nodeId.equals(menu.getId())) continue;
            menuElement = menu;
            break;
        }
        if (menuElement != null) {
            return menuElement.getNumber();
        }
        return "";
    }

    private boolean isFirstLevel() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String nodeId = (String)param.getCustomParam(CACHE_NODE_ID);
        String appId = (String)param.getCustomParam("appId");
        return StringUtils.isNotBlank((CharSequence)nodeId) && nodeId.equalsIgnoreCase(appId);
    }

    private boolean checkRepeat() {
        boolean isRepeat = false;
        Boolean isFirstLevel = this.isFirstLevel();
        String menuname = this.getModel().getValue(FIELD_MENU_NAME).toString();
        FormShowParameter param = this.getView().getFormShowParameter();
        Map map = param.getCustomParams();
        String appId = map.get("appId").toString();
        String nodeId = map.get(CACHE_NODE_ID).toString();
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataById((String)appId, (boolean)false);
        List appMenus = appMeta.getAppMenus();
        if (isFirstLevel.booleanValue()) {
            for (AppMenuElement e : appMenus) {
                if (!appId.equals(e.getParentId()) || !menuname.equals(e.getName().toString())) continue;
                isRepeat = true;
                break;
            }
        } else {
            String formid = this.getModel().getValue(FIELD_FORM_ID).toString();
            for (AppMenuElement e : appMenus) {
                if (!nodeId.equals(e.getParentId()) || !formid.equals(e.getFormId())) continue;
                isRepeat = true;
                break;
            }
        }
        return isRepeat;
    }
}

