/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.MoveEntryDown;
import kd.bos.form.operate.MoveEntryUp;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.dhc.constant.EntityField;
import kd.fi.dhc.formplugin.util.AppMenuUtil;
import kd.fi.dhc.helper.AppMetaServiceHelperExt;

public class AppMenuTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
HyperLinkClickListener,
SearchEnterListener {
    private static final String APP_NUMBER = "dhc";
    private static final String BOS_DEV_PORTAL_BIZ_APP = "bos_devportal_bizapp";
    private static final String BOS_FORM_META = "bos_formmeta";
    private static final String MENU_TREE = "menutreeview";
    private static final String MENU_ENTRY = "menuentryentity";
    private static final String TOOL_BAR = "toolbarap";
    private static final String BTN_NEW_SON = "btnnewson";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DELETE = "btndelete";
    private static final String BTN_SYN_EXT_BILL = "synextbill";
    private static final String OPERATION_COLUMN = "operationcolumnap";
    private static final String MOVE_ENTRY_UP = "moveentryup";
    private static final String MOVE_ENTRY_DOWN = "moveentrydown";
    private static final String KEY_SEARCH = "searchap";
    private static final String FIELD_CHECKBOX = "checkboxfield";
    private static final String FIELD_MENU_ID = "menuid";
    private static final String FIELD_PARENT_MENU_ID = "parentmenuid";
    private static final String FIELD_MENU_NAME = "menuname";
    private static final String FIELD_FORM_NAME = "formname";
    private static final String FIELD_OPEN_TYPE = "opentype";
    private static final String FIELD_VISIBLE = "visible";
    private static final String FIELD_MENU_SEQ = "menuseq";
    private static final String EXT_FLAG = "2";
    private static final String HELP_CENTER_FLAG = "#hpce";
    private static final String CUSTOMIZED_MENU_FLAG = "#customized";
    private static final String CALL_BACK_DELETE = "deleteNodeCallBack";
    private static final String CALL_BACK_ADD = "addNewCallBack";
    private static final String CALL_BACK_EDIT = "editCallBack";
    private static final String CACHE_APP_ID = "appId";
    private static final String CACHE_APP_NAME = "appName";
    private static final String CACHE_ROOT = "root";
    private static final String CACHE_NODE_LEVEL = "nodeLevel";
    private static final String CACHE_CHECKED_NODE_ID = "checkedNodeId";
    private static final String CACHE_CHECKED_L4NODE_NAME = "checkedL4NodeName";
    private static final String CACHE_CHECKED_PARENT_NODE_ID = "checkedParentNodeId";
    private static final String CACHE_DELETE_NODE_IDS = "deleteNodeIds";
    private static final String CACHE_SEARCH_NODES = "searchNodes";
    private static final String CACHE_SEARCH_TEXT = "searchText";
    private static final String CACHE_APP_IDS = "appIds";
    private static final String OPEN_TYPE_MAIN_NEW_TAB_PAGE = "MainNewTabPage";
    private static final String BOS_BILL_MAIN_ENTITY = "bos_billmainentity";
    private Log logger = LogFactory.getLog(AppMenuTreePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BAR});
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        AbstractGrid grid = (AbstractGrid)this.getControl(MENU_ENTRY);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        AppMetadata metadata = this.getMetadata();
        if (metadata != null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_EDIT, BTN_DELETE});
            this.renderMenuTree(metadata);
            boolean isChecked = (Boolean)this.getModel().getValue(FIELD_CHECKBOX);
            this.showMenuList(this.getCurrentAppIdFromCache(), metadata, isChecked);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (FIELD_CHECKBOX.equalsIgnoreCase(propertyName)) {
            TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
            Map nodeInfo = tree.getTreeState().getFocusNode();
            this.logger.info("kd.fi.dhc.formplugin.AppMenuTreePlugin.propertyChanged.nodeInfo:" + nodeInfo);
            if (nodeInfo.get("id") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u83dc\u5355\u4f5c\u4e3a\u6dfb\u52a0\u6570\u636e\u7684\u7236\u83dc\u5355\u3002", (String)"AppMenuTreePlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                return;
            }
            String nodeId = nodeInfo.get("id").toString();
            String appId = this.getCurrentAppIdFromCache();
            AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
            boolean isChecked = (Boolean)this.getModel().getValue(FIELD_CHECKBOX);
            this.showMenuList(nodeId, metadata, isChecked);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String appId = this.getCurrentAppIdFromCache();
        String appName = this.getCurrentAppNameFromCache();
        AbstractGrid grid = (AbstractGrid)this.getControl(MENU_ENTRY);
        int index = grid.getEntryState().getFocusRow();
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
        if (e.getSource() instanceof MoveEntryUp) {
            this.moveEntryUp(e, index, appId, appMeta);
        } else if (e.getSource() instanceof MoveEntryDown) {
            this.moveEntryDown(e, index, appId, appMeta);
        }
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        Map nodeInfo = tree.getTreeState().getFocusNode();
        if (nodeInfo.get("id") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u83dc\u5355\u4f5c\u4e3a\u6dfb\u52a0\u6570\u636e\u7684\u7236\u83dc\u5355\u3002", (String)"AppMenuTreePlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        String nodeId = nodeInfo.get("id").toString();
        String nodeText = nodeInfo.get("text").toString();
        String parentNodeId = nodeInfo.get("parentid").toString();
        TreeNode root = new TreeNode("", appId, appName);
        AppMetadata appEditMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
        List<TreeNode> nodeList = this.getNodeList(appEditMeta);
        root.addChildren(nodeList);
        tree.updateNode(root);
        TreeNode newNode = new TreeNode(parentNodeId, nodeId, nodeText);
        tree.focusNode(newNode);
        tree.showNode(nodeId);
        tree.treeNodeClick(parentNodeId, nodeId);
        this.getPageCache().put(CACHE_ROOT, SerializationUtils.toJsonString((Object)root));
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        String appId = this.getCurrentAppIdFromCache();
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
        List appMenus = appMeta.getAppMenus();
        AppMenuElement menuElement = null;
        for (AppMenuElement menu : appMenus) {
            if (!nodeId.equals(menu.getId())) continue;
            menuElement = menu;
            break;
        }
        String menuNumber = menuElement == null ? CUSTOMIZED_MENU_FLAG : menuElement.getNumber();
        String nodeLevel = this.getPageCache().get(CACHE_NODE_LEVEL);
        Map nodeLevelMap = new HashMap(16);
        if (StringUtils.isNotBlank((CharSequence)nodeLevel)) {
            nodeLevelMap = (Map)SerializationUtils.fromJsonString((String)nodeLevel, Map.class);
        }
        if (nodeId.equals(appId)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_EDIT, BTN_DELETE});
            this.getView().setEnable(Boolean.TRUE, new String[]{BTN_NEW_SON});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{BTN_EDIT, BTN_DELETE, BTN_NEW_SON});
        }
        Integer nodeLevelVal = (Integer)nodeLevelMap.get(nodeId);
        if (nodeLevelVal != null && 2 == nodeLevelVal) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_NEW_SON});
        }
        if (nodeId.endsWith(HELP_CENTER_FLAG) || !menuNumber.endsWith(CUSTOMIZED_MENU_FLAG)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_NEW_SON, BTN_EDIT, BTN_DELETE});
        }
        boolean isChecked = (Boolean)this.getModel().getValue(FIELD_CHECKBOX);
        this.showMenuList(nodeId, appMeta, isChecked);
    }

    public void itemClick(ItemClickEvent evt) {
        String appId = this.getCurrentAppIdFromCache();
        String key = evt.getItemKey();
        if (BTN_NEW_SON.equals(key)) {
            this.addNode(appId, ResManager.loadKDString((String)"\u65b0\u589e\u5b50\u7ea7\u83dc\u5355", (String)"AppMenuTreePlugin_2", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        } else if (BTN_EDIT.equalsIgnoreCase(key)) {
            this.cacheCheckedL4NodeId(null);
            this.editNode(appId);
        } else if (BTN_DELETE.equalsIgnoreCase(key)) {
            this.deleteNode();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String appId = this.getCurrentAppIdFromCache();
        int rowIndex = e.getRowIndex();
        String menuId = this.getModel().getValue(FIELD_MENU_ID, rowIndex).toString();
        String menuParentId = this.getModel().getValue(FIELD_PARENT_MENU_ID, rowIndex).toString();
        if (menuId.equals(appId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0d\u8981\u9009\u62e9\u6839\u8282\u70b9\u3002", (String)"AppMenuTreePlugin_3", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)menuParentId)) {
            menuParentId = appId;
        }
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
        List appMenus = appMeta.getAppMenus();
        JSONArray appIds = this.getAppIdsFromCache(appId);
        boolean isParent = false;
        if (appIds.contains((Object)menuParentId)) {
            for (AppMenuElement appMenuElement : appMenus) {
                String metaMenuParentId = appMenuElement.getParentId();
                if (!metaMenuParentId.equals(menuId)) continue;
                isParent = true;
                break;
            }
        }
        HashMap<String, Object> operateMenu = new HashMap<String, Object>(4);
        operateMenu.put("nodeId", menuId);
        operateMenu.put("parentNodeId", menuParentId);
        operateMenu.put(CACHE_APP_ID, appId);
        operateMenu.put("isParent", isParent);
        HashMap<String, String> pageCacheMap = new HashMap<String, String>(4);
        pageCacheMap.put(CACHE_CHECKED_NODE_ID, menuId);
        pageCacheMap.put(CACHE_CHECKED_PARENT_NODE_ID, menuParentId);
        pageCacheMap.put(CACHE_APP_ID, appId);
        this.getPageCache().put(pageCacheMap);
        String menuName = this.getModel().getValue(FIELD_MENU_NAME, rowIndex).toString();
        this.cacheCheckedL4NodeId(menuName);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setFormId("dhc_appmenumeta");
        parameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u83dc\u5355", (String)"AppMenuTreePlugin_4", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        parameter.setCustomParams(operateMenu);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_EDIT));
        this.getView().showForm(parameter);
    }

    public void search(SearchEnterEvent evt) {
        List<TreeNode> nodes;
        String searchText = evt.getText();
        String cacheSearchNodes = this.getPageCache().get(CACHE_SEARCH_NODES);
        String cacheSearchText = this.getPageCache().get(CACHE_SEARCH_TEXT);
        if (searchText.equals(cacheSearchText)) {
            nodes = StringUtils.isNotBlank((CharSequence)cacheSearchNodes) ? SerializationUtils.fromJsonStringToList((String)cacheSearchNodes, TreeNode.class) : this.getSearchNodes(searchText);
        } else {
            nodes = this.getSearchNodes(searchText);
            this.getPageCache().put(CACHE_SEARCH_TEXT, searchText);
        }
        if (nodes != null && nodes.size() > 0) {
            TreeNode node = nodes.remove(0);
            String parentId = node.getParentid();
            TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
            tree.focusNode(node);
            tree.showNode(parentId);
            tree.treeNodeClick(parentId, node.getId());
            this.getPageCache().put(CACHE_SEARCH_NODES, SerializationUtils.toJsonString(nodes));
            if (nodes.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22", (String)"AppMenuTreePlugin_24", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                this.getPageCache().put(CACHE_SEARCH_NODES, "");
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u8282\u70b9\u3002", (String)"AppMenuTreePlugin_25", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (CALL_BACK_DELETE.equalsIgnoreCase(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            String appId = this.getCurrentAppIdFromCache();
            String[] ids = this.getPageCache().get(CACHE_DELETE_NODE_IDS).split("&");
            Boolean isDeleteOk = this.deleteNodeInfo(ids);
            if (isDeleteOk.booleanValue()) {
                TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_ROOT), TreeNode.class);
                TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
                Map nodeInfo = tree.getTreeState().getFocusNode();
                String parentNodeId = nodeInfo.get("parentid").toString();
                TreeNode parentNode = root.getTreeNode(parentNodeId, 2);
                String nodeId = nodeInfo.get("id").toString();
                root.deleteChildNode(nodeId);
                if (parentNode.getChildren().size() == 0) {
                    parentNode.setChildren(null);
                }
                this.getPageCache().put(CACHE_ROOT, SerializationUtils.toJsonString((Object)root));
                tree.updateNode(root);
                tree.focusNode(parentNode);
                TreeNodeEvent event = new TreeNodeEvent((Object)tree, (Object)"", (Object)parentNodeId);
                this.treeNodeClick(event);
                tree.showNode(parentNodeId);
                if (!parentNodeId.equals(appId)) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_NEW_SON});
                }
                String nodeLevelJson = this.getPageCache().get(CACHE_NODE_LEVEL);
                Map nodeLevel = (Map)SerializationUtils.fromJsonString((String)nodeLevelJson, Map.class);
                boolean isDeleteL4 = false;
                for (String id : ids) {
                    int level = (Integer)nodeLevel.get(id);
                    if (level != 1) continue;
                    isDeleteL4 = true;
                    break;
                }
                if (isDeleteL4) {
                    String menuName = (String)nodeInfo.get("text");
                    this.deleteL4BillClass(menuName);
                } else {
                    this.saveL4BillClass();
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u83dc\u5355\u5220\u9664\u6210\u529f\u3002", (String)"AppMenuTreePlugin_5", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83dc\u5355\u5220\u9664\u5931\u8d25\u3002", (String)"AppMenuTreePlugin_6", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        String appId = this.getCurrentAppIdFromCache();
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
        String appType = appMetadata.getDevType();
        String appName = this.getCurrentAppNameFromCache();
        TreeNode root = new TreeNode("", appId, appName);
        List<TreeNode> nodeList = this.getNodeList(appMetadata);
        root.addChildren(nodeList);
        if (evt.getReturnData() != null) {
            if (CALL_BACK_ADD.equalsIgnoreCase(actionId)) {
                this.addNewClosedCallBack(evt, appId, tree, root);
                this.saveL4BillClass();
            } else if (CALL_BACK_EDIT.equalsIgnoreCase(actionId)) {
                this.editClosedCallBack(evt, appId, tree, root, appType);
                this.saveL4BillClass();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.saveL4BillClass();
        IPageCache page = this.getPageCache();
        if (page.get(CACHE_APP_ID) != null) {
            page.remove(CACHE_APP_ID);
        }
        if (page.get(CACHE_APP_NAME) != null) {
            page.remove(CACHE_APP_NAME);
        }
        if (page.get(CACHE_ROOT) != null) {
            page.remove(CACHE_ROOT);
        }
        if (page.get(CACHE_NODE_LEVEL) != null) {
            page.remove(CACHE_NODE_LEVEL);
        }
        if (page.get(CACHE_CHECKED_NODE_ID) != null) {
            page.remove(CACHE_CHECKED_NODE_ID);
        }
        if (page.get(CACHE_CHECKED_PARENT_NODE_ID) != null) {
            page.remove(CACHE_CHECKED_PARENT_NODE_ID);
        }
        if (page.get(CACHE_DELETE_NODE_IDS) != null) {
            page.remove(CACHE_DELETE_NODE_IDS);
        }
        if (page.get(CACHE_CHECKED_L4NODE_NAME) != null) {
            page.remove(CACHE_CHECKED_L4NODE_NAME);
        }
    }

    private String getCurrentAppIdFromCache() {
        String appNumber = AppMetaServiceHelper.loadAppMetadataById((String)APP_NUMBER, (boolean)true).getAppElement().getNumber();
        this.logger.info("appNumber\uff1a" + appNumber);
        QFilter numberFilter = new QFilter("number", "=", (Object)appNumber);
        DynamicObject app = QueryServiceHelper.queryOne((String)BOS_DEV_PORTAL_BIZ_APP, (String)"id, name", (QFilter[])new QFilter[]{numberFilter});
        String appId = app == null ? null : app.getString("id");
        this.logger.info("appId\uff1a" + appId);
        this.getPageCache().put(CACHE_APP_ID, appId);
        String appName = app == null ? null : app.getString("name");
        this.getPageCache().put(CACHE_APP_NAME, appName);
        return appId;
    }

    private String getCurrentAppNameFromCache() {
        String appName = this.getPageCache().get(CACHE_APP_NAME);
        if (StringUtils.isEmpty((CharSequence)appName)) {
            QFilter numberFilter = new QFilter("number", "=", (Object)APP_NUMBER);
            DynamicObject app = QueryServiceHelper.queryOne((String)BOS_DEV_PORTAL_BIZ_APP, (String)"id, name", (QFilter[])new QFilter[]{numberFilter});
            appName = app == null ? null : app.getString("name");
            this.getPageCache().put(CACHE_APP_NAME, appName);
            String appId = app == null ? null : app.getString("id");
            this.getPageCache().put(CACHE_APP_ID, appId);
        }
        return appName;
    }

    private JSONArray getAppIdsFromCache(String appId) {
        JSONArray appIds;
        String appIdsJson = this.getPageCache().get(CACHE_APP_IDS);
        if (StringUtils.isBlank((CharSequence)appIdsJson)) {
            appIds = AppMenuUtil.getAppIds(appId);
            this.getPageCache().put(CACHE_APP_IDS, SerializationUtils.toJsonString((Object)appIds));
        } else {
            appIds = (JSONArray)SerializationUtils.fromJsonString((String)appIdsJson, JSONArray.class);
        }
        return appIds;
    }

    private void renderMenuTree(AppMetadata metadata) {
        String appId = this.getCurrentAppIdFromCache();
        String appName = this.getCurrentAppNameFromCache();
        TreeNode root = new TreeNode("", appId, appName);
        List<TreeNode> nodeList = this.getNodeList(metadata);
        this.logger.info("kd.fi.dhc.formplugin.AppMenuTreePlugin.renderMenuTree.nodeList:" + nodeList + "rootNodeId:" + appId + "rootNodeName" + appName);
        root.addChildren(nodeList);
        this.getPageCache().put(CACHE_ROOT, SerializationUtils.toJsonString((Object)root));
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        tree.addNode(root);
        tree.focusNode(root);
        TreeNodeEvent event = new TreeNodeEvent((Object)tree, (Object)"", (Object)appId);
        this.treeNodeClick(event);
        Map nodeInfo = tree.getTreeState().getFocusNode();
        this.logger.info("kd.fi.dhc.formplugin.AppMenuTreePlugin.renderMenuTree.nodeInfo:" + nodeInfo + "rootNodeId:" + appId);
        tree.showNode(appId);
    }

    private List<TreeNode> getNodeList(AppMetadata appMeta) {
        String appId = this.getCurrentAppIdFromCache();
        JSONArray appIds = this.getAppIdsFromCache(appId);
        List menuElements = appMeta.getAppMenus();
        List menuIds = menuElements.stream().map(AppMenuElement::getId).collect(Collectors.toList());
        ArrayList<TreeNode> firMenuList = new ArrayList<TreeNode>();
        for (AppMenuElement menuElement : menuElements) {
            String parentMenuId = menuElement.getParentId();
            if (!StringUtils.isBlank((CharSequence)parentMenuId) && !appIds.contains((Object)parentMenuId) && menuIds.contains(parentMenuId)) continue;
            String menuId = menuElement.getId();
            String menuName = (String)menuElement.getName().getDefaultItem();
            TreeNode treeNode = new TreeNode(appId, menuId, menuName);
            firMenuList.add(treeNode);
        }
        HashMap<String, Integer> nodeLevel = new HashMap<String, Integer>(16);
        this.getMenuTreeNode(menuElements, firMenuList, nodeLevel);
        this.getPageCache().put(CACHE_NODE_LEVEL, SerializationUtils.toJsonString(nodeLevel));
        return firMenuList;
    }

    private void getMenuTreeNode(List<AppMenuElement> menuElements, List<TreeNode> parentMenuList, Map<String, Integer> nodeLevel) {
        for (AppMenuElement menuElement : menuElements) {
            String parentMenuId = menuElement.getParentId();
            for (TreeNode parentNode : parentMenuList) {
                String parentNodeId = parentNode.getId();
                if (!parentNodeId.equals(parentMenuId)) continue;
                String menuId = menuElement.getId();
                String menuName = (String)menuElement.getName().getDefaultItem();
                TreeNode childNode = new TreeNode(parentMenuId, menuId, menuName, false);
                this.buildNode(parentNode, childNode);
                nodeLevel.put(menuId, 2);
            }
        }
        for (TreeNode node : parentMenuList) {
            nodeLevel.put(node.getId(), 1);
        }
    }

    private void showMenuList(String selectNodeId, AppMetadata appMeta, boolean isChecked) {
        Set<Map<String, Object>> selectedMenuInfos = this.getSelectedMenuInfos(selectNodeId, appMeta, isChecked);
        boolean hasHelpCenter = false;
        for (Map<String, Object> selectedMenuInfo : selectedMenuInfos) {
            String menuId = (String)selectedMenuInfo.get("id");
            if (!menuId.endsWith(HELP_CENTER_FLAG)) continue;
            hasHelpCenter = true;
        }
        int appNum = selectedMenuInfos.size();
        if (appNum > 0) {
            this.registerEntryGridListener(selectNodeId, hasHelpCenter, isChecked, appNum);
            this.getModel().deleteEntryData(MENU_ENTRY);
            this.getModel().batchCreateNewEntryRow(MENU_ENTRY, selectedMenuInfos.size());
            Iterator<Map<String, Object>> menuInfo = selectedMenuInfos.iterator();
            int i = 0;
            while (menuInfo.hasNext()) {
                String visible;
                Map<String, Object> menuJsonObject = menuInfo.next();
                this.getModel().setValue(FIELD_MENU_NAME, menuJsonObject.get("menuName"), i);
                this.getModel().setValue(FIELD_FORM_NAME, menuJsonObject.get("formName"), i);
                String openType = (String)menuJsonObject.get("openType");
                if ("0".equals(openType) || OPEN_TYPE_MAIN_NEW_TAB_PAGE.equals(openType) || StringUtils.isBlank((CharSequence)openType)) {
                    openType = ResManager.loadKDString((String)"\u65b0\u9875\u7b7e", (String)"AppMenuTreePlugin_7", (String)"fi-dhc-formplugin", (Object[])new Object[0]);
                }
                visible = "true".equals(visible = (String)menuJsonObject.get(FIELD_VISIBLE)) || "1".equals(visible) ? ResManager.loadKDString((String)"\u53ef\u89c1", (String)"AppMenuTreePlugin_8", (String)"fi-dhc-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u53ef\u89c1", (String)"AppMenuTreePlugin_9", (String)"fi-dhc-formplugin", (Object[])new Object[0]);
                this.getModel().setValue(FIELD_OPEN_TYPE, (Object)openType, i);
                this.getModel().setValue(FIELD_VISIBLE, (Object)visible, i);
                this.getModel().setValue(FIELD_MENU_ID, menuJsonObject.get("id"), i);
                this.getModel().setValue(FIELD_PARENT_MENU_ID, menuJsonObject.get("parentId"), i);
                this.getModel().setValue(FIELD_MENU_SEQ, menuJsonObject.get("menuSeq"), i);
                ++i;
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(MENU_ENTRY);
            entryGrid.setPageIndex(1);
        } else {
            this.getModel().deleteEntryData(MENU_ENTRY);
        }
    }

    private Set<Map<String, Object>> getSelectedMenuInfos(String selectNodeId, AppMetadata appMeta, boolean isChecked) {
        String appId = this.getCurrentAppIdFromCache();
        List menuElements = appMeta.getAppMenus();
        LinkedHashSet<Map<String, Object>> selectedMenuInfos = new LinkedHashSet<Map<String, Object>>();
        JSONArray appIds = this.getAppIdsFromCache(appId);
        List menuIds = menuElements.stream().map(AppMenuElement::getId).collect(Collectors.toList());
        for (AppMenuElement menuElement : menuElements) {
            String menuId = menuElement.getId();
            String parentMenuId = menuElement.getParentId();
            if (selectNodeId.equals(menuId)) {
                selectedMenuInfos.add(this.buildMenuInfo(menuElement));
                this.recursionMenuInfo(menuElements, selectedMenuInfos, menuId, isChecked);
                continue;
            }
            if (!selectNodeId.equals(appId) || !StringUtils.isBlank((CharSequence)parentMenuId) && !appIds.contains((Object)parentMenuId) && menuIds.contains(parentMenuId)) continue;
            selectedMenuInfos.add(this.buildMenuInfo(menuElement));
            if (!isChecked) continue;
            this.recursionMenuInfo(menuElements, selectedMenuInfos, menuId, true);
        }
        return selectedMenuInfos;
    }

    private void registerEntryGridListener(String selectNodeId, boolean hasHelpCenter, boolean isChecked, int appNum) {
        AbstractGrid grid = (AbstractGrid)this.getControl(MENU_ENTRY);
        EntryGrid entryGrid = (EntryGrid)grid;
        entryGrid.addPackageDataListener(e -> {
            block9: {
                List operationColItems;
                int seq;
                block10: {
                    seq = e.getRowData().getInt("seq");
                    if (!(e.getSource() instanceof OperationColumn) || !OPERATION_COLUMN.equalsIgnoreCase(((OperationColumn)e.getSource()).getKey())) break block9;
                    operationColItems = (List)e.getFormatValue();
                    if (!isChecked) break block10;
                    for (OperationColItem operationColItem : operationColItems) {
                        if (!MOVE_ENTRY_UP.equalsIgnoreCase(operationColItem.getOperationKey()) && !MOVE_ENTRY_DOWN.equalsIgnoreCase(operationColItem.getOperationKey())) continue;
                        operationColItem.setLocked(true);
                    }
                    break block9;
                }
                boolean isFirstLevel = this.isFirstLevel(selectNodeId);
                if (seq == 1) {
                    for (OperationColItem operationColItem : operationColItems) {
                        if (MOVE_ENTRY_UP.equalsIgnoreCase(operationColItem.getOperationKey())) {
                            operationColItem.setLocked(true);
                        }
                        if (!isFirstLevel || !MOVE_ENTRY_DOWN.equalsIgnoreCase(operationColItem.getOperationKey())) continue;
                        operationColItem.setLocked(true);
                    }
                }
                if (seq == 2 && isFirstLevel) {
                    for (OperationColItem operationColItem : operationColItems) {
                        if (!MOVE_ENTRY_UP.equalsIgnoreCase(operationColItem.getOperationKey())) continue;
                        operationColItem.setLocked(true);
                    }
                }
                if (seq == appNum - 1) {
                    for (OperationColItem operationColItem : operationColItems) {
                        if (!MOVE_ENTRY_DOWN.equalsIgnoreCase(operationColItem.getOperationKey()) || !hasHelpCenter) continue;
                        operationColItem.setLocked(true);
                    }
                }
                if (seq != appNum) break block9;
                for (OperationColItem operationColItem : operationColItems) {
                    if (!MOVE_ENTRY_DOWN.equalsIgnoreCase(operationColItem.getOperationKey()) && !hasHelpCenter) continue;
                    operationColItem.setLocked(true);
                }
            }
        });
    }

    private void recursionMenuInfo(List<AppMenuElement> menuElements, Set<Map<String, Object>> menuList, String filterMenuId, boolean isChecked) {
        for (AppMenuElement menuElement : menuElements) {
            String parentMenuId = menuElement.getParentId();
            if (!filterMenuId.equals(parentMenuId)) continue;
            String menuId = menuElement.getId();
            menuList.add(this.buildMenuInfo(menuElement));
            if (!isChecked) continue;
            this.recursionMenuInfo(menuElements, menuList, menuId, true);
        }
    }

    private Map<String, Object> buildMenuInfo(AppMenuElement menuElement) {
        HashMap<String, Object> menuInfo = new HashMap<String, Object>(16);
        String formId = menuElement.getFormId();
        String formNumber = menuElement.getFormNumber();
        String formName = this.getFormName(formNumber, formId);
        if ("dhc_menubill".equals(formNumber)) {
            Map param = (Map)SerializationUtils.fromJsonString((String)menuElement.getParameter(), Map.class);
            formNumber = param.getOrDefault("form", "");
        }
        menuInfo.put("formName", formName);
        menuInfo.put("formNumber", formNumber);
        menuInfo.put("menuName", menuElement.getName().getDefaultItem());
        menuInfo.put("openType", menuElement.getOpenType());
        menuInfo.put(FIELD_VISIBLE, menuElement.getVisible());
        menuInfo.put("parentId", menuElement.getParentId());
        menuInfo.put("id", menuElement.getId());
        menuInfo.put("menuSeq", menuElement.getSeq());
        return menuInfo;
    }

    private void buildNode(TreeNode parentNode, TreeNode childNode) {
        int seq = 0;
        if (parentNode.getChildren() != null) {
            seq = parentNode.getChildren().size();
        }
        parentNode.addChild(seq, childNode);
    }

    private void moveEntryUp(BeforeDoOperationEventArgs e, int index, String appId, AppMetadata appMeta) {
        JSONArray appIds = this.getAppIdsFromCache(appId);
        DynamicObject menuInfo = this.getModel().getEntryRowEntity(MENU_ENTRY, index);
        Integer currentSeq = menuInfo.getInt(FIELD_MENU_SEQ);
        String currentMenuId = menuInfo.getString(FIELD_MENU_ID);
        String currentParentMenuId = menuInfo.getString(FIELD_PARENT_MENU_ID);
        if (index <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u662f\u7b2c\u4e00\u884c\u3002", (String)"AppMenuTreePlugin_11", (String)"fi-dhc-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            e.setCancel(true);
        } else {
            DynamicObject beforeRow = this.getModel().getEntryRowEntity(MENU_ENTRY, index - 1);
            Integer beforeMenuSeq = beforeRow.getInt(FIELD_MENU_SEQ);
            String beforeMenuId = beforeRow.getString(FIELD_MENU_ID);
            String beforeParentMenuId = beforeRow.getString(FIELD_PARENT_MENU_ID);
            this.logger.info("AppMenuTreePlugin: \u5355\u636e\u884c\u7b2c" + currentSeq + "\u884c[" + menuInfo.getString(FIELD_MENU_NAME) + "]\u4e0a\u79fb\uff0c\u4e0a\u4e00\u884c\u662f[" + beforeRow.getString(FIELD_MENU_NAME) + "]");
            if (currentParentMenuId.equals(beforeMenuId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5728\u540c\u7ea7\u83dc\u5355\u4e0a\u79fb\u3002", (String)"AppMenuTreePlugin_12", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if ((StringUtils.isBlank((CharSequence)currentParentMenuId) || appIds.contains((Object)currentParentMenuId)) && StringUtils.isNotBlank((CharSequence)beforeParentMenuId) && !appIds.contains((Object)beforeParentMenuId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5728\u540c\u7ea7\u83dc\u5355\u4e0a\u79fb\u3002", (String)"AppMenuTreePlugin_12", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (beforeMenuSeq.equals(currentSeq)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u4e0e\u4e0a\u4e00\u884c\u83dc\u5355\u5e8f\u53f7\u4e00\u81f4\uff0c\u8bf7\u5728\u83dc\u5355\u4e2d\u8c03\u6574\u5e8f\u53f7\u3002", (String)"AppMenuTreePlugin_13", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            for (int i = 0; i < appMeta.getAppMenus().size(); ++i) {
                AppMenuElement menu = (AppMenuElement)appMeta.getAppMenus().get(i);
                String menuId = menu.getId();
                if (menuId.equals(currentMenuId)) {
                    menu.setSeq(beforeMenuSeq.shortValue());
                    continue;
                }
                if (!menuId.equals(beforeMenuId)) continue;
                menu.setSeq(currentSeq.shortValue());
            }
            Map saveResult = AppMetaServiceHelperExt.save((AppMetadata)appMeta);
            this.logger.info("AppMenuTreePlugin\uff1a\u4fdd\u5b58\u5355\u636e\u987a\u5e8f\u5b8c\u6bd5");
            this.logger.info("AppMenuTreePlugin\uff1asave result -> success[" + saveResult.get("success") + "], message[" + saveResult.get("message") + "]");
            e.setCancel(true);
        }
    }

    private void moveEntryDown(BeforeDoOperationEventArgs e, int index, String appId, AppMetadata appMeta) {
        JSONArray appIds = this.getAppIdsFromCache(appId);
        DynamicObject menuInfo = this.getModel().getEntryRowEntity(MENU_ENTRY, index);
        Integer currentSeq = menuInfo.getInt(FIELD_MENU_SEQ);
        String currentMenuId = menuInfo.getString(FIELD_MENU_ID);
        String currentParentMenuId = menuInfo.getString(FIELD_PARENT_MENU_ID);
        DynamicObject nextRow = this.getModel().getEntryRowEntity(MENU_ENTRY, index + 1);
        if (nextRow == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u662f\u6700\u540e\u4e00\u884c\u3002", (String)"AppMenuTreePlugin_14", (String)"fi-dhc-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            e.setCancel(true);
        } else {
            Integer nextMenuSeq = nextRow.getInt(FIELD_MENU_SEQ);
            String nextMenuId = nextRow.getString(FIELD_MENU_ID);
            String nextParentMenuId = nextRow.getString(FIELD_PARENT_MENU_ID);
            this.logger.info("AppMenuTreePlugin: \u5355\u636e\u884c\u7b2c" + currentSeq + "\u884c[" + menuInfo.getString(FIELD_MENU_NAME) + "]\u4e0b\u79fb\uff0c\u4e0b\u4e00\u884c\u662f[" + nextRow.getString(FIELD_MENU_NAME) + "]");
            if (currentMenuId.equals(nextParentMenuId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5728\u540c\u7ea7\u83dc\u5355\u79fb\u52a8\u3002", (String)"AppMenuTreePlugin_15", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)currentParentMenuId) && !appIds.contains((Object)currentParentMenuId) && (StringUtils.isBlank((CharSequence)nextParentMenuId) || appIds.contains((Object)nextParentMenuId))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5728\u540c\u7ea7\u83dc\u5355\u79fb\u52a8\u3002", (String)"AppMenuTreePlugin_15", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (nextMenuSeq.equals(currentSeq)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u4e0e\u4e0b\u4e00\u884c\u83dc\u5355\u5e8f\u53f7\u4e00\u81f4\uff0c\u8bf7\u5728\u83dc\u5355\u4e2d\u8c03\u6574\u5e8f\u53f7\u3002", (String)"AppMenuTreePlugin_16", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            for (int i = 0; i < appMeta.getAppMenus().size(); ++i) {
                AppMenuElement menu = (AppMenuElement)appMeta.getAppMenus().get(i);
                String menuId = menu.getId();
                if (menuId.equals(currentMenuId)) {
                    menu.setSeq(nextMenuSeq.shortValue());
                    continue;
                }
                if (!menuId.equals(nextMenuId)) continue;
                menu.setSeq(currentSeq.shortValue());
            }
            Map saveResult = AppMetaServiceHelperExt.save((AppMetadata)appMeta);
            this.logger.info("AppMenuTreePlugin\uff1a\u4fdd\u5b58\u5355\u636e\u987a\u5e8f\u5b8c\u6bd5");
            this.logger.info("AppMenuTreePlugin\uff1asave result -> success[" + saveResult.get("success") + "], message[" + saveResult.get("message") + "]");
            e.setCancel(true);
        }
    }

    private void addNode(String appId, String title) {
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        Map nodeInfo = tree.getTreeState().getFocusNode();
        if (nodeInfo.get("id") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u83dc\u5355\u3002", (String)"AppMenuTreePlugin_17", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        String nodeId = nodeInfo.get("id").toString();
        String parentNodeId = nodeInfo.get("parentid").toString();
        boolean isParent = nodeInfo.get("isParent") != null ? ((Boolean)nodeInfo.get("isParent")).booleanValue() : ((Boolean)nodeInfo.get("leaf")).booleanValue();
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("nodeId", nodeId);
        map.put("parentNodeId", parentNodeId);
        map.put("isParent", isParent);
        map.put(CACHE_APP_ID, appId);
        HashMap<String, String> pageCacheMap = new HashMap<String, String>(4);
        pageCacheMap.put(CACHE_CHECKED_NODE_ID, nodeId);
        pageCacheMap.put(CACHE_CHECKED_PARENT_NODE_ID, parentNodeId);
        pageCacheMap.put(CACHE_APP_ID, appId);
        this.getPageCache().put(pageCacheMap);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setFormId("dhc_appmenumeta");
        parameter.setCaption(title);
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_ADD));
        this.getView().showForm(parameter);
    }

    private void editNode(String appId) {
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        Map nodeInfo = tree.getTreeState().getFocusNode();
        if (nodeInfo.get("id") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u83dc\u5355\u4f5c\u4e3a\u6dfb\u52a0\u6570\u636e\u7684\u7236\u83dc\u5355\u3002", (String)"AppMenuTreePlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        String nodeId = nodeInfo.get("id").toString();
        if (nodeId.equals(appId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528\u8282\u70b9\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"AppMenuTreePlugin_18", (String)"fi-dhc-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            return;
        }
        String parentNodeId = nodeInfo.get("parentid").toString();
        boolean isParent = nodeInfo.get("isParent") != null ? ((Boolean)nodeInfo.get("isParent")).booleanValue() : ((Boolean)nodeInfo.get("leaf")).booleanValue();
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("nodeId", nodeId);
        map.put("parentNodeId", parentNodeId);
        map.put("isParent", isParent);
        map.put(CACHE_APP_ID, appId);
        HashMap<String, String> pageCacheMap = new HashMap<String, String>(4);
        pageCacheMap.put(CACHE_CHECKED_NODE_ID, nodeId);
        pageCacheMap.put(CACHE_CHECKED_PARENT_NODE_ID, parentNodeId);
        pageCacheMap.put(CACHE_APP_ID, appId);
        this.getPageCache().put(pageCacheMap);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setFormId("dhc_appmenumeta");
        parameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u83dc\u5355", (String)"AppMenuTreePlugin_4", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_EDIT));
        this.getView().showForm(parameter);
    }

    private void deleteNode() {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_ROOT), TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        Map nodeInfo = tree.getTreeState().getFocusNode();
        if (nodeInfo.get("id") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u5c06\u8981\u5220\u9664\u7684\u8282\u70b9\u3002", (String)"AppMenuTreePlugin_19", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        String nodeId = nodeInfo.get("id").toString();
        if (root.getId().equalsIgnoreCase(nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528\u8282\u70b9\u4e0d\u53ef\u5220\u9664\u3002", (String)"AppMenuTreePlugin_20", (String)"fi-dhc-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            return;
        }
        boolean isHaveLeaf = false;
        TreeNode checkedNode = root.getTreeNode(nodeId, 2);
        if (checkedNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e94\u7528\u8282\u70b9\u5df2\u5728\u5176\u5b83\u5730\u65b9\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5e94\u7528\u3002", (String)"AppMenuTreePlugin_27", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(nodeId);
        if (checkedNode.getChildren() != null) {
            isHaveLeaf = true;
            for (TreeNode childNode : checkedNode.getChildren()) {
                sb.append('&');
                sb.append(childNode.getId());
            }
        }
        this.getPageCache().put(CACHE_DELETE_NODE_IDS, sb.toString());
        if (isHaveLeaf) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u8be5\u83dc\u5355\u4ee5\u53ca\u5176\u5b50\u83dc\u5355\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"AppMenuTreePlugin_21", (String)"fi-dhc-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALL_BACK_DELETE));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u8be5\u83dc\u5355\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"AppMenuTreePlugin_22", (String)"fi-dhc-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALL_BACK_DELETE));
        }
    }

    private Boolean deleteNodeInfo(String[] idArr) {
        Boolean isDeleteOk;
        String appId = this.getCurrentAppIdFromCache();
        if (idArr == null || idArr.length == 0) {
            return Boolean.TRUE;
        }
        try {
            for (String id : idArr) {
                AppMetaServiceHelperExt.deleteMenuById((String)id, (String)appId);
            }
            isDeleteOk = Boolean.TRUE;
        }
        catch (Exception e) {
            String message = String.format("error:%s,", e.getMessage());
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{message});
        }
        return isDeleteOk;
    }

    private void addNewClosedCallBack(ClosedCallBackEvent evt, String appId, TreeView tree, TreeNode root) {
        Map returnDataMap = (Map)evt.getReturnData();
        String nodeId = (String)returnDataMap.get("menuId");
        String parentNodeId = (String)returnDataMap.get("parentMenuId");
        if (StringUtils.isBlank((CharSequence)parentNodeId)) {
            parentNodeId = appId;
        }
        String menuName = (String)returnDataMap.get("menuName");
        TreeNode newNode = new TreeNode(parentNodeId, nodeId, menuName);
        tree.addNode(newNode);
        newNode.setIsOpened(true);
        tree.updateNode(root);
        tree.focusNode(newNode);
        TreeNodeEvent event = new TreeNodeEvent((Object)tree, (Object)parentNodeId, (Object)nodeId);
        this.treeNodeClick(event);
        tree.showNode(nodeId);
        this.getPageCache().put(CACHE_ROOT, SerializationUtils.toJsonString((Object)root));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u83dc\u5355\u4fdd\u5b58\u6210\u529f", (String)"AppMenuTreePlugin_23", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
    }

    private void editClosedCallBack(ClosedCallBackEvent evt, String appId, TreeView tree, TreeNode root, String appType) {
        JSONArray inheritAppIds;
        Map returnDataMap = (Map)evt.getReturnData();
        String nodeId = this.getPageCache().get(CACHE_CHECKED_NODE_ID);
        String parentNodeId = (String)returnDataMap.get("parentMenuId");
        if (StringUtils.isBlank((CharSequence)parentNodeId)) {
            parentNodeId = appId;
        }
        if (EXT_FLAG.equals(appType) && (inheritAppIds = this.getAppIdsFromCache(appId)).contains((Object)parentNodeId)) {
            parentNodeId = appId;
        }
        String menuName = (String)returnDataMap.get("menuName");
        TreeNode newNode = new TreeNode(parentNodeId, nodeId, menuName);
        tree.addNode(newNode);
        newNode.setIsOpened(true);
        this.getPageCache().put(CACHE_ROOT, SerializationUtils.toJsonString((Object)root));
        tree.updateNode(root);
        tree.focusNode(newNode);
        TreeNodeEvent event = new TreeNodeEvent((Object)tree, (Object)parentNodeId, (Object)nodeId);
        this.treeNodeClick(event);
        tree.showNode(parentNodeId);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u83dc\u5355\u4fdd\u5b58\u6210\u529f", (String)"AppMenuTreePlugin_23", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
    }

    private List<TreeNode> getSearchNodes(String searchText) {
        ArrayList<TreeNode> res = new ArrayList<TreeNode>();
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_ROOT), TreeNode.class);
        List firstNode = root.getChildren();
        for (TreeNode firNode : firstNode) {
            List secondNode;
            String firText = firNode.getText();
            if (StringUtils.isNotEmpty((CharSequence)firText) && firText.contains(searchText)) {
                res.add(firNode);
            }
            if ((secondNode = firNode.getChildren()) == null) continue;
            for (TreeNode secNode : secondNode) {
                String secText = secNode.getText();
                if (!StringUtils.isNotEmpty((CharSequence)secText) || !secText.contains(searchText)) continue;
                res.add(secNode);
            }
        }
        return res;
    }

    private AppMetadata getMetadata() {
        String appId = this.getCurrentAppIdFromCache();
        if (appId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5e94\u7528ID\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u7cfb\u7edf\u65e5\u5fd7\u3002", (String)"AppMenuTreePlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            this.logger.error("kd.ssc.task.rbc.AppMenuTreePlugin.afterCreateNewData: \u6839\u636e\u5e94\u7528\u7f16\u7801 [dhc] \u67e5\u8be2\u5e94\u7528ID\u51fa\u9519\uff0c\u672a\u67e5\u51fa\u6570\u636e\uff01\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u5b58\u5728\u6216\u5e94\u7528\u7f16\u7801\u662f\u5426\u6b63\u786e\uff01");
            return null;
        }
        return AppMetaServiceHelper.loadAppMetadataById((String)appId, (boolean)false);
    }

    private void deleteL4BillClass(String menuName) {
        QFilter nameFilter = new QFilter("name", "=", (Object)menuName);
        DeleteServiceHelper.delete((String)"dhc_billclassification", (QFilter[])new QFilter[]{nameFilter});
    }

    private void saveL4BillClass() {
        List<TreeNode> l4NodeList;
        AppMetadata metadata = this.getMetadata();
        if (metadata != null && (l4NodeList = this.getBillNodeList(metadata)) != null && l4NodeList.size() > 0) {
            for (TreeNode node : l4NodeList) {
                String l4Name = "";
                ArrayList<String> l5billList = new ArrayList<String>();
                Set<Map<String, Object>> selectedMenuInfos = this.getSelectedMenuInfos(node.getId(), metadata, true);
                for (Map<String, Object> info : selectedMenuInfos) {
                    if (this.isFirstLevel((String)info.get("id"))) {
                        l4Name = (String)info.get("menuName");
                        continue;
                    }
                    l5billList.add((String)info.get("formNumber"));
                }
                this.deleteAndSaveL4Data(l4Name, l5billList);
            }
        }
    }

    private List<TreeNode> getBillNodeList(AppMetadata appMeta) {
        String appId = appMeta.getId();
        JSONArray appIds = this.getAppIdsFromCache(appId);
        List menuElements = appMeta.getAppMenus();
        ArrayList<TreeNode> menuTreeNode = new ArrayList<TreeNode>(8);
        for (AppMenuElement menuElement : menuElements) {
            String menuNumber;
            String parentMenuId = menuElement.getParentId();
            if (!StringUtils.isBlank((CharSequence)parentMenuId) && !appIds.contains((Object)parentMenuId) || (menuNumber = menuElement.getNumber()) == null || !menuNumber.endsWith(CUSTOMIZED_MENU_FLAG) || CUSTOMIZED_MENU_FLAG.equalsIgnoreCase(menuNumber)) continue;
            String menuId = menuElement.getId();
            String menuName = (String)menuElement.getName().getDefaultItem();
            TreeNode treeNode = new TreeNode(appId, menuId, menuName);
            menuTreeNode.add(treeNode);
        }
        HashMap<String, Integer> nodeLevel = new HashMap<String, Integer>(16);
        this.getMenuTreeNode(menuElements, menuTreeNode, nodeLevel);
        return menuTreeNode;
    }

    private void deleteAndSaveL4Data(String l4Name, List<String> l5billList) {
        if (StringUtils.isNotBlank((CharSequence)l4Name)) {
            QFilter[] l4qFilters = new QFilter[]{new QFilter("name", "=", (Object)l4Name)};
            QFilter[] l5qFilters = new QFilter[]{new QFilter("number", "in", l5billList)};
            DynamicObjectCollection billTypeId = QueryServiceHelper.query((String)"bos_entityobject", (String)"number", (QFilter[])l5qFilters);
            if (QueryServiceHelper.exists((String)"dhc_billclassification", (QFilter[])l4qFilters)) {
                DynamicObject data = BusinessDataServiceHelper.loadSingle((String)"dhc_billclassification", (String)EntityField.buildSelectField((String[])new String[]{"id", "entryentity.bill", "entryentity.billnew"}), (QFilter[])l4qFilters);
                DynamicObjectCollection entryEntity = data.getDynamicObjectCollection("entryentity");
                entryEntity.clear();
                for (DynamicObject dyo : billTypeId) {
                    String accessedbill;
                    DynamicObject entry = entryEntity.addNew();
                    DynamicObject billType = BusinessDataServiceHelper.loadSingle((Object)dyo.getString("number"), (String)"bos_entityobject");
                    entry.set("billnew", (Object)billType);
                    DynamicObject billaccess = BusinessDataServiceHelper.loadSingle((String)"dhc_billaccessed", (String)"accessedbill.id", (QFilter[])new QFilter[]{new QFilter("accessedbillnew", "=", (Object)dyo.getString("number"))});
                    if (null == billaccess || null == (accessedbill = billaccess.getString("accessedbill.id"))) continue;
                    DynamicObject billTypeOld = BusinessDataServiceHelper.loadSingle((Object)accessedbill, (String)BOS_FORM_META);
                    entry.set("bill", (Object)billTypeOld);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
            } else {
                String oldL4Name = this.getPageCache().get(CACHE_CHECKED_L4NODE_NAME);
                if (StringUtils.isNotBlank((CharSequence)oldL4Name)) {
                    DynamicObject data = BusinessDataServiceHelper.loadSingle((String)"dhc_billclassification", (String)EntityField.buildSelectField((String[])new String[]{"id", "entryentity.bill", "entryentity.billnew"}), (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)oldL4Name)});
                    DynamicObjectCollection entryEntity = null;
                    if (data != null) {
                        data.set("name", (Object)new LocaleString(l4Name));
                        entryEntity = data.getDynamicObjectCollection("entryentity");
                        if (entryEntity != null) {
                            entryEntity.clear();
                        }
                    }
                    for (DynamicObject dyo : billTypeId) {
                        if (entryEntity == null) continue;
                        DynamicObject entry = entryEntity.addNew();
                        DynamicObject billType = BusinessDataServiceHelper.loadSingle((Object)dyo.getString("number"), (String)"bos_entityobject");
                        entry.set("billnew", (Object)billType);
                    }
                    if (data != null) {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
                    }
                    this.getPageCache().remove(CACHE_CHECKED_L4NODE_NAME);
                } else {
                    DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"dhc_billclassification");
                    data.set("name", (Object)new LocaleString(l4Name));
                    data.set("enable", (Object)1);
                    data.set("status", (Object)"C");
                    DynamicObjectCollection entryEntity = data.getDynamicObjectCollection("entryentity");
                    for (DynamicObject dyo : billTypeId) {
                        DynamicObject entry = entryEntity.addNew();
                        DynamicObject billType = BusinessDataServiceHelper.loadSingle((Object)dyo.getString("number"), (String)"bos_entityobject");
                        entry.set("billnew", (Object)billType);
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
                }
            }
        }
    }

    private boolean isFirstLevel(String nodeId) {
        String nodeLevelJson = this.getPageCache().get(CACHE_NODE_LEVEL);
        Map nodeLevelMap = (Map)SerializationUtils.fromJsonString((String)nodeLevelJson, Map.class);
        Integer level = (Integer)nodeLevelMap.get(nodeId);
        return level != null && level == 1;
    }

    private void cacheCheckedL4NodeId(String menuName) {
        TreeView treeView = (TreeView)this.getControl(MENU_TREE);
        Map nodeInfo = treeView.getTreeState().getFocusNode();
        if (StringUtils.isNotBlank((CharSequence)menuName) || nodeInfo == null) {
            this.getPageCache().put(CACHE_CHECKED_L4NODE_NAME, menuName);
        } else {
            this.getPageCache().put(CACHE_CHECKED_L4NODE_NAME, (String)nodeInfo.get("text"));
        }
    }

    private String getFormName(String formNumber, String formId) {
        String formName = "";
        if (StringUtils.isNotBlank((CharSequence)formNumber)) {
            DynamicObject formDyo = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_BILL_MAIN_ENTITY, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)formNumber)});
            if (null != formDyo) {
                return formDyo.getString("name");
            }
            DynamicObject formDy = BusinessDataServiceHelper.loadSingleFromCache((Object)formId, (String)BOS_FORM_META);
            if (null != formDy) {
                return formDy.getLocaleString("name").getLocaleValue();
            }
            if (null == formDy && null == formDyo) {
                this.logger.error("kd.fi.dhc.formplugin.BillMappingMenuTreePlugin: \u6839\u636e\u8868\u5355Id [" + formNumber + "] \u83b7\u53d6\u8868\u5355\u5143\u6570\u636e\u51fa\u9519\uff01");
            }
        }
        return formName;
    }
}

