/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.dhc.constant.EntityField;
import kd.fi.dhc.enums.InitExeStatusEnum;
import kd.fi.dhc.runnable.MessagePublisher4Init;
import kd.fi.dhc.util.DataInitStatusUtil;
import kd.fi.dhc.util.DataSynchronizationUtil;
import kd.fi.hdc.cache.DhcDistributeCache;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class BillDataInitListPlugin
extends AbstractListPlugin {
    private static final String BTN_EXECUTE = "btn_execute";
    private static final String TOOL_BAR_AP = "toolbarap";
    private static final String BILL_LIST_AP = "billlistap";
    private static final String CALL_BACK_INIT = "call_back_init";
    private static final String CACHE_BILL_META_NUMBER = "cache_bill_meta_number";
    private static final String THREAD_NAME = "fi_dhc_bill_data_init";
    private static final String DHC_INIT_PROGRESS = "dhc_initprogress";
    private static final String BILLMAINENTITY = "bos_billmainentity";
    private static final String CALL_BACK_PROGRESS = "call_back_progress";
    private static final String OPT_KEY_EXCUTE = "execute_donothing";
    private static Log log = LogFactory.getLog(BillDataInitListPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BAR_AP});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_EXECUTE.equalsIgnoreCase(itemKey)) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl(BILL_LIST_AP)).getSelectedRows();
            if (selectedRows.isEmpty()) {
                return;
            }
            ArrayList<Object> rowIds = new ArrayList<Object>();
            for (ListSelectedRow row : selectedRows) {
                Object pkValue = row.getPrimaryKeyValue();
                rowIds.add(pkValue);
            }
            this.cacheSelectedBillMetaNumber(rowIds);
            boolean initFlag = this.isIncludeInitializedBill(rowIds);
            if (initFlag) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u5355\u636e\u4e2d\u6709\u6b63\u5728\u6267\u884c\u6216\u5b8c\u6210\u521d\u59cb\u5316\u7684\u5355\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u518d\u6b21\u6267\u884c\u521d\u59cb\u5316\u3002\u518d\u6b21\u6267\u884c\u5c06\u8986\u76d6\u539f\u6709\u7684\u5386\u53f2\u6570\u636e\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002", (String)"BillDataInitListPlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALL_BACK_INIT));
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u6267\u884c\u9009\u4e2d\u5355\u636e\u7684\u6570\u636e\u521d\u59cb\u5316\u64cd\u4f5c\u3002", (String)"BillDataInitListPlugin_2", (String)"fi-dhc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALL_BACK_INIT));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Donothing) {
            String optKey = ((Donothing)source).getOperateKey();
            if (OPT_KEY_EXCUTE.equals(optKey)) {
                return;
            }
            BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
            Object rowPkId = billList.getFocusRowPkId();
            QFilter idFilter = new QFilter("id", "=", rowPkId);
            DynamicObject dyn = QueryServiceHelper.queryOne((String)"dhc_billdatainit", (String)EntityField.buildSelectField((String[])new String[]{"bill.number", "initstatus"}), (QFilter[])new QFilter[]{idFilter});
            String initStatus = dyn.getString("initstatus");
            if (initStatus.equals("A")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u672a\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u67e5\u770b\u8fdb\u5ea6\u3002", (String)"BillDataInitListPlugin_4", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String formMetaNumber = dyn.getString("bill.number");
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCaption(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8fdb\u5ea6\u5c55\u793a", (String)"BillDataInitListPlugin_5", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            param.setFormId(DHC_INIT_PROGRESS);
            param.setCustomParam("fromMetaNumber", (Object)formMetaNumber);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALL_BACK_PROGRESS);
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (CALL_BACK_INIT.equalsIgnoreCase(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            String billMetaNumberJson = this.getPageCache().get(CACHE_BILL_META_NUMBER);
            List billMetaNumberList = (List)SerializationUtils.fromJsonString((String)billMetaNumberJson, List.class);
            String res = this.cacheDataAndUpdateTable(billMetaNumberList);
            if (res.equals("saveError")) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u3002", (String)"BillDataInitListPlugin_6", (String)"fi-dhc-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8bb0\u5f55\u4fdd\u5b58\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"BillDataInitListPlugin_8", (String)"fi-dhc-formplugin", (Object[])new Object[0]), MessageTypes.Default);
                return;
            }
            ThreadPools.executeOnce((String)THREAD_NAME, (Runnable)new MessagePublisher4Init());
            if (StringUtils.isNotBlank((CharSequence)res)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u3002", (String)"BillDataInitListPlugin_6", (String)"fi-dhc-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u521d\u59cb\u5316\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002\u5176\u4ed6\u5355\u636e\u6b63\u5e38\u521d\u59cb\u5316\uff0c\u4f60\u53ef\u4ee5\u5173\u95ed\u7a97\u53e3\uff0c\u521d\u59cb\u5316\u8fdb\u7a0b\u5c06\u6301\u7eed\u6267\u884c\u3002", (String)"BillDataInitListPlugin_7", (String)"fi-dhc-formplugin", (Object[])new Object[0]), res), MessageTypes.Default);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8fdb\u7a0b\u5df2\u5f00\u59cb\uff0c\u4f60\u53ef\u5173\u95ed\u7a97\u53e3\uff0c\u8fdb\u7a0b\u5c06\u6301\u7eed\u6267\u884c\u3002", (String)"BillDataInitListPlugin_3", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            }
            this.getView().updateView(BILL_LIST_AP);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (CALL_BACK_PROGRESS.equals(evt.getActionId())) {
            this.getView().updateView(BILL_LIST_AP);
        }
    }

    private void cacheSelectedBillMetaNumber(List<Object> rowIds) {
        QFilter idFilter = new QFilter("id", "in", rowIds);
        DynamicObjectCollection selectDynList = QueryServiceHelper.query((String)"dhc_billdatainit", (String)"bill.number", (QFilter[])new QFilter[]{idFilter});
        ArrayList<String> billMetaNumberList = new ArrayList<String>();
        for (DynamicObject dyn : selectDynList) {
            String billMetaNumber = dyn.getString("bill.number");
            billMetaNumberList.add(billMetaNumber);
        }
        String billMetaNumberJson = SerializationUtils.toJsonString(billMetaNumberList);
        this.getPageCache().put(CACHE_BILL_META_NUMBER, billMetaNumberJson);
    }

    private boolean isIncludeInitializedBill(List<Object> rowIds) {
        QFilter idFilter = new QFilter("id", "in", rowIds);
        DynamicObjectCollection selectedDynList = QueryServiceHelper.query((String)"dhc_billdatainit", (String)"initstatus", (QFilter[])new QFilter[]{idFilter});
        for (DynamicObject dyn : selectedDynList) {
            String initStatus = dyn.getString("initstatus");
            if (!initStatus.equals("B") && !initStatus.equals("D")) continue;
            return true;
        }
        return false;
    }

    private String cacheDataAndUpdateTable(List<String> billMetaNumberList) {
        String string;
        ArrayList billData = new ArrayList();
        Object[] billInitDataArr = new DynamicObject[billMetaNumberList.size()];
        Object[] initRecordArr = new DynamicObject[billMetaNumberList.size()];
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < billMetaNumberList.size(); ++i) {
            DynamicObject billInitData;
            String billMetaNumber = billMetaNumberList.get(i);
            String billId = null;
            try {
                DynamicObjectCollection billList;
                int billTotal;
                String selectField = "createtime";
                QFilter qFilter1 = new QFilter("createtime", "is not null", null);
                QFilter qFilter2 = null;
                if ("fa_dispatch_in".equals(billMetaNumber)) {
                    String[] billStatus = new String[]{"C", "D"};
                    qFilter2 = new QFilter("billstatus", "in", (Object)billStatus);
                }
                if ((billInitData = this.updateAndGetBillInitData(billMetaNumber, billTotal = (billList = QueryServiceHelper.query((String)"kd.fi.dhc.formplugin.BillDataInitListPlugin", (String)billMetaNumber, (String)selectField, (QFilter[])new QFilter[]{qFilter1, qFilter2}, (String)(selectField + " asc"))).size())) == null) {
                    if (res.length() > 0) {
                        res.append(", ");
                    }
                    res.append(this.queryBillMetaNameByNumber(billMetaNumber));
                    log.error("\u62a5\u8d26\u6570\u636e\u521d\u59cb\u5316\u53d1\u751f\u5f02\u5e38\uff0c\u62a5\u8d26\u6570\u636e\u521d\u59cb\u5316\u8868\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u3010" + billMetaNumber + "\u3011\u7684\u5355\u636e\uff01");
                    billId = DataSynchronizationUtil.getBillIdByBillMetaNumber((String)billMetaNumber);
                    billInitData = DataInitStatusUtil.setStatusAsExFail((String)billId);
                    billInitDataArr[i] = billInitData;
                } else {
                    billInitDataArr[i] = billInitData;
                }
                DynamicObject initRecord = this.createAndGetInitRecord(billMetaNumber, billTotal);
                if (initRecord == null) {
                    if (res.length() > 0) {
                        res.append(", ");
                    }
                    res.append(billMetaNumber);
                    log.error("\u62a5\u8d26\u6570\u636e\u521d\u59cb\u5316\u53d1\u751f\u5f02\u5e38\uff0c\u6839\u636e\u5355\u636e\u5143\u6570\u636e\u7f16\u7801\u3010" + billMetaNumber + "\u3011\u67e5\u4e0d\u5230\u5bf9\u5e94\u7684\u5355\u636e\u5143\u6570\u636e\uff01");
                } else {
                    initRecordArr[i] = initRecord;
                }
                if (billList.isEmpty()) continue;
                DynamicObject dyn = (DynamicObject)billList.get(0);
                Date createTime = dyn.getDate(selectField);
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                map.put(CACHE_BILL_META_NUMBER, billMetaNumber);
                map.put("cache_start_time", DateUtils.truncate((Date)createTime, (int)5));
                map.put("cache_finish_time", DateUtils.truncate((Date)new Date(), (int)5));
                billData.add(map);
                continue;
            }
            catch (Exception e) {
                log.error("\u7f13\u5b58\u5355\u636e" + billMetaNumber + "\u521d\u59cb\u5316\u6240\u9700\u8981\u7684\u6570\u636e\u5f02\u5e38\uff0c\u4e0b\u4e00\u7c7b\u5355\u636e\u7684\u521d\u59cb\u5316\u5c06\u7ee7\u7eed\u8fdb\u884c " + e.getMessage(), (Throwable)e);
                billId = DataSynchronizationUtil.getBillIdByBillMetaNumber((String)billMetaNumber);
                billInitData = DataInitStatusUtil.setStatusAsExFail((String)billId);
                billInitDataArr[i] = billInitData;
            }
        }
        Throwable throwable = null;
        try (TXHandle txHandle = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])billInitDataArr);
            SaveServiceHelper.save((DynamicObject[])initRecordArr);
            String billDataJson = SerializationUtils.toJsonString(billData);
            DhcDistributeCache.put((String)"cache_bill_data_4_init", (Object)billDataJson);
            this.getView().updateView(BILL_LIST_AP);
            string = res.toString();
            return string;
        }
        catch (Exception e) {
            txHandle.markRollback();
            log.error("BillDataInitListPlugin init data save error\uff1a" + e.getMessage() + "\u3002billInitDataArr\uff1a" + Arrays.toString(billInitDataArr) + ",initRecordArr:" + Arrays.toString(initRecordArr), (Throwable)e);
            string = "saveError";
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private DynamicObject updateAndGetBillInitData(String billMetaNumber, int billTotal) {
        QFilter billFilter = new QFilter("bill.number", "=", (Object)billMetaNumber);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"dhc_billdatainit", (QFilter[])new QFilter[]{billFilter});
        if (dyn == null) {
            return null;
        }
        if (billTotal > 0) {
            dyn.set("initstatus", (Object)"B");
        } else {
            dyn.set("initbegintime", (Object)new Date());
            dyn.set("initfinishtime", (Object)new Date());
            dyn.set("initstatus", (Object)"D");
        }
        return dyn;
    }

    private DynamicObject createAndGetInitRecord(String billMetaNumber, int billTotal) {
        QFilter numberFilter = new QFilter("number", "=", (Object)billMetaNumber);
        List idList = QueryServiceHelper.queryPrimaryKeys((String)BILLMAINENTITY, (QFilter[])new QFilter[]{numberFilter}, null, (int)1);
        if (idList.isEmpty()) {
            return null;
        }
        DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"dhc_datainitrecord");
        dyn.set("bill", idList.get(0));
        dyn.set("billtotal", (Object)billTotal);
        dyn.set("createtime", (Object)new Date());
        if (billTotal > 0) {
            dyn.set("exestatus", (Object)InitExeStatusEnum.IN_EXECUTION.getValue());
        } else {
            dyn.set("exestatus", (Object)InitExeStatusEnum.EXE_SUCCESS.getValue());
            dyn.set("finishtime", (Object)new Date());
        }
        return dyn;
    }

    private String queryBillMetaNameByNumber(String billMetaNumber) {
        QFilter numberFilter = new QFilter("number", "=", (Object)billMetaNumber);
        DynamicObject formMeta = BusinessDataServiceHelper.loadSingleFromCache((String)BILLMAINENTITY, (QFilter[])new QFilter[]{numberFilter});
        if (formMeta == null) {
            return "";
        }
        return formMeta.getString("name");
    }
}

